/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.ws.FrameData;
import akka.http.impl.engine.ws.FrameError;
import akka.http.impl.engine.ws.FrameEvent;
import akka.http.impl.engine.ws.FrameEventOrError;
import akka.http.impl.engine.ws.FrameHeader;
import akka.http.impl.engine.ws.FrameStart;
import akka.http.impl.engine.ws.ProtocolException;
import akka.http.impl.util.LogByteStringTools$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.Graph;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class FrameLogger$ {
    public static final FrameLogger$ MODULE$ = new FrameLogger$();

    public final int maxBytes() {
        return 16;
    }

    public BidiFlow<FrameEventOrError, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> logFramesIfEnabled(boolean shouldLog) {
        return shouldLog ? this.bidi() : BidiFlow$.MODULE$.identity();
    }

    public BidiFlow<FrameEventOrError, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> bidi() {
        Flow qual$1 = Flow$.MODULE$.apply();
        String x$1 = new StringBuilder(13).append("\u001b[31m").append("DOWN").append("\u001b[0m").toString();
        Function1 & Serializable x$2 = (Function1 & Serializable)frameEvent -> MODULE$.logEvent((FrameEventOrError)frameEvent);
        LoggingAdapter x$3 = qual$1.log$default$3(x$1, (Function1)x$2);
        Flow qual$2 = Flow$.MODULE$.apply();
        String x$4 = new StringBuilder(13).append("\u001b[32m").append(" UP ").append("\u001b[0m").toString();
        Function1 & Serializable x$5 = (Function1 & Serializable)frameEvent -> MODULE$.logEvent((FrameEventOrError)frameEvent);
        LoggingAdapter x$6 = qual$2.log$default$3(x$4, (Function1)x$5);
        return BidiFlow$.MODULE$.fromFlows((Graph)qual$1.log(x$1, (Function1)x$2, x$3), (Graph)qual$2.log(x$4, (Function1)x$5, x$6)).addAttributes(Attributes$.MODULE$.apply((Attributes.Attribute)new Attributes.LogLevels(Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel())));
    }

    public String logEvent(FrameEventOrError frameEvent) {
        String string;
        FrameEventOrError frameEventOrError = frameEvent;
        if (frameEventOrError instanceof FrameStart) {
            FrameStart frameStart = (FrameStart)frameEventOrError;
            FrameHeader header = frameStart.header();
            ByteString data = frameStart.data();
            string = FrameLogger$.displayLogEntry$1(header.opcode().short(), header.length(), FrameLogger$.hex$1(data), frameStart.lastPart(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{FrameLogger$.flag$1(header.fin(), "FIN"), FrameLogger$.flag$1(header.rsv1(), "RSV1"), FrameLogger$.flag$1(header.rsv2(), "RSV2"), FrameLogger$.flag$1(header.rsv3(), "RSV3")}));
        } else if (frameEventOrError instanceof FrameData) {
            FrameData frameData = (FrameData)frameEventOrError;
            ByteString data = frameData.data();
            boolean lastPart = frameData.lastPart();
            string = FrameLogger$.displayLogEntry$1("DATA", 0L, FrameLogger$.hex$1(data), lastPart, (Seq)Nil$.MODULE$);
        } else if (frameEventOrError instanceof FrameError) {
            FrameError frameError = (FrameError)frameEventOrError;
            ProtocolException ex = frameError.p();
            String arg$macro$1 = "\u001b[31m";
            String arg$macro$2 = ex.getMessage();
            String arg$macro$3 = "\u001b[0m";
            string = StringOps$.MODULE$.format$extension("%sError: %s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3}));
        } else {
            throw new MatchError((Object)frameEventOrError);
        }
        return string;
    }

    private static final String displayLogEntry$1(String frameType, long length, String data, boolean lastPart, Seq flags) {
        String string;
        String f;
        String string2 = f = flags.nonEmpty() ? new StringBuilder(6).append(" ").append("\u001b[31m").append(((IterableOnceOps)flags.flatten(Predef$.MODULE$.$conforms())).mkString(" ")).toString() : "";
        if (length > 0L) {
            String arg$macro$1 = "\u001b[33m";
            long arg$macro$2 = length;
            string = StringOps$.MODULE$.format$extension(" %s%d bytes", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToLong((long)arg$macro$2)}));
        } else {
            string = "";
        }
        String l = string;
        String arg$macro$3 = "\u001b[32m";
        String arg$macro$4 = frameType;
        String arg$macro$5 = f;
        String arg$macro$6 = l;
        String arg$macro$7 = "\u001b[0m";
        String arg$macro$8 = data;
        String arg$macro$9 = !lastPart ? " ..." : "";
        return StringOps$.MODULE$.format$extension("%s%s%s%s%s %s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3, arg$macro$4, arg$macro$5, arg$macro$6, arg$macro$7, arg$macro$8, arg$macro$9}));
    }

    private static final Option flag$1(boolean value, String name) {
        return value ? new Some((Object)name) : None$.MODULE$;
    }

    private static final String hex$1(ByteString bytes) {
        int num = package$.MODULE$.min(16, bytes.size());
        String ellipsis = num < bytes.size() ? new StringBuilder(18).append(" [... ").append(bytes.size() - num).append(" more bytes]").toString() : "";
        ByteString first = bytes.take(num);
        String h = ((IterableOnceOps)first.map((Function1 & Serializable)x$1 -> Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))), "%02x"))).mkString(" ");
        String ascii = ((IterableOnceOps)first.map((Function1 & Serializable)b -> BoxesRunTime.boxToCharacter((char)LogByteStringTools$.MODULE$.asASCII(BoxesRunTime.unboxToByte((Object)b))))).mkString();
        return new StringBuilder(21).append("\u001b[37m").append(h).append("\u001b[0m").append(" | ").append("\u001b[37m").append(ascii).append("\u001b[0m").append(ellipsis).toString();
    }

    private FrameLogger$() {
    }
}

