/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.compress;

import akka.actor.Address;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.remote.artery.ArterySettings;
import akka.remote.artery.InboundContext;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.compress.CompressionTable;
import akka.remote.artery.compress.CompressionTable$;
import akka.remote.artery.compress.CountMinSketch;
import akka.remote.artery.compress.DecompressionTable;
import akka.remote.artery.compress.DecompressionTable$;
import akka.remote.artery.compress.InboundCompression$;
import akka.remote.artery.compress.InboundCompression$Tables$;
import akka.remote.artery.compress.TopHeavyHitters;
import akka.remote.artery.compress.UnknownCompressedIdException;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\reuAB\"E\u0011\u0003AEJ\u0002\u0004O\t\"\u0005\u0001j\u0014\u0005\u0006-\u0006!\t\u0001\u0017\u0005\b3\u0006\u0011\r\u0011\"\u0002[\u0011\u0019i\u0016\u0001)A\u00077\u001e)a,\u0001E\u0001?\u001a)\u0011-\u0001E\u0001E\")aK\u0002C\u0001W\")AN\u0002C\u0001[\"I!1\u0005\u0004\u0002\u0002\u0013\u0005%Q\u0005\u0005\n\u0005\u00032\u0011\u0011!CA\u0005\u0007B\u0011B!\u0019\u0007\u0003\u0003%IAa\u0019\u0007\t\u0005\f!\t\u001d\u0005\u000b\u0003\u0003a!Q3A\u0005\u0002\u0005\r\u0001BCA\u0014\u0019\tE\t\u0015!\u0003\u0002\u0006!Q\u0011\u0011\u0006\u0007\u0003\u0016\u0004%\t!a\u000b\t\u0015\u00055BB!E!\u0002\u0013\tY\u0001\u0003\u0006\u000201\u0011)\u001a!C\u0001\u0003WA!\"!\r\r\u0005#\u0005\u000b\u0011BA\u0006\u0011)\t\u0019\u0004\u0004BK\u0002\u0013\u0005\u0011Q\u0007\u0005\u000b\u0003\u0007b!\u0011#Q\u0001\n\u0005]\u0002BCA#\u0019\tU\r\u0011\"\u0001\u0002H!Q\u0011q\n\u0007\u0003\u0012\u0003\u0006I!!\u0013\t\rYcA\u0011AA)\u0011\u001d\ty\u0006\u0004C\u0001\u0003CBq!a\u001d\r\t\u0003\t)\bC\u0005\u0002x1\t\t\u0011\"\u0001\u0002z!I\u0011Q\u0013\u0007\u0012\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003cc\u0011\u0013!C\u0001\u0003gC\u0011\"a/\r#\u0003%\t!!0\t\u0013\u0005\u0005G\"%A\u0005\u0002\u0005\r\u0007\"CAf\u0019E\u0005I\u0011AAg\u0011%\t)\u000eDA\u0001\n\u0003\n9\u000eC\u0005\u0002f2\t\t\u0011\"\u0001\u0002H!I\u0011q\u001d\u0007\u0002\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003_d\u0011\u0011!C!\u0003cD\u0011\"a@\r\u0003\u0003%\tA!\u0001\t\u0013\t-A\"!A\u0005B\t5\u0001\"\u0003B\t\u0019\u0005\u0005I\u0011\tB\n\u0011%\u0011)\u0002DA\u0001\n\u0003\u00129\u0002C\u0005\u0003\u001a1\t\t\u0011\"\u0011\u0003\u001c\u00199a\nRA\u0001\u0011\n-\u0004B\u0003B8S\t\u0015\r\u0011\"\u0001\u0003r!Q!qP\u0015\u0003\u0002\u0003\u0006IAa\u001d\t\u0015\t\u0005\u0015F!b\u0001\n\u0003\u0011\u0019\t\u0003\u0006\u0003\u0016&\u0012\t\u0011)A\u0005\u0005\u000bC!Ba&*\u0005\u000b\u0007I\u0011\u0001BM\u0011)\u0011\t+\u000bB\u0001B\u0003%!1\u0014\u0005\u000b\u0005GK#\u0011!Q\u0001\n\t\u0015\u0006B\u0003BVS\t\u0015\r\u0011\"\u0001\u0003.\"Q!\u0011Y\u0015\u0003\u0002\u0003\u0006IAa,\t\rYKC\u0011\u0001Bb\u0011!\u0011\t.\u000bQ!\n\tM\u0007\u0002\u0003BlS\u0001\u0006KAa\u0001\t\u0011\t\u0005\u0018\u0006)Q\u0005\u0003\u0013B\u0001Ba9*A\u0003%\u0011\u0011\n\u0005\t\u0005KL\u0003\u0015!\u0003\u0003h\"9!Q^\u0015\u0007\u0002\t=\bbBB\u0001S\u0011\u001511\u0001\u0005\b\u0007/ICQAB\r\u0011\u001d\u0019I#\u000bC\u0001\u0007WAqa!\u0014*\t\u0013\u0019y\u0005\u0003\u0005\u0004X%\"\t\u0001SB-\u0011\u001d\u0019Y&\u000bD\t\u0007;Bqaa\u001c*\t\u0013\u0019\t\bC\u0004\u0004x%\"\tb!\u001f\t\u000f\tU\u0011\u0006\"\u0011\u0004\u0014\u0006\u0011\u0012J\u001c2pk:$7i\\7qe\u0016\u001c8/[8o\u0015\t)e)\u0001\u0005d_6\u0004(/Z:t\u0015\t9\u0005*\u0001\u0004beR,'/\u001f\u0006\u0003\u0013*\u000baA]3n_R,'\"A&\u0002\t\u0005\\7.\u0019\t\u0003\u001b\u0006i\u0011\u0001\u0012\u0002\u0013\u0013:\u0014w.\u001e8e\u0007>l\u0007O]3tg&|gn\u0005\u0002\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\t1+A\u0003tG\u0006d\u0017-\u0003\u0002V%\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002\u0019\u0006\u00192*Z3q\u001f2$G+\u00192mKNtU/\u001c2feV\t1lD\u0001];\u0005\u0019\u0011\u0001F&fKB|E\u000e\u001a+bE2,7OT;nE\u0016\u0014\b%\u0001\u0004UC\ndWm\u001d\t\u0003A\u001ai\u0011!\u0001\u0002\u0007)\u0006\u0014G.Z:\u0014\u0007\u0019\u00016\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006\u0011\u0011n\u001c\u0006\u0002Q\u0006!!.\u0019<b\u0013\tQWM\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001`\u0003\u0015)W\u000e\u001d;z+\rq'\u0011E\u000b\u0002_B!\u0001\r\u0004B\u0010+\r\t\u0018QC\n\u0005\u0019A\u0013X\u000f\u0005\u0002Rg&\u0011AO\u0015\u0002\b!J|G-^2u!\t1hP\u0004\u0002xy:\u0011\u0001p_\u0007\u0002s*\u0011!pV\u0001\u0007yI|w\u000e\u001e \n\u0003MK!! *\u0002\u000fA\f7m[1hK&\u0011!n \u0006\u0003{J\u000b\u0011b\u001c7e)\u0006\u0014G.Z:\u0016\u0005\u0005\u0015\u0001#\u0002<\u0002\b\u0005-\u0011bAA\u0005\u007f\n!A*[:u!\u0015i\u0015QBA\t\u0013\r\ty\u0001\u0012\u0002\u0013\t\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8UC\ndW\r\u0005\u0003\u0002\u0014\u0005UA\u0002\u0001\u0003\b\u0003/a!\u0019AA\r\u0005\u0005!\u0016\u0003BA\u000e\u0003C\u00012!UA\u000f\u0013\r\tyB\u0015\u0002\b\u001d>$\b.\u001b8h!\r\t\u00161E\u0005\u0004\u0003K\u0011&aA!os\u0006Qq\u000e\u001c3UC\ndWm\u001d\u0011\u0002\u0017\u0005\u001cG/\u001b<f)\u0006\u0014G.Z\u000b\u0003\u0003\u0017\tA\"Y2uSZ,G+\u00192mK\u0002\n\u0011B\\3yiR\u000b'\r\\3\u0002\u00159,\u0007\u0010\u001e+bE2,\u0007%A\fbIZ,'\u000f^5tK6,g\u000e^%o!J|wM]3tgV\u0011\u0011q\u0007\t\u0006#\u0006e\u0012QH\u0005\u0004\u0003w\u0011&AB(qi&|g\u000eE\u0003N\u0003\u007f\t\t\"C\u0002\u0002B\u0011\u0013\u0001cQ8naJ,7o]5p]R\u000b'\r\\3\u00021\u0005$g/\u001a:uSN,W.\u001a8u\u0013:\u0004&o\\4sKN\u001c\b%A\u0007lK\u0016\u0004x\n\u001c3UC\ndWm]\u000b\u0003\u0003\u0013\u00022!UA&\u0013\r\tiE\u0015\u0002\u0004\u0013:$\u0018AD6fKB|E\u000e\u001a+bE2,7\u000f\t\u000b\r\u0003'\n)&a\u0016\u0002Z\u0005m\u0013Q\f\t\u0005A2\t\t\u0002C\u0004\u0002\u0002]\u0001\r!!\u0002\t\u000f\u0005%r\u00031\u0001\u0002\f!9\u0011qF\fA\u0002\u0005-\u0001bBA\u001a/\u0001\u0007\u0011q\u0007\u0005\b\u0003\u000b:\u0002\u0019AA%\u0003-\u0019X\r\\3diR\u000b'\r\\3\u0015\t\u0005\r\u0014q\u000e\t\u0007\u0003K\nY'a\u0003\u000e\u0005\u0005\u001d$bAA5\u0015\u0006!Q\u000f^5m\u0013\u0011\ti'a\u001a\u0003\u0013=\u0003H/[8o-\u0006d\u0007bBA91\u0001\u0007\u0011\u0011J\u0001\bm\u0016\u00148/[8o\u0003M\u0019H/\u0019:u+NLgn\u001a(fqR$\u0016M\u00197f)\t\t\u0019&\u0001\u0003d_BLX\u0003BA>\u0003\u0003#B\"! \u0002\u0004\u0006%\u00151RAG\u0003'\u0003B\u0001\u0019\u0007\u0002\u0000A!\u00111CAA\t\u001d\t9B\u0007b\u0001\u00033A\u0011\"!\u0001\u001b!\u0003\u0005\r!!\"\u0011\u000bY\f9!a\"\u0011\u000b5\u000bi!a \t\u0013\u0005%\"\u0004%AA\u0002\u0005\u001d\u0005\"CA\u00185A\u0005\t\u0019AAD\u0011%\t\u0019D\u0007I\u0001\u0002\u0004\ty\tE\u0003R\u0003s\t\t\nE\u0003N\u0003\u007f\ty\bC\u0005\u0002Fi\u0001\n\u00111\u0001\u0002J\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT\u0003BAM\u0003_+\"!a'+\t\u0005\u0015\u0011QT\u0016\u0003\u0003?\u0003B!!)\u0002,6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0016*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0006\r&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u0011qC\u000eC\u0002\u0005e\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0005\u0003k\u000bI,\u0006\u0002\u00028*\"\u00111BAO\t\u001d\t9\u0002\bb\u0001\u00033\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0003\u00026\u0006}FaBA\f;\t\u0007\u0011\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\u0011\t)-!3\u0016\u0005\u0005\u001d'\u0006BA\u001c\u0003;#q!a\u0006\u001f\u0005\u0004\tI\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\t\u0005=\u00171[\u000b\u0003\u0003#TC!!\u0013\u0002\u001e\u00129\u0011qC\u0010C\u0002\u0005e\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002ZB!\u00111\\Aq\u001b\t\tiNC\u0002\u0002`\u001e\fA\u0001\\1oO&!\u00111]Ao\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0011\u0003WD\u0011\"!<#\u0003\u0003\u0005\r!!\u0013\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0010\u0005\u0004\u0002v\u0006m\u0018\u0011E\u0007\u0003\u0003oT1!!?S\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\f9P\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0002\u0005\u0013\u00012!\u0015B\u0003\u0013\r\u00119A\u0015\u0002\b\u0005>|G.Z1o\u0011%\ti\u000fJA\u0001\u0002\u0004\t\t#\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAm\u0005\u001fA\u0011\"!<&\u0003\u0003\u0005\r!!\u0013\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0013\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!7\u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019A!\b\t\u0013\u00055\b&!AA\u0002\u0005\u0005\u0002\u0003BA\n\u0005C!q!a\u0006\t\u0005\u0004\tI\"A\u0003baBd\u00170\u0006\u0003\u0003(\t5B\u0003\u0004B\u0015\u0005_\u0011)Da\u000e\u0003:\t}\u0002\u0003\u00021\r\u0005W\u0001B!a\u0005\u0003.\u00119\u0011qC\u0005C\u0002\u0005e\u0001bBA\u0001\u0013\u0001\u0007!\u0011\u0007\t\u0006m\u0006\u001d!1\u0007\t\u0006\u001b\u00065!1\u0006\u0005\b\u0003SI\u0001\u0019\u0001B\u001a\u0011\u001d\ty#\u0003a\u0001\u0005gAq!a\r\n\u0001\u0004\u0011Y\u0004E\u0003R\u0003s\u0011i\u0004E\u0003N\u0003\u007f\u0011Y\u0003C\u0004\u0002F%\u0001\r!!\u0013\u0002\u000fUt\u0017\r\u001d9msV!!Q\tB+)\u0011\u00119Ea\u0017\u0011\u000bE\u000bID!\u0013\u0011\u001bE\u0013YEa\u0014\u0003R\tE#qKA%\u0013\r\u0011iE\u0015\u0002\u0007)V\u0004H.Z\u001b\u0011\u000bY\f9A!\u0015\u0011\u000b5\u000biAa\u0015\u0011\t\u0005M!Q\u000b\u0003\b\u0003/Q!\u0019AA\r!\u0015\t\u0016\u0011\bB-!\u0015i\u0015q\bB*\u0011%\u0011iFCA\u0001\u0002\u0004\u0011y&A\u0002yIA\u0002B\u0001\u0019\u0007\u0003T\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!Q\r\t\u0005\u00037\u00149'\u0003\u0003\u0003j\u0005u'AB(cU\u0016\u001cG/\u0006\u0003\u0003n\t]6CA\u0015Q\u0003\rawnZ\u000b\u0003\u0005g\u0002BA!\u001e\u0003|5\u0011!q\u000f\u0006\u0004\u0005sR\u0015!B3wK:$\u0018\u0002\u0002B?\u0005o\u0012a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013\u0001C:fiRLgnZ:\u0016\u0005\t\u0015\u0005\u0003\u0002BD\u0005\u001fsAA!#\u0003\f6\ta)C\u0002\u0003\u000e\u001a\u000ba\"\u0011:uKJL8+\u001a;uS:<7/\u0003\u0003\u0003\u0012\nM%aC\"p[B\u0014Xm]:j_:T1A!$G\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%A\u0005pe&<\u0017N\\+jIV\u0011!1\u0014\t\u0004#\nu\u0015b\u0001BP%\n!Aj\u001c8h\u0003)y'/[4j]VKG\rI\u0001\u000fS:\u0014w.\u001e8e\u0007>tG/\u001a=u!\u0011\u0011IIa*\n\u0007\t%fI\u0001\bJ]\n|WO\u001c3D_:$X\r\u001f;\u0002\u0019!,\u0017M^=ISR$XM]:\u0016\u0005\t=\u0006#B'\u00032\nU\u0016b\u0001BZ\t\nyAk\u001c9IK\u00064\u0018\u0010S5ui\u0016\u00148\u000f\u0005\u0003\u0002\u0014\t]FaBA\fS\t\u0007!\u0011X\t\u0005\u0005w\u000b\t\u0003E\u0002R\u0005{K1Aa0S\u0005\u0011qU\u000f\u001c7\u0002\u001b!,\u0017M^=ISR$XM]:!)1\u0011)Ma2\u0003J\n-'Q\u001aBh!\u0011i\u0015F!.\t\u000f\t=4\u00071\u0001\u0003t!9!\u0011Q\u001aA\u0002\t\u0015\u0005b\u0002BLg\u0001\u0007!1\u0014\u0005\b\u0005G\u001b\u0004\u0019\u0001BS\u0011\u001d\u0011Yk\ra\u0001\u0005_\u000ba\u0001^1cY\u0016\u001c\b#\u0002Bk\u0019\tUfBA'\u0001\u0003\u0015\tG.\u001b<fQ\r)$1\u001c\t\u0004#\nu\u0017b\u0001Bp%\nAao\u001c7bi&dW-A\u0006sKN,g\u000eZ\"pk:$\u0018AD7bqJ+7/\u001a8e\u0007>,h\u000e^\u0001\u0004G6\u001c\bcA'\u0003j&\u0019!1\u001e#\u0003\u001d\r{WO\u001c;NS:\u001c6.\u001a;dQ\u0006QA-Z2p[B\u0014Xm]:\u0015\r\tE(1\u001fB\u007f!\u0019\t)'a\u001b\u00036\"9!Q_\u001dA\u0002\t]\u0018\u0001F5oG>l\u0017N\\4UC\ndWMV3sg&|g\u000eE\u0002R\u0005sL1Aa?S\u0005\u0011\u0011\u0015\u0010^3\t\u000f\t}\u0018\b1\u0001\u0002J\u0005\u0019\u0011\u000e\u001a=\u0002%\u0011,7m\\7qe\u0016\u001c8/\u00138uKJt\u0017\r\u001c\u000b\t\u0005c\u001c)aa\u0002\u0004\n!9!Q\u001f\u001eA\u0002\t]\bb\u0002B\u0000u\u0001\u0007\u0011\u0011\n\u0005\b\u0007\u0017Q\u0004\u0019AA%\u00039\tG\u000f^3naR\u001cu.\u001e8uKJD3AOB\b!\u0011\u0019\tba\u0005\u000e\u0005\u0005\u001d\u0016\u0002BB\u000b\u0003O\u0013q\u0001^1jYJ,7-\u0001\u000bd_:4\u0017N]7BIZ,'\u000f^5tK6,g\u000e\u001e\u000b\u0007\u00077\u0019\tc!\n\u0011\u0007E\u001bi\"C\u0002\u0004 I\u0013A!\u00168ji\"911E\u001eA\u0002\t]\u0018\u0001\u0004;bE2,g+\u001a:tS>t\u0007bBB\u0014w\u0001\u0007!1A\u0001\u0007O\u00064X-\u00169\u0002\u0013%t7M]3nK:$H\u0003CB\u000e\u0007[\u0019)e!\u0013\t\u000f\r=B\b1\u0001\u00042\u0005i!/Z7pi\u0016\fE\r\u001a:fgN\u0004Baa\r\u0004:5\u00111Q\u0007\u0006\u0004\u0007oQ\u0015!B1di>\u0014\u0018\u0002BB\u001e\u0007k\u0011q!\u00113ee\u0016\u001c8\u000f\u000b\u0003\u0004.\r}\u0002\u0003BA3\u0007\u0003JAaa\u0011\u0002h\t1QO\\;tK\u0012Dqaa\u0012=\u0001\u0004\u0011),A\u0003wC2,X\rC\u0004\u0004Lq\u0002\rAa'\u0002\u00039\f\u0001%\u00193e\u0003:$7\t[3dW&3\u0007.Z1ws\"KG\u000f^3s\t\u0016$Xm\u0019;fIR1!1AB)\u0007'Bqaa\u0012>\u0001\u0004\u0011)\fC\u0004\u0004Vu\u0002\rAa'\u0002\u000b\r|WO\u001c;\u00023I,hNT3yiR\u000b'\r\\3BIZ,'\u000f^5tK6,g\u000e\u001e\u000b\u0003\u00077\t\u0011$\u00193wKJ$\u0018n]3D_6\u0004(/Z:tS>tG+\u00192mKR111DB0\u0007SBqa!\u0019@\u0001\u0004\u0019\u0019'A\u0006bgN|7-[1uS>t\u0007\u0003\u0002BE\u0007KJ1aa\u001aG\u0005=yU\u000f\u001e2pk:$7i\u001c8uKb$\bbBB6\u007f\u0001\u00071QN\u0001\u0006i\u0006\u0014G.\u001a\t\u0006\u001b\u0006}\"QW\u0001 aJ,\u0007/\u0019:f\u0007>l\u0007O]3tg&|g.\u00113wKJ$\u0018n]3nK:$H\u0003BB7\u0007gBqa!\u001eA\u0001\u0004\u001190\u0001\toKb$H+\u00192mKZ+'o]5p]\u0006Q\"-^5mIR\u000b'\r\\3G_J\fEM^3si&\u001cX-\\3oiR!11PBF!!\u0019ih!\"\u00036\u0006%c\u0002BB@\u0007\u0003\u0003\"\u0001\u001f*\n\u0007\r\r%+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007\u000f\u001bIIA\u0002NCBT1aa!S\u0011\u001d\u0019i)\u0011a\u0001\u0007\u001f\u000b\u0001\"\u001a7f[\u0016tGo\u001d\t\u0006m\u000eE%QW\u0005\u0004\u0003{|HCABK!\u0011\u0019iha&\n\t\u0005\r8\u0011\u0012")
public abstract class InboundCompression<T> {
    private final LoggingAdapter log;
    private final ArterySettings.Compression settings;
    private final long originUid;
    private final InboundContext inboundContext;
    private final TopHeavyHitters<T> heavyHitters;
    private Tables<T> tables;
    private volatile boolean alive;
    private int resendCount;
    private final int maxResendCount;
    private final CountMinSketch cms;

    public static int KeepOldTablesNumber() {
        return InboundCompression$.MODULE$.KeepOldTablesNumber();
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public ArterySettings.Compression settings() {
        return this.settings;
    }

    public long originUid() {
        return this.originUid;
    }

    public TopHeavyHitters<T> heavyHitters() {
        return this.heavyHitters;
    }

    public abstract T decompress(byte var1, int var2);

    public final T decompressInternal(byte incomingTableVersion, int idx, int attemptCounter) {
        Object object;
        block5: {
            Object object2;
            block6: {
                byte activeVersion;
                Tables<T> current;
                while (true) {
                    DecompressionTable decompressionTable;
                    if (attemptCounter > 2) {
                        throw new IllegalStateException(new StringBuilder(52).append("Unable to decompress ").append(idx).append(" from table ").append(incomingTableVersion).append(". Internal tables: ").append(this.tables).toString());
                    }
                    current = this.tables;
                    activeVersion = current.activeTable().version();
                    if (incomingTableVersion == DecompressionTable$.MODULE$.DisabledVersion()) {
                        OptionVal$.MODULE$.None();
                        object = null;
                        break block5;
                    }
                    DecompressionTable<T> decompressionTable2 = current.selectTable(incomingTableVersion);
                    if (new OptionVal(decompressionTable2) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.unapply(decompressionTable2)))) {
                        DecompressionTable selectedTable = (DecompressionTable)OptionVal$.MODULE$.get$extension((Object)decompressionTable);
                        Object value = selectedTable.get(idx);
                        if (value == null) {
                            throw new UnknownCompressedIdException(idx);
                        }
                        object2 = OptionVal.Some$.MODULE$.apply(value);
                        break block6;
                    }
                    if (!InboundCompression.incomingVersionIsAdvertisementInProgress$1(incomingTableVersion, current)) break;
                    this.log().debug("Received first value from originUid [{}] compressed using the advertised compression table, flipping to it (version: {})", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()));
                    this.confirmAdvertisement(incomingTableVersion, false);
                    ++attemptCounter;
                }
                this.log().warning("Inbound message from originUid [{}] is using unknown compression table version. It may have been sent with compression table built for previous incarnation of this system. Versions activeTable: {}, nextTable: {}, incomingTable: {}", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)activeVersion), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()), (Object)BoxesRunTime.boxToByte((byte)incomingTableVersion));
                OptionVal$.MODULE$.None();
                object2 = null;
            }
            object = object2;
        }
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void confirmAdvertisement(byte tableVersion, boolean gaveUp) {
        CompressionTable inProgress;
        boolean bl = false;
        Some some = null;
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CompressionTable inProgress2 = (CompressionTable)some.value();
            if (tableVersion == inProgress2.version()) {
                this.tables = this.tables.startUsingNextTable();
                this.log().debug("{} compression table version [{}] for originUid [{}]", (Object)(gaveUp ? "Gave up" : "Confirmed"), (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && tableVersion != (inProgress = (CompressionTable)some.value()).version()) {
            this.log().debug("{} compression table version [{}] for originUid [{}] but other version in progress [{}]", (Object)(gaveUp ? "Gave up" : "Confirmed"), (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void increment(Address remoteAddress, T value, long n) {
        long count = this.cms.addObjectAndEstimateCount(value, n);
        this.addAndCheckIfheavyHitterDetected(value, count);
        this.alive = true;
    }

    private boolean addAndCheckIfheavyHitterDetected(T value, long count) {
        return this.heavyHitters().update(value, count);
    }

    public void runNextTableAdvertisement() {
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (None$.MODULE$.equals(option)) {
            OutboundContext outboundContext;
            OutboundContext outboundContext2 = this.inboundContext.association(this.originUid());
            if (new OptionVal((Object)outboundContext2) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(outboundContext = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext2)))) {
                BoxedUnit boxedUnit;
                OutboundContext association = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext);
                if (this.alive && association.isOrdinaryMessageStreamActive()) {
                    CompressionTable<T> table = this.prepareCompressionAdvertisement(this.tables.nextTable().version());
                    Tables<T> qual$1 = this.tables;
                    DecompressionTable<T> x$1 = table.invert();
                    Some x$2 = new Some(table);
                    List<DecompressionTable<T>> x$3 = qual$1.copy$default$1();
                    DecompressionTable<T> x$4 = qual$1.copy$default$2();
                    int x$5 = qual$1.copy$default$5();
                    Tables<T> nextState = qual$1.copy(x$3, x$4, x$1, (Option<CompressionTable<T>>)x$2, x$5);
                    this.tables = nextState;
                    this.alive = false;
                    this.resendCount = 0;
                    this.advertiseCompressionTable(association, table);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (association.isOrdinaryMessageStreamActive()) {
                    this.log().debug("{} for originUid [{}] not changed, no need to advertise same.", (Object)Logging$.MODULE$.simpleName(this.tables.activeTable()), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this.log().debug("No Association for originUid [{}] yet, unable to advertise compression table.", (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            CompressionTable inProgress = (CompressionTable)some.value();
            ++this.resendCount;
            if (this.resendCount <= this.maxResendCount) {
                OutboundContext outboundContext;
                OutboundContext outboundContext3 = this.inboundContext.association(this.originUid());
                if (new OptionVal((Object)outboundContext3) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(outboundContext = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext3)))) {
                    OutboundContext association = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext);
                    this.log().debug("Advertisement in progress for originUid [{}] version [{}], resending [{}:{}]", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()), (Object)BoxesRunTime.boxToInteger((int)this.resendCount), (Object)BoxesRunTime.boxToInteger((int)this.maxResendCount));
                    this.advertiseCompressionTable(association, inProgress);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.log().debug("Advertisement in progress for originUid [{}] version [{}] but no confirmation after retries.", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
                this.confirmAdvertisement(inProgress.version(), true);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
    }

    public abstract void advertiseCompressionTable(OutboundContext var1, CompressionTable<T> var2);

    private CompressionTable<T> prepareCompressionAdvertisement(byte nextTableVersion) {
        Map<T, Object> mappings = this.buildTableForAdvertisement(this.heavyHitters().iterator());
        return CompressionTable$.MODULE$.apply(this.originUid(), nextTableVersion, mappings);
    }

    public Map<T, Object> buildTableForAdvertisement(Iterator<T> elements) {
        Builder mb = Predef$.MODULE$.Map().newBuilder();
        mb.$plus$plus$eq((IterableOnce)elements.zipWithIndex());
        return (Map)mb.result();
    }

    public String toString() {
        return new StringBuilder(34).append(Logging$.MODULE$.simpleName(this.getClass())).append("(countMinSketch: ").append(this.cms).append(", heavyHitters: ").append(this.heavyHitters()).append(")").toString();
    }

    private static final boolean incomingVersionIsAdvertisementInProgress$1(byte incomingTableVersion, Tables current$1) {
        return current$1.advertisementInProgress().isDefined() && incomingTableVersion == ((CompressionTable)current$1.advertisementInProgress().get()).version();
    }

    public InboundCompression(LoggingAdapter log, ArterySettings.Compression settings, long originUid, InboundContext inboundContext, TopHeavyHitters<T> heavyHitters) {
        this.log = log;
        this.settings = settings;
        this.originUid = originUid;
        this.inboundContext = inboundContext;
        this.heavyHitters = heavyHitters;
        this.tables = InboundCompression$Tables$.MODULE$.empty();
        this.alive = true;
        this.resendCount = 0;
        this.maxResendCount = 3;
        this.cms = new CountMinSketch(16, 1024, (int)System.currentTimeMillis());
        log.debug("Initializing {} for originUid [{}]", (Object)Logging$.MODULE$.simpleName(this.getClass()), (Object)BoxesRunTime.boxToLong((long)originUid));
    }

    public static final class Tables<T>
    implements Product,
    Serializable {
        private final List<DecompressionTable<T>> oldTables;
        private final DecompressionTable<T> activeTable;
        private final DecompressionTable<T> nextTable;
        private final Option<CompressionTable<T>> advertisementInProgress;
        private final int keepOldTables;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public List<DecompressionTable<T>> oldTables() {
            return this.oldTables;
        }

        public DecompressionTable<T> activeTable() {
            return this.activeTable;
        }

        public DecompressionTable<T> nextTable() {
            return this.nextTable;
        }

        public Option<CompressionTable<T>> advertisementInProgress() {
            return this.advertisementInProgress;
        }

        public int keepOldTables() {
            return this.keepOldTables;
        }

        /*
         * WARNING - void declaration
         */
        public DecompressionTable<T> selectTable(int version) {
            DecompressionTable decompressionTable;
            if (this.activeTable().version() == version) {
                decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.apply(this.activeTable());
            } else {
                void var2_2;
                DecompressionTable found = this.find$1(this.oldTables(), version);
                decompressionTable = var2_2;
            }
            return decompressionTable;
        }

        public Tables<T> startUsingNextTable() {
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            byte x$1 = Tables.incrementTableVersion$1(this.nextTable().version());
            long x$2 = qual$1.copy$default$1();
            Object x$3 = qual$1.copy$default$3();
            return new Tables<T>(this.oldTables().$colon$colon(decompressionTable).take(this.keepOldTables()), this.nextTable(), qual$1.copy(x$2, x$1, x$3), None$.MODULE$, this.keepOldTables());
        }

        public <T> Tables<T> copy(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            return new Tables<T>(oldTables, activeTable, nextTable, advertisementInProgress, keepOldTables);
        }

        public <T> List<DecompressionTable<T>> copy$default$1() {
            return this.oldTables();
        }

        public <T> DecompressionTable<T> copy$default$2() {
            return this.activeTable();
        }

        public <T> DecompressionTable<T> copy$default$3() {
            return this.nextTable();
        }

        public <T> Option<CompressionTable<T>> copy$default$4() {
            return this.advertisementInProgress();
        }

        public <T> int copy$default$5() {
            return this.keepOldTables();
        }

        public String productPrefix() {
            return "Tables";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.oldTables();
                    break;
                }
                case 1: {
                    object = this.activeTable();
                    break;
                }
                case 2: {
                    object = this.nextTable();
                    break;
                }
                case 3: {
                    object = this.advertisementInProgress();
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.keepOldTables());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Tables;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "oldTables";
                    break;
                }
                case 1: {
                    string = "activeTable";
                    break;
                }
                case 2: {
                    string = "nextTable";
                    break;
                }
                case 3: {
                    string = "advertisementInProgress";
                    break;
                }
                case 4: {
                    string = "keepOldTables";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.oldTables()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.activeTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.nextTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.advertisementInProgress()));
            n = Statics.mix((int)n, (int)this.keepOldTables());
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Tables)) return false;
            boolean bl = true;
            if (!bl) return false;
            Tables tables = (Tables)x$1;
            if (this.keepOldTables() != tables.keepOldTables()) return false;
            List<DecompressionTable<T>> list = this.oldTables();
            List<DecompressionTable<T>> list2 = tables.oldTables();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable<T> decompressionTable2 = tables.activeTable();
            if (decompressionTable == null) {
                if (decompressionTable2 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable).equals(decompressionTable2)) return false;
            DecompressionTable<T> decompressionTable3 = this.nextTable();
            DecompressionTable<T> decompressionTable4 = tables.nextTable();
            if (decompressionTable3 == null) {
                if (decompressionTable4 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable3).equals(decompressionTable4)) return false;
            Option<CompressionTable<T>> option = this.advertisementInProgress();
            Option<CompressionTable<T>> option2 = tables.advertisementInProgress();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        private final DecompressionTable find$1(List tables, int version$1) {
            DecompressionTable decompressionTable;
            block2: {
                List list;
                block3: {
                    DecompressionTable t;
                    while (true) {
                        list = tables;
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list2 = list;
                        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                            OptionVal$.MODULE$.None();
                            decompressionTable = null;
                            break block2;
                        }
                        if (!(list instanceof .colon.colon)) break block3;
                        .colon.colon colon2 = (.colon.colon)list;
                        t = (DecompressionTable)colon2.head();
                        List tail = colon2.next$access$1();
                        if (t.version() == version$1) break;
                        tables = tail;
                    }
                    decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.apply((Object)t);
                    break block2;
                }
                throw new MatchError((Object)list);
            }
            return decompressionTable;
        }

        private static final byte incrementTableVersion$1(byte version) {
            return version == 127 ? (byte)0 : (byte)(version + 1);
        }

        public Tables(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            this.oldTables = oldTables;
            this.activeTable = activeTable;
            this.nextTable = nextTable;
            this.advertisementInProgress = advertisementInProgress;
            this.keepOldTables = keepOldTables;
            Product.$init$((Product)this);
        }
    }
}

