/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2.framing;

import akka.annotation.InternalApi;
import akka.http.impl.engine.http2.ByteFlag$;
import akka.http.impl.engine.http2.FrameEvent;
import akka.http.impl.engine.http2.Http2Protocol;
import akka.http.impl.engine.http2.Http2Protocol$Flags$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$CONTINUATION$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$DATA$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$GOAWAY$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$HEADERS$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$PING$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$PRIORITY$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$PUSH_PROMISE$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$RST_STREAM$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$SETTINGS$;
import akka.http.impl.engine.http2.Http2Protocol$FrameType$WINDOW_UPDATE$;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;

@InternalApi
public final class FrameRenderer$ {
    public static final FrameRenderer$ MODULE$ = new FrameRenderer$();
    private static final ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public ByteOrder byteOrder() {
        return byteOrder;
    }

    public ByteString render(FrameEvent frame) {
        ByteString byteString;
        FrameEvent frameEvent = frame;
        if (frameEvent instanceof FrameEvent.GoAwayFrame) {
            FrameEvent.GoAwayFrame goAwayFrame = (FrameEvent.GoAwayFrame)frameEvent;
            int lastStreamId = goAwayFrame.lastStreamId();
            Http2Protocol.ErrorCode errorCode = goAwayFrame.errorCode();
            ByteString debug = goAwayFrame.debug();
            ByteStringBuilder bb = new ByteStringBuilder();
            bb.putInt(lastStreamId, this.byteOrder());
            bb.putInt(errorCode.id(), this.byteOrder());
            bb.append(debug);
            byteString = this.renderFrame(Http2Protocol$FrameType$GOAWAY$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), 0, bb.result());
        } else if (frameEvent instanceof FrameEvent.DataFrame) {
            FrameEvent.DataFrame dataFrame = (FrameEvent.DataFrame)frameEvent;
            int streamId = dataFrame.streamId();
            boolean endStream = dataFrame.endStream();
            ByteString payload = dataFrame.payload();
            byteString = this.renderFrame(Http2Protocol$FrameType$DATA$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream), streamId, payload);
        } else if (frameEvent instanceof FrameEvent.HeadersFrame) {
            FrameEvent.HeadersFrame headersFrame = (FrameEvent.HeadersFrame)frameEvent;
            int streamId = headersFrame.streamId();
            boolean endStream = headersFrame.endStream();
            boolean endHeaders = headersFrame.endHeaders();
            ByteString headerBlockFragment = headersFrame.headerBlockFragment();
            Option<FrameEvent.PriorityFrame> prioInfo = headersFrame.priorityInfo();
            ByteString renderedPrioInfo = (ByteString)prioInfo.map((Function1 & Serializable)priorityFrame -> MODULE$.renderPriorityInfo((FrameEvent.PriorityFrame)priorityFrame)).getOrElse((Function0 & Serializable)() -> ByteString$.MODULE$.empty());
            byteString = this.renderFrame(Http2Protocol$FrameType$HEADERS$.MODULE$, ByteFlag$.MODULE$.$bar$extension(ByteFlag$.MODULE$.$bar$extension(ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream), ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders)), ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.PRIORITY(), prioInfo.isDefined())), streamId, renderedPrioInfo.$plus$plus(headerBlockFragment));
        } else if (frameEvent instanceof FrameEvent.WindowUpdateFrame) {
            FrameEvent.WindowUpdateFrame windowUpdateFrame = (FrameEvent.WindowUpdateFrame)frameEvent;
            int streamId = windowUpdateFrame.streamId();
            int windowSizeIncrement = windowUpdateFrame.windowSizeIncrement();
            ByteStringBuilder bb = new ByteStringBuilder();
            bb.putInt(windowSizeIncrement, this.byteOrder());
            byteString = this.renderFrame(Http2Protocol$FrameType$WINDOW_UPDATE$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId, bb.result());
        } else if (frameEvent instanceof FrameEvent.ContinuationFrame) {
            FrameEvent.ContinuationFrame continuationFrame = (FrameEvent.ContinuationFrame)frameEvent;
            int streamId = continuationFrame.streamId();
            boolean endHeaders = continuationFrame.endHeaders();
            ByteString payload = continuationFrame.payload();
            byteString = this.renderFrame(Http2Protocol$FrameType$CONTINUATION$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders), streamId, payload);
        } else if (frameEvent instanceof FrameEvent.SettingsFrame) {
            FrameEvent.SettingsFrame settingsFrame = (FrameEvent.SettingsFrame)frameEvent;
            Seq<FrameEvent.Setting> settings = settingsFrame.settings();
            ByteStringBuilder bb = new ByteStringBuilder();
            this.renderNext$1(settings, bb);
            byteString = this.renderFrame(Http2Protocol$FrameType$SETTINGS$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), 0, bb.result());
        } else if (frameEvent instanceof FrameEvent.SettingsAckFrame) {
            byteString = this.renderFrame(Http2Protocol$FrameType$SETTINGS$.MODULE$, Http2Protocol$Flags$.MODULE$.ACK(), 0, ByteString$.MODULE$.empty());
        } else if (frameEvent instanceof FrameEvent.PingFrame) {
            FrameEvent.PingFrame pingFrame = (FrameEvent.PingFrame)frameEvent;
            boolean ack = pingFrame.ack();
            ByteString data = pingFrame.data();
            byteString = this.renderFrame(Http2Protocol$FrameType$PING$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.ACK(), ack), 0, data);
        } else if (frameEvent instanceof FrameEvent.RstStreamFrame) {
            FrameEvent.RstStreamFrame rstStreamFrame = (FrameEvent.RstStreamFrame)frameEvent;
            int streamId = rstStreamFrame.streamId();
            Http2Protocol.ErrorCode errorCode = rstStreamFrame.errorCode();
            byteString = this.renderFrame(Http2Protocol$FrameType$RST_STREAM$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId, new ByteStringBuilder().putInt(errorCode.id(), this.byteOrder()).result());
        } else if (frameEvent instanceof FrameEvent.PushPromiseFrame) {
            FrameEvent.PushPromiseFrame pushPromiseFrame = (FrameEvent.PushPromiseFrame)frameEvent;
            int streamId = pushPromiseFrame.streamId();
            boolean endHeaders = pushPromiseFrame.endHeaders();
            int promisedStreamId = pushPromiseFrame.promisedStreamId();
            ByteString headerBlockFragment = pushPromiseFrame.headerBlockFragment();
            byteString = this.renderFrame(Http2Protocol$FrameType$PUSH_PROMISE$.MODULE$, ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders), streamId, new ByteStringBuilder().putInt(promisedStreamId, this.byteOrder()).append(headerBlockFragment).result());
        } else if (frameEvent instanceof FrameEvent.PriorityFrame) {
            FrameEvent.PriorityFrame priorityFrame2 = (FrameEvent.PriorityFrame)frameEvent;
            int streamId = priorityFrame2.streamId();
            byteString = this.renderFrame(Http2Protocol$FrameType$PRIORITY$.MODULE$, Http2Protocol$Flags$.MODULE$.NO_FLAGS(), streamId, this.renderPriorityInfo(priorityFrame2));
        } else {
            throw new IllegalStateException(new StringBuilder(23).append("Unexpected frame type ").append(frame.frameTypeName()).append(".").toString());
        }
        return byteString;
    }

    public ByteString renderFrame(Http2Protocol.FrameType tpe, int flags, int streamId, ByteString payload) {
        int length = payload.length();
        byte[] headerBytes = new byte[]{(byte)(length >> 16), (byte)(length >> 8), (byte)(length >> 0), (byte)tpe.id(), (byte)flags, (byte)(streamId >> 24), (byte)(streamId >> 16), (byte)(streamId >> 8), (byte)(streamId >> 0)};
        return ByteString.ByteString1C$.MODULE$.apply(headerBytes).$plus$plus(payload);
    }

    public ByteString renderPriorityInfo(FrameEvent.PriorityFrame priorityFrame) {
        int exclusiveBit = priorityFrame.exclusiveFlag() ? Integer.MIN_VALUE : 0;
        return new ByteStringBuilder().putInt(exclusiveBit | priorityFrame.streamDependency(), this.byteOrder()).putByte((byte)priorityFrame.weight()).result();
    }

    private final void renderNext$1(Seq remaining, ByteStringBuilder bb$1) {
        Option option;
        Seq seq;
        while ((seq = remaining) != null && !(option = package$.MODULE$.$plus$colon().unapply((SeqOps)seq)).isEmpty()) {
            FrameEvent.Setting setting = (FrameEvent.Setting)((Tuple2)option.get())._1();
            Seq remaining2 = (Seq)((Tuple2)option.get())._2();
            if (setting == null) break;
            Http2Protocol.SettingIdentifier id = setting.identifier();
            int value = setting.value();
            bb$1.putShort(id.id(), this.byteOrder());
            bb$1.putInt(value, this.byteOrder());
            remaining = remaining2;
        }
        if (!Nil$.MODULE$.equals(seq)) {
            throw new MatchError((Object)seq);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private FrameRenderer$() {
    }
}

