/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class SafeShutdownManagedChannel
extends ManagedChannel {
    private final ManagedChannel delegate;
    private final AtomicInteger outstandingCalls = new AtomicInteger(0);
    private volatile boolean isShutdownSafely = false;

    SafeShutdownManagedChannel(ManagedChannel managedChannel) {
        this.delegate = managedChannel;
    }

    void shutdownSafely() {
        this.isShutdownSafely = true;
        if (this.outstandingCalls.get() == 0) {
            this.delegate.shutdown();
        }
    }

    public ManagedChannel shutdown() {
        this.delegate.shutdown();
        return this;
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public ManagedChannel shutdownNow() {
        this.delegate.shutdownNow();
        return this;
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    private void onClientCallClose() {
        if (this.outstandingCalls.decrementAndGet() == 0 && this.isShutdownSafely) {
            this.shutdownSafely();
        }
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        Preconditions.checkState((!this.isShutdownSafely ? 1 : 0) != 0);
        ClientCallProxy clientCall = new ClientCallProxy(this.delegate.newCall(methodDescriptor, callOptions));
        this.outstandingCalls.incrementAndGet();
        return clientCall;
    }

    public String authority() {
        return this.delegate.authority();
    }

    private class ClientCallProxy<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        ClientCallProxy(ClientCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            super.start(new DecrementOutstandingCalls<RespT>(responseListener), headers);
        }
    }

    private class DecrementOutstandingCalls<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        DecrementOutstandingCalls(ClientCall.Listener<RespT> delegate) {
            super(delegate);
        }

        public void onClose(Status status, Metadata trailers) {
            try {
                super.onClose(status, trailers);
            }
            finally {
                SafeShutdownManagedChannel.this.onClientCallClose();
            }
        }
    }
}

