/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public class RollingFileStream
extends OutputStream {
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private String lockFileName;
    private FileOutputStream lockStream;
    private File[] files;
    private static final int MAX_LOCKS = 100;
    private static HashMap<String, String> locks = new HashMap();

    public RollingFileStream() throws IOException, SecurityException {
        this("%d/derby-%g.log", 0, 1, false);
    }

    public RollingFileStream(String string, int n, int n2, boolean bl) throws IOException, SecurityException {
        if (n < 0 || n2 < 1 || string.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = string;
        this.limit = n;
        this.count = n2;
        this.append = bl;
        this.openFiles();
    }

    @Override
    public void write(int n) throws IOException {
        this.meter.write(n);
        this.checkMeter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openFiles() throws IOException {
        if (this.count < 1) {
            throw new IllegalArgumentException("file count = " + this.count);
        }
        if (this.limit < 0) {
            this.limit = 0;
        }
        int n = -1;
        while (true) {
            if (++n > 100) {
                throw new IOException("Couldn't get lock for " + this.pattern);
            }
            this.lockFileName = this.generate(this.pattern, 0, n).toString() + ".lck";
            HashMap<String, String> hashMap = locks;
            synchronized (hashMap) {
                FileChannel fileChannel;
                if (locks.get(this.lockFileName) != null) {
                    continue;
                }
                try {
                    this.lockStream = this.openFile(this.lockFileName, false);
                    fileChannel = this.lockStream.getChannel();
                }
                catch (IOException iOException) {
                    continue;
                }
                try {
                    FileLock fileLock = fileChannel.tryLock();
                    if (fileLock != null) break;
                }
                catch (IOException iOException) {
                    // empty catch block
                    break;
                }
            }
        }
        {
            locks.put(this.lockFileName, this.lockFileName);
        }
        this.files = new File[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.files[i] = this.generate(this.pattern, i, n);
        }
        if (this.append) {
            this.open(this.files[0], true);
            return;
        }
        this.rotate();
    }

    private File generate(String string, int n, int n2) throws IOException {
        File file = null;
        String string2 = "";
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            char c2 = '\u0000';
            if (++n3 < string.length()) {
                c2 = Character.toLowerCase(string.charAt(n3));
            }
            if (c == '/') {
                file = file == null ? new File(string2) : new File(file, string2);
                string2 = "";
                continue;
            }
            if (c == '%') {
                String string3;
                if (c2 == 't') {
                    string3 = this.getSystemProperty("java.io.tmpdir");
                    if (string3 == null) {
                        string3 = this.getSystemProperty("user.home");
                    }
                    file = new File(string3);
                    ++n3;
                    string2 = "";
                    continue;
                }
                if (c2 == 'h') {
                    file = new File(this.getSystemProperty("user.home"));
                    ++n3;
                    string2 = "";
                    continue;
                }
                if (c2 == 'd') {
                    string3 = this.getSystemProperty("derby.system.home");
                    if (string3 == null) {
                        string3 = this.getSystemProperty("user.dir");
                    }
                    file = new File(string3);
                    ++n3;
                    string2 = "";
                    continue;
                }
                if (c2 == 'g') {
                    string2 = string2 + n;
                    bl = true;
                    ++n3;
                    continue;
                }
                if (c2 == 'u') {
                    string2 = string2 + n2;
                    bl2 = true;
                    ++n3;
                    continue;
                }
                if (c2 == '%') {
                    string2 = string2 + "%";
                    ++n3;
                    continue;
                }
            }
            string2 = string2 + c;
        }
        if (this.count > 1 && !bl) {
            string2 = string2 + "." + n;
        }
        if (n2 > 0 && !bl2) {
            string2 = string2 + "." + n2;
        }
        if (string2.length() > 0) {
            file = file == null ? new File(string2) : new File(file, string2);
        }
        return file;
    }

    private synchronized void rotate() throws IOException {
        if (null != this.meter) {
            this.meter.close();
        }
        for (int i = this.count - 2; i >= 0; --i) {
            File file = this.files[i];
            File file2 = this.files[i + 1];
            if (!this.fileExists(file)) continue;
            if (this.fileExists(file2)) {
                this.fileDelete(file2);
            }
            this.fileRename(file, file2);
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SecurityException {
        if (null != this.meter) {
            try {
                this.meter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.lockFileName == null) {
            return;
        }
        try {
            this.lockStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> hashMap = locks;
        synchronized (hashMap) {
            locks.remove(this.lockFileName);
        }
        this.fileDelete(new File(this.lockFileName));
        this.lockFileName = null;
        this.lockStream = null;
    }

    private String getSystemProperty(final String string) {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
        return string2;
    }

    private FileOutputStream openFile(final String string, final boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
                    return fileOutputStream;
                }
            });
            return fileOutputStream;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private boolean fileExists(final File file) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
        return bl;
    }

    private void fileDelete(final File file) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                file.delete();
                return null;
            }
        });
    }

    private boolean fileRename(final File file, final File file2) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.renameTo(file2);
            }
        });
        return bl;
    }

    private long fileLength(final File file) {
        Long l = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.length();
            }
        });
        return l;
    }

    private void open(File file, boolean bl) throws IOException {
        int n = 0;
        if (bl) {
            n = (int)this.fileLength(file);
        }
        FileOutputStream fileOutputStream = this.openFile(file.toString(), bl);
        this.meter = new MeteredStream(fileOutputStream, n);
    }

    private void checkMeter() throws IOException {
        if (this.limit > 0 && this.meter.written >= this.limit) {
            this.rotate();
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream outputStream, int n) {
            this.out = outputStream;
            this.written = n;
        }

        @Override
        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.written;
        }

        public int getWritten() {
            return this.written;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

