/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.SessionService;
import com.xebialabs.deployit.core.api.dto.ActiveUserSession;
import com.xebialabs.deployit.core.api.dto.UserSessionsOverview;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.repository.XldSessionRepository;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Option$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001\u0002\u0005\n\u0001YA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!)\u0001\u0007\u0001C\u0001c!9a\u0007\u0001b\u0001\n\u00039\u0004B\u0002#\u0001A\u0003%\u0001\bC\u0003R\u0001\u0011\u0005#\u000b\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0002\u0013'\u0016\u001c8/[8o'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u000b\u0017\u0005\u0019\u0011\r]5\u000b\u00051i\u0011\u0001\u0002:fgRT!AD\b\u0002\t\r|'/\u001a\u0006\u0003!E\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003%M\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003Q\t1aY8n\u0007\u0001\u00192\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\tQ2\"A\u0004tK\u000e,(/\u001a3\n\u0005qI\"aF!cgR\u0014\u0018m\u0019;TK\u000e,(/\u001a3SKN|WO]2f!\tq\u0002%D\u0001 \u0015\tQQ\"\u0003\u0002\"?\tq1+Z:tS>t7+\u001a:wS\u000e,\u0017\u0001\u0006=mIN+7o]5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002%O5\tQE\u0003\u0002'\u001f\u0005Q!/\u001a9pg&$xN]=\n\u0005!*#\u0001\u0006-mIN+7o]5p]J+\u0007o\\:ji>\u0014\u00180A\tqC\u001eLg.\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"a\u000b\u0018\u000e\u00031R!!L\u0007\u0002\u000fM,'O^5dK&\u0011q\u0006\f\u0002\u0012!\u0006<\u0017N\\1uS>t7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u00023iU\u0002\"a\r\u0001\u000e\u0003%AQAI\u0002A\u0002\rBQ!K\u0002A\u0002)\n\u0001B]3ta>t7/Z\u000b\u0002qA\u0011\u0011HQ\u0007\u0002u)\u00111\bP\u0001\u0004gBL'BA\u001f?\u0003!\u0011Xm\u001d;fCNL(BA A\u0003\u0015Q'm\\:t\u0015\u0005\t\u0015aA8sO&\u00111I\u000f\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\ne\u0016\u001c\bo\u001c8tK\u0002B#!\u0002$\u0011\u0005\u001d{U\"\u0001%\u000b\u00059I%B\u0001&L\u0003\t\u00118O\u0003\u0002M\u001b\u0006\u0011qo\u001d\u0006\u0002\u001d\u0006)!.\u0019<bq&\u0011\u0001\u000b\u0013\u0002\b\u0007>tG/\u001a=u\u0003E9W\r^!di&4XmU3tg&|gn\u001d\u000b\u0005'\u0006\u0004(\u0010E\u0002U3nk\u0011!\u0016\u0006\u0003-^\u000bA!\u001e;jY*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005\u0011a\u0015n\u001d;\u0011\u0005q{V\"A/\u000b\u0005y{\u0012a\u00013u_&\u0011\u0001-\u0018\u0002\u0012\u0003\u000e$\u0018N^3Vg\u0016\u00148+Z:tS>t\u0007\"\u00022\u0007\u0001\u0004\u0019\u0017\u0001\u00059sS:\u001c\u0017\u000e]1m!\u0006$H/\u001a:o!\t!WN\u0004\u0002fWB\u0011a-[\u0007\u0002O*\u0011\u0001.F\u0001\u0007yI|w\u000e\u001e \u000b\u0003)\fQa]2bY\u0006L!\u0001\\5\u0002\rA\u0013X\rZ3g\u0013\tqwN\u0001\u0004TiJLgn\u001a\u0006\u0003Y&DQ!\u001d\u0004A\u0002I\fa\u0001]1hS:<\u0007CA:y\u001b\u0005!(B\u00010v\u0015\tQaO\u0003\u0002x\u001f\u00051QM\\4j]\u0016L!!\u001f;\u0003\rA\u000bw-\u001b8h\u0011\u0015Yh\u00011\u0001}\u0003\u0015y'\u000fZ3s!\t\u0019X0\u0003\u0002\u007fi\nAqJ\u001d3fe&tw-A\nhKR\u001cVm]:j_:\u001cxJ^3sm&,w\u000f\u0006\u0002\u0002\u0004A\u0019A,!\u0002\n\u0007\u0005\u001dQL\u0001\u000bVg\u0016\u00148+Z:tS>t7o\u0014<feZLWm\u001e\u0015\u0004\u0001\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u000bgR,'/Z8usB,'bAA\u000b\u0001\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002\u001a\u0005=!aB*feZL7-\u001a")
public class SessionServiceImpl
extends AbstractSecuredResource
implements SessionService {
    private final XldSessionRepository xldSessionRepository;
    private final PaginationService paginationService;
    @Context
    private final HttpResponse response;

    public HttpResponse response() {
        return this.response;
    }

    public List<ActiveUserSession> getActiveSessions(String principalPattern, Paging paging, Ordering order) {
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY});
        String principalPatternOption = (String)Option$.MODULE$.apply((Object)principalPattern).getOrElse((Function0 & Serializable)() -> "");
        this.paginationService.addPagingHeaderIfNeeded(this.paginationService.toSetHeader(this.response()), () -> $this.xldSessionRepository.count(principalPatternOption), paging);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.xldSessionRepository.findAll(principalPatternOption, paging, order)).asJava();
    }

    public UserSessionsOverview getSessionsOverview() {
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY});
        return this.xldSessionRepository.getSessionSummary();
    }

    public SessionServiceImpl(XldSessionRepository xldSessionRepository, PaginationService paginationService) {
        this.xldSessionRepository = xldSessionRepository;
        this.paginationService = paginationService;
        this.response = null;
    }
}

