/*
 * Decompiled with CFR 0.152.
 */
package kamon.metric;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import kamon.metric.Distribution;
import kamon.metric.DynamicRange;
import kamon.metric.Instrument;
import kamon.metric.Instrument$Type$;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricFactory;
import kamon.metric.MetricFactory$;
import kamon.metric.MetricSnapshot;
import kamon.metric.PeriodSnapshot;
import kamon.package$;
import kamon.package$AtomicGetOrElseUpdateOnTrieMap$;
import kamon.status.Status;
import kamon.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t\u001df\u0001\u0002\u0010 \u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003G\u0001\u0011\u0005q\tC\u0004N\u0001\t\u0007I\u0011\u0002(\t\r]\u0003\u0001\u0015!\u0003P\u0011\u001dA\u0006A1A\u0005\neCa\u0001 \u0001!\u0002\u0013Q\u0006\"CA\u000b\u0001\u0001\u0007I\u0011BA\f\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0015BA\r\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty\u0004C\u0005\u0002H\u0001\u0001\r\u0011\"\u0003\u0002J!A\u0011Q\n\u0001!B\u0013\t\t\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!9\u0001\t\u0013\t\u0019\u000fC\u0004\u0003 \u0001!IA!\t\t\u000f\tU\u0002\u0001\"\u0003\u00038!9!q\n\u0001\u0005\n\tE\u0003b\u0002B.\u0001\u0011%!Q\f\u0005\b\u0005O\u0002A\u0011\u0002B5\u0011\u001d\u0011\u0019\b\u0001C\u0005\u0005kBqAa \u0001\t\u0003\u0011\t\tC\u0004\u0003\u0014\u0002!\tA!&\u0003\u001d5+GO]5d%\u0016<\u0017n\u001d;ss*\u0011\u0001%I\u0001\u0007[\u0016$(/[2\u000b\u0003\t\nQa[1n_:\u001c\u0001a\u0005\u0002\u0001KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\faaY8oM&<\u0007CA\u00174\u001b\u0005q#BA\u00160\u0015\t\u0001\u0014'\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0014aA2p[&\u0011AG\f\u0002\u0007\u0007>tg-[4\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bCA\u001c?\u001b\u0005A$BA\u001d;\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003wq\nA!\u001e;jY*\tQ(\u0001\u0003kCZ\f\u0017BA 9\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u0006G2|7m\u001b\t\u0003\u0005\u0012k\u0011a\u0011\u0006\u0003w\u0005J!!R\"\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)\u0011A%j\u0013'\u0011\u0005%\u0003Q\"A\u0010\t\u000b-\"\u0001\u0019\u0001\u0017\t\u000bU\"\u0001\u0019\u0001\u001c\t\u000b\u0001#\u0001\u0019A!\u0002\u000f}cwnZ4feV\tq\n\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006)1\u000f\u001c45U*\tA+A\u0002pe\u001eL!AV)\u0003\r1{wmZ3s\u0003!yFn\\4hKJ\u0004\u0013\u0001C0nKR\u0014\u0018nY:\u0016\u0003i\u0003BaW0bY6\tAL\u0003\u0002:;*\u0011alJ\u0001\u000bG>dG.Z2uS>t\u0017B\u00011]\u0005\u001d!&/[3NCB\u0004\"AY5\u000f\u0005\r<\u0007C\u00013(\u001b\u0005)'B\u00014$\u0003\u0019a$o\\8u}%\u0011\u0001nJ\u0001\u0007!J,G-\u001a4\n\u0005)\\'AB*ue&twM\u0003\u0002iOA2QN_A\u0006\u0003#\u0001rA\\;y\u0003\u0013\tyA\u0004\u0002pg:\u0011\u0001O\u001d\b\u0003IFL\u0011AI\u0005\u0003A\u0005J!\u0001^\u0010\u0002\r5+GO]5d\u0013\t1xO\u0001\u0006CCN,W*\u001a;sS\u000eT!\u0001^\u0010\u0011\u0005eTH\u0002\u0001\u0003\nw\"\t\t\u0011!A\u0003\u0002u\u00141a\u0018\u00132\u0003%yV.\u001a;sS\u000e\u001c\b%E\u0002\u007f\u0003\u0007\u0001\"AJ@\n\u0007\u0005\u0005qEA\u0004O_RD\u0017N\\4\u0011\u0007\u0019\n)!C\u0002\u0002\b\u001d\u00121!\u00118z!\rI\u00181\u0002\u0003\u000b\u0003\u001bA\u0011\u0011!A\u0001\u0006\u0003i(aA0%eA\u0019\u00110!\u0005\u0005\u0015\u0005M\u0001\"!A\u0001\u0002\u000b\u0005QPA\u0002`IM\nAc\u00187bgR\u001cf.\u00199tQ>$\u0018J\\:uC:$XCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010y\u0005!A/[7f\u0013\u0011\t\u0019#!\b\u0003\u000f%s7\u000f^1oi\u0006Ar\f\\1tiNs\u0017\r]:i_RLen\u001d;b]R|F%Z9\u0015\t\u0005%\u0012q\u0006\t\u0004M\u0005-\u0012bAA\u0017O\t!QK\\5u\u0011%\t\tDCA\u0001\u0002\u0004\tI\"A\u0002yIE\nQc\u00187bgR\u001cf.\u00199tQ>$\u0018J\\:uC:$\b\u0005K\u0002\f\u0003o\u00012AJA\u001d\u0013\r\tYd\n\u0002\tm>d\u0017\r^5mK\u0006AqLZ1di>\u0014\u00180\u0006\u0002\u0002BA\u0019\u0011*a\u0011\n\u0007\u0005\u0015sDA\u0007NKR\u0014\u0018n\u0019$bGR|'/_\u0001\r?\u001a\f7\r^8ss~#S-\u001d\u000b\u0005\u0003S\tY\u0005C\u0005\u000225\t\t\u00111\u0001\u0002B\u0005IqLZ1di>\u0014\u0018\u0010\t\u0015\u0004\u001d\u0005]\u0012aB2pk:$XM\u001d\u000b\u000b\u0003+\ni&!\u0019\u0002l\u0005]\u0004\u0003BA,\u00033r!!S:\n\u0007\u0005msOA\u0004D_VtG/\u001a:\t\r\u0005}s\u00021\u0001b\u0003\u0011q\u0017-\\3\t\u000f\u0005\rt\u00021\u0001\u0002f\u0005YA-Z:de&\u0004H/[8o!\u00111\u0013qM1\n\u0007\u0005%tE\u0001\u0004PaRLwN\u001c\u0005\b\u0003[z\u0001\u0019AA8\u0003\u0011)h.\u001b;\u0011\u000b\u0019\n9'!\u001d\u0011\u0007%\u000b\u0019(C\u0002\u0002v}\u0011q\"T3bgV\u0014X-\\3oiVs\u0017\u000e\u001e\u0005\b\u0003sz\u0001\u0019AA>\u0003I\tW\u000f^8Va\u0012\fG/Z%oi\u0016\u0014h/\u00197\u0011\u000b\u0019\n9'! \u0011\t\u0005m\u0011qP\u0005\u0005\u0003\u0003\u000biB\u0001\u0005EkJ\fG/[8o\u0003\u00159\u0017-^4f))\t9)!$\u0002\u0010\u0006E\u00151\u0013\t\u0005\u0003/\nI)C\u0002\u0002\f^\u0014QaR1vO\u0016Da!a\u0018\u0011\u0001\u0004\t\u0007bBA2!\u0001\u0007\u0011Q\r\u0005\b\u0003[\u0002\u0002\u0019AA8\u0011\u001d\tI\b\u0005a\u0001\u0003w\n\u0011\u0002[5ti><'/Y7\u0015\u0019\u0005e\u0015qTAQ\u0003G\u000b)+!-\u0011\t\u0005]\u00131T\u0005\u0004\u0003;;(!\u0003%jgR|wM]1n\u0011\u0019\ty&\u0005a\u0001C\"9\u00111M\tA\u0002\u0005\u0015\u0004bBA7#\u0001\u0007\u0011q\u000e\u0005\b\u0003O\u000b\u0002\u0019AAU\u00031!\u0017P\\1nS\u000e\u0014\u0016M\\4f!\u00151\u0013qMAV!\rI\u0015QV\u0005\u0004\u0003_{\"\u0001\u0004#z]\u0006l\u0017n\u0019*b]\u001e,\u0007bBA=#\u0001\u0007\u00111P\u0001\u0006i&lWM\u001d\u000b\u000b\u0003o\u000bi,a0\u0002B\u0006\r\u0007\u0003BA,\u0003sK1!a/x\u0005\u0015!\u0016.\\3s\u0011\u0019\tyF\u0005a\u0001C\"9\u00111\r\nA\u0002\u0005\u0015\u0004bBAT%\u0001\u0007\u0011\u0011\u0016\u0005\b\u0003s\u0012\u0002\u0019AA>\u00031\u0011\u0018M\\4f'\u0006l\u0007\u000f\\3s)1\tI-a4\u0002R\u0006M\u0017Q[Al!\u0011\t9&a3\n\u0007\u00055wO\u0001\u0007SC:<WmU1na2,'\u000f\u0003\u0004\u0002`M\u0001\r!\u0019\u0005\b\u0003G\u001a\u0002\u0019AA3\u0011\u001d\tig\u0005a\u0001\u0003_Bq!a*\u0014\u0001\u0004\tI\u000bC\u0004\u0002zM\u0001\r!a\u001f\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0005\u0003S\ti\u000e\u0003\u0004\u0002`R\u0001\r\u0001L\u0001\n]\u0016<8i\u001c8gS\u001e\faC^1mS\u0012\fG/Z%ogR\u0014X/\\3oiRK\b/Z\u000b\u0005\u0003K\fY\u000f\u0006\u0003\u0002h\n\rACBAu\u0003_\f\t\u0010E\u0002z\u0003W$a!!<\u0016\u0005\u0004i(!\u0001+\t\r\u0005}S\u00031\u0001b\u0011\u001d\t\u00190\u0006a\u0001\u0003k\fa\"\u001b8tiJ,X.\u001a8u)f\u0004X\r\u0005\u0003\u0002x\u0006uhbA%\u0002z&\u0019\u00111`\u0010\u0002\u0015%s7\u000f\u001e:v[\u0016tG/\u0003\u0003\u0002\u0000\n\u0005!\u0001\u0002+za\u0016T1!a? \u0011\u001d\u0001S\u0003\"a\u0001\u0005\u000b\u0001RA\nB\u0004\u0005\u0017I1A!\u0003(\u0005!a$-\u001f8b[\u0016t\u0004G\u0002B\u0007\u0005+\u0011Y\u0002E\u0004J\u0005\u001f\u0011\u0019B!\u0007\n\u0007\tEqD\u0001\u0004NKR\u0014\u0018n\u0019\t\u0004s\nUAa\u0003B\f\u0005\u0007\t\t\u0011!A\u0003\u0002u\u00141a\u0018\u00135!\rI(1\u0004\u0003\f\u0005;\u0011\u0019!!A\u0001\u0002\u000b\u0005QPA\u0002`IU\n!#[7qY\u0016lWM\u001c;bi&|gNT1nKR\u0019\u0011Ma\t\t\r\u00012\u0002\u0019\u0001B\u0013a\u0019\u00119Ca\u000b\u00032A9\u0011Ja\u0004\u0003*\t=\u0002cA=\u0003,\u0011Y!Q\u0006B\u0012\u0003\u0003\u0005\tQ!\u0001~\u0005\ryFE\u000e\t\u0004s\nEBa\u0003B\u001a\u0005G\t\t\u0011!A\u0003\u0002u\u00141a\u0018\u00138\u0003M\u0019\u0007.Z2l\u0013:\u001cHO];nK:$H+\u001f9f)!\tIC!\u000f\u0003<\tu\u0002BBA0/\u0001\u0007\u0011\rC\u0004\u0002t^\u0001\r!!>\t\r\u0001:\u0002\u0019\u0001B a\u0019\u0011\tE!\u0012\u0003LA9\u0011Ja\u0004\u0003D\t%\u0003cA=\u0003F\u0011Y!q\tB\u001f\u0003\u0003\u0005\tQ!\u0001~\u0005\ryF\u0005\u000f\t\u0004s\n-Ca\u0003B'\u0005{\t\t\u0011!A\u0003\u0002u\u00141a\u0018\u0013:\u0003A\u0019\u0007.Z2l\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0005\u0002*\tM#Q\u000bB,\u0011\u0019\ty\u0006\u0007a\u0001C\"1\u00111\r\rA\u0002\u0005DqA!\u0017\u0019\u0001\u0004\t)'A\nqe>4\u0018\u000eZ3e\t\u0016\u001c8M]5qi&|g.A\u0005dQ\u0016\u001c7.\u00168jiRA\u0011\u0011\u0006B0\u0005C\u0012\u0019\u0007\u0003\u0004\u0002`e\u0001\r!\u0019\u0005\b\u0003[J\u0002\u0019AA9\u0011\u001d\u0011)'\u0007a\u0001\u0003_\nA\u0002\u001d:pm&$W\rZ+oSR\fqb\u00195fG.\fU\u000f^8Va\u0012\fG/\u001a\u000b\t\u0003S\u0011YG!\u001c\u0003p!1\u0011q\f\u000eA\u0002\u0005Dq!!\u001f\u001b\u0001\u0004\ti\bC\u0004\u0003ri\u0001\r!a\u001f\u00025A\u0014xN^5eK\u0012\fU\u000f^8Va\u0012\fG/Z%oi\u0016\u0014h/\u00197\u0002#\rDWmY6Es:\fW.[2SC:<W\r\u0006\u0005\u0002*\t]$\u0011\u0010B>\u0011\u0019\tyf\u0007a\u0001C\"9\u0011qU\u000eA\u0002\u0005-\u0006b\u0002B?7\u0001\u0007\u0011\u0011V\u0001\u0015aJ|g/\u001b3fI\u0012Kh.Y7jGJ\u000bgnZ3\u0002\u0011Mt\u0017\r]:i_R$BAa!\u0003\nB\u0019\u0011J!\"\n\u0007\t\u001duD\u0001\bQKJLw\u000eZ*oCB\u001c\bn\u001c;\t\u000f\t-E\u00041\u0001\u0003\u000e\u0006Q!/Z:fiN#\u0018\r^3\u0011\u0007\u0019\u0012y)C\u0002\u0003\u0012\u001e\u0012qAQ8pY\u0016\fg.\u0001\u0004ti\u0006$Xo\u001d\u000b\u0003\u0005/\u0003BA!'\u0003$:!!1\u0014BP\u001b\t\u0011iJC\u0002\u0003\u0014\u0006JAA!)\u0003\u001e\u000611\u000b^1ukNL1A\bBS\u0015\u0011\u0011\tK!(")
public class MetricRegistry {
    private final ScheduledExecutorService scheduler;
    private final Clock clock;
    private final Logger _logger;
    private final TrieMap<String, Metric.BaseMetric<?, ?, ?>> _metrics;
    private volatile Instant _lastSnapshotInstant;
    private volatile MetricFactory _factory;

    private Logger _logger() {
        return this._logger;
    }

    private TrieMap<String, Metric.BaseMetric<?, ?, ?>> _metrics() {
        return this._metrics;
    }

    private Instant _lastSnapshotInstant() {
        return this._lastSnapshotInstant;
    }

    private void _lastSnapshotInstant_$eq(Instant x$1) {
        this._lastSnapshotInstant = x$1;
    }

    private MetricFactory _factory() {
        return this._factory;
    }

    private void _factory_$eq(MetricFactory x$1) {
        this._factory = x$1;
    }

    public Metric.Counter counter(String name, Option<String> description, Option<MeasurementUnit> unit, Option<Duration> autoUpdateInterval) {
        Metric.Counter metric = (Metric.Counter)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().counter(name, description, unit, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Counter());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).unit(), unit);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.Gauge gauge(String name, Option<String> description, Option<MeasurementUnit> unit, Option<Duration> autoUpdateInterval) {
        Metric.Gauge metric = (Metric.Gauge)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().gauge(name, description, unit, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Gauge());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).unit(), unit);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.Histogram histogram(String name, Option<String> description, Option<MeasurementUnit> unit, Option<DynamicRange> dynamicRange, Option<Duration> autoUpdateInterval) {
        Metric.Histogram metric = (Metric.Histogram)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().histogram(name, description, unit, dynamicRange, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Histogram());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit(), unit);
        this.checkDynamicRange(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).dynamicRange(), dynamicRange);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.Timer timer(String name, Option<String> description, Option<DynamicRange> dynamicRange, Option<Duration> autoUpdateInterval) {
        Metric.Timer metric = (Metric.Timer)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().timer(name, description, (Option<MeasurementUnit>)new Some((Object)MeasurementUnit$.MODULE$.time().nanoseconds()), dynamicRange, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Timer());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkDynamicRange(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).dynamicRange(), dynamicRange);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.RangeSampler rangeSampler(String name, Option<String> description, Option<MeasurementUnit> unit, Option<DynamicRange> dynamicRange, Option<Duration> autoUpdateInterval) {
        Metric.RangeSampler metric = (Metric.RangeSampler)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().rangeSampler(name, description, unit, dynamicRange, autoUpdateInterval)), name, Instrument$Type$.MODULE$.RangeSampler());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit(), unit);
        this.checkDynamicRange(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).dynamicRange(), dynamicRange);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public void reconfigure(Config newConfig) {
        this._factory_$eq(MetricFactory$.MODULE$.from(newConfig, this.scheduler, this.clock));
    }

    private <T> T validateInstrumentType(Function0<Metric<?, ?>> metric, String name, Instrument.Type instrumentType) {
        Metric lookedUpMetric = (Metric)metric.apply();
        if (!instrumentType.implementation().isInstance(lookedUpMetric)) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(50).append("Cannot redefine metric [").append(name).append("] as a [").append(instrumentType.name()).append("], it was already ").toString()).append(new StringBuilder(18).append("registered as a [").append(this.implementationName((Metric)metric.apply())).append("]").toString()).toString());
        }
        return (T)lookedUpMetric;
    }

    private String implementationName(Metric<?, ?> metric) {
        String string;
        Metric<?, ?> metric2 = metric;
        if (metric2 instanceof Metric.Counter) {
            string = Instrument$Type$.MODULE$.Counter().name();
        } else if (metric2 instanceof Metric.Gauge) {
            string = Instrument$Type$.MODULE$.Gauge().name();
        } else if (metric2 instanceof Metric.Histogram) {
            string = Instrument$Type$.MODULE$.Histogram().name();
        } else if (metric2 instanceof Metric.RangeSampler) {
            string = Instrument$Type$.MODULE$.RangeSampler().name();
        } else if (metric2 instanceof Metric.Timer) {
            string = Instrument$Type$.MODULE$.Timer().name();
        } else {
            throw new MatchError(metric2);
        }
        return string;
    }

    private void checkInstrumentType(String name, Instrument.Type instrumentType, Metric<?, ?> metric) {
        if (!instrumentType.implementation().isInstance(metric)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(68).append("Cannot redefine metric [").append(name).append("] as a [").append(instrumentType.name()).append("], it was already registered as a [").append(metric.getClass().getName()).append("]").toString());
        }
    }

    private void checkDescription(String name, String description, Option<String> providedDescription) {
        block0: {
            if (!providedDescription.exists((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkDescription$1(description, d)))) break block0;
            this._logger().warn(new StringBuilder(41).append("Ignoring new description [").append(providedDescription.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    private void checkUnit(String name, MeasurementUnit unit, Option<MeasurementUnit> providedUnit) {
        block0: {
            if (!providedUnit.exists((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkUnit$1(unit, u)))) break block0;
            this._logger().warn(new StringBuilder(34).append("Ignoring new unit [").append(providedUnit.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    private void checkAutoUpdate(String name, Duration autoUpdateInterval, Option<Duration> providedAutoUpdateInterval) {
        block0: {
            if (!providedAutoUpdateInterval.exists((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkAutoUpdate$1(autoUpdateInterval, u)))) break block0;
            this._logger().warn(new StringBuilder(50).append("Ignoring new auto-update interval [").append(providedAutoUpdateInterval.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    private void checkDynamicRange(String name, DynamicRange dynamicRange, Option<DynamicRange> providedDynamicRange) {
        block0: {
            if (!providedDynamicRange.exists((Function1 & Serializable)dr -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkDynamicRange$1(dynamicRange, dr)))) break block0;
            this._logger().warn(new StringBuilder(43).append("Ignoring new dynamic range [").append(providedDynamicRange.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    public synchronized PeriodSnapshot snapshot(boolean resetState) {
        ObjectRef counters = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef gauges = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef histograms = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef timers = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef rangeSamplers = ObjectRef.create((Object)List$.MODULE$.empty());
        this._metrics().foreach((Function1 & Serializable)x0$1 -> {
            MetricRegistry.$anonfun$snapshot$1(counters, resetState, gauges, histograms, timers, rangeSamplers, x0$1);
            return BoxedUnit.UNIT;
        });
        Instant periodStart = this._lastSnapshotInstant();
        Instant periodEnd = this.clock.instant();
        this._lastSnapshotInstant_$eq(periodEnd);
        return new PeriodSnapshot(periodStart, periodEnd, (Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>>)((List)counters.elem), (Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>>)((List)gauges.elem), (Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>>)((List)histograms.elem), (Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>>)((List)timers.elem), (Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>>)((List)rangeSamplers.elem));
    }

    public Status.MetricRegistry status() {
        return new Status.MetricRegistry((Seq<Status.Metric>)((IterableOnceOps)this._metrics().values().map((Function1 & Serializable)x$1 -> x$1.status())).toSeq());
    }

    public static final /* synthetic */ boolean $anonfun$checkDescription$1(String description$6, String d) {
        String string = d;
        String string2 = description$6;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$checkUnit$1(MeasurementUnit unit$5, MeasurementUnit u) {
        MeasurementUnit measurementUnit = u;
        MeasurementUnit measurementUnit2 = unit$5;
        return measurementUnit == null ? measurementUnit2 != null : !((Object)measurementUnit).equals(measurementUnit2);
    }

    public static final /* synthetic */ boolean $anonfun$checkAutoUpdate$1(Duration autoUpdateInterval$6, Duration u) {
        Duration duration = u;
        Duration duration2 = autoUpdateInterval$6;
        return duration == null ? duration2 != null : !((Object)duration).equals(duration2);
    }

    public static final /* synthetic */ boolean $anonfun$checkDynamicRange$1(DynamicRange dynamicRange$4, DynamicRange dr) {
        DynamicRange dynamicRange = dr;
        DynamicRange dynamicRange2 = dynamicRange$4;
        return dynamicRange == null ? dynamicRange2 != null : !((Object)dynamicRange).equals(dynamicRange2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$snapshot$1(ObjectRef counters$1, boolean resetState$1, ObjectRef gauges$1, ObjectRef histograms$1, ObjectRef timers$1, ObjectRef rangeSamplers$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Metric.BaseMetric metric = (Metric.BaseMetric)tuple2._2();
        Metric.BaseMetric baseMetric = metric;
        if (baseMetric instanceof Metric.Counter) {
            Metric.BaseMetric baseMetric2 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric2.snapshot(resetState$1);
            counters$1.elem = ((List)counters$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseMetric instanceof Metric.Gauge) {
            Metric.BaseMetric baseMetric3 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric3.snapshot(resetState$1);
            gauges$1.elem = ((List)gauges$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseMetric instanceof Metric.Histogram) {
            Metric.BaseMetric baseMetric4 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric4.snapshot(resetState$1);
            histograms$1.elem = ((List)histograms$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseMetric instanceof Metric.Timer) {
            Metric.BaseMetric baseMetric5 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric5.snapshot(resetState$1);
            timers$1.elem = ((List)timers$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(baseMetric instanceof Metric.RangeSampler)) throw new MatchError((Object)baseMetric);
            Metric.BaseMetric baseMetric6 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric6.snapshot(resetState$1);
            rangeSamplers$1.elem = ((List)rangeSamplers$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MetricRegistry(Config config, ScheduledExecutorService scheduler, Clock clock) {
        this.scheduler = scheduler;
        this.clock = clock;
        this._logger = LoggerFactory.getLogger(MetricRegistry.class);
        this._metrics = TrieMap$.MODULE$.empty();
        this._lastSnapshotInstant = clock.instant();
        this._factory = MetricFactory$.MODULE$.from(config, scheduler, clock);
    }
}

