/*
 * Decompiled with CFR 0.152.
 */
package kamon.metric;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import kamon.metric.DynamicRange;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricFactory;
import kamon.package$;
import kamon.package$UtilsOnConfig$;
import kamon.util.Clock;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class MetricFactory$ {
    public static final MetricFactory$ MODULE$ = new MetricFactory$();

    public MetricFactory from(Config config, ScheduledExecutorService scheduler, Clock clock) {
        Config factoryConfig = config.getConfig("kamon.metric.factory");
        Metric.Settings.ForValueInstrument defaultCounterSettings = new Metric.Settings.ForValueInstrument(MeasurementUnit$.MODULE$.none(), factoryConfig.getDuration("default-settings.counter.auto-update-interval"));
        Metric.Settings.ForValueInstrument defaultGaugeSettings = new Metric.Settings.ForValueInstrument(MeasurementUnit$.MODULE$.none(), factoryConfig.getDuration("default-settings.gauge.auto-update-interval"));
        Metric.Settings.ForDistributionInstrument defaultHistogramSettings = new Metric.Settings.ForDistributionInstrument(MeasurementUnit$.MODULE$.none(), factoryConfig.getDuration("default-settings.histogram.auto-update-interval"), this.readDynamicRange(factoryConfig.getConfig("default-settings.histogram")));
        Metric.Settings.ForDistributionInstrument defaultTimerSettings = new Metric.Settings.ForDistributionInstrument(MeasurementUnit$.MODULE$.none(), factoryConfig.getDuration("default-settings.timer.auto-update-interval"), this.readDynamicRange(factoryConfig.getConfig("default-settings.timer")));
        Metric.Settings.ForDistributionInstrument defaultRangeSamplerSettings = new Metric.Settings.ForDistributionInstrument(MeasurementUnit$.MODULE$.none(), factoryConfig.getDuration("default-settings.range-sampler.auto-update-interval"), this.readDynamicRange(factoryConfig.getConfig("default-settings.range-sampler")));
        Map customSettings = (Map)((MapOps)package$UtilsOnConfig$.MODULE$.configurations$extension(package$.MODULE$.UtilsOnConfig(factoryConfig.getConfig("custom-settings"))).filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)MetricFactory$.MODULE$.nonEmptySection((Tuple2<String, Config>)entry)))).map((Function1 & Serializable)entry -> MODULE$.readCustomSettings((Tuple2<String, Config>)entry));
        return new MetricFactory(defaultCounterSettings, defaultGaugeSettings, defaultHistogramSettings, defaultTimerSettings, defaultRangeSamplerSettings, (Map<String, MetricFactory.CustomSettings>)customSettings, scheduler, clock);
    }

    private boolean nonEmptySection(Tuple2<String, Config> entry) {
        Tuple2<String, Config> tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Config config = (Config)tuple2._2();
        boolean bl = package$UtilsOnConfig$.MODULE$.topLevelKeys$extension(package$.MODULE$.UtilsOnConfig(config)).nonEmpty();
        return bl;
    }

    private Tuple2<String, MetricFactory.CustomSettings> readCustomSettings(Tuple2<String, Config> entry) {
        Tuple2<String, Config> tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String metricName = (String)tuple2._1();
        Config metricConfig = (Config)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metricName, (Object)metricConfig);
        Tuple2 tuple23 = tuple22;
        String metricName2 = (String)tuple23._1();
        Config metricConfig2 = (Config)tuple23._2();
        MetricFactory.CustomSettings customSettings = new MetricFactory.CustomSettings((Option<Duration>)(metricConfig2.hasPath("auto-update-interval") ? new Some((Object)metricConfig2.getDuration("auto-update-interval")) : None$.MODULE$), (Option<Object>)(metricConfig2.hasPath("lowest-discernible-value") ? new Some((Object)BoxesRunTime.boxToLong((long)metricConfig2.getLong("lowest-discernible-value"))) : None$.MODULE$), (Option<Object>)(metricConfig2.hasPath("highest-trackable-value") ? new Some((Object)BoxesRunTime.boxToLong((long)metricConfig2.getLong("highest-trackable-value"))) : None$.MODULE$), (Option<Object>)(metricConfig2.hasPath("significant-value-digits") ? new Some((Object)BoxesRunTime.boxToInteger((int)metricConfig2.getInt("significant-value-digits"))) : None$.MODULE$));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)metricName2), (Object)customSettings);
    }

    private DynamicRange readDynamicRange(Config config) {
        return new DynamicRange(config.getLong("lowest-discernible-value"), config.getLong("highest-trackable-value"), config.getInt("significant-value-digits"));
    }

    private MetricFactory$() {
    }
}

