/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.stream;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetProducerAdapter
implements IDataSetProducer {
    private static final Logger logger = LoggerFactory.getLogger(DataSetProducerAdapter.class);
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private final ITableIterator _iterator;
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;

    public DataSetProducerAdapter(ITableIterator iterator) {
        this._iterator = iterator;
    }

    public DataSetProducerAdapter(IDataSet dataSet) throws DataSetException {
        this._iterator = dataSet.iterator();
    }

    @Override
    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        logger.debug("setConsumer(consumer) - start");
        this._consumer = consumer;
    }

    @Override
    public void produce() throws DataSetException {
        logger.debug("produce() - start");
        this._consumer.startDataSet();
        while (this._iterator.next()) {
            ITable table = this._iterator.getTable();
            ITableMetaData metaData = table.getTableMetaData();
            this._consumer.startTable(metaData);
            try {
                Column[] columns = metaData.getColumns();
                if (columns.length == 0) {
                    this._consumer.endTable();
                    continue;
                }
                int i = 0;
                while (true) {
                    Object[] values = new Object[columns.length];
                    int j = 0;
                    while (j < columns.length) {
                        Column column = columns[j];
                        values[j] = table.getValue(i, column.getColumnName());
                        ++j;
                    }
                    this._consumer.row(values);
                    ++i;
                }
            }
            catch (RowOutOfBoundsException e) {
                this._consumer.endTable();
            }
        }
        this._consumer.endDataSet();
    }
}

