/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.map.ListOrderedMap;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.PrimaryKeyFilteredTableWrapper;
import org.dbunit.database.search.ForeignKeyRelationshipEdge;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.AbstractTableFilter;
import org.dbunit.util.SQLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeyFilter
extends AbstractTableFilter {
    private final IDatabaseConnection connection;
    private final PkTableMap allowedPKsPerTable;
    private final PkTableMap allowedPKsInput;
    private final PkTableMap pksToScanPerTable;
    private final boolean reverseScan;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map pkColumnPerTable = new HashMap();
    private final Map fkEdgesPerTable = new HashMap();
    private final Map fkReverseEdgesPerTable = new HashMap();
    private final List tableNames = new ArrayList();

    public PrimaryKeyFilter(IDatabaseConnection connection, PkTableMap allowedPKs, boolean reverseDependency) {
        this.connection = connection;
        this.allowedPKsPerTable = new PkTableMap();
        this.allowedPKsInput = allowedPKs;
        this.reverseScan = reverseDependency;
        this.pksToScanPerTable = new PkTableMap(allowedPKs);
    }

    public void nodeAdded(Object node) {
        this.tableNames.add(node);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("nodeAdded: " + node);
        }
    }

    public void edgeAdded(ForeignKeyRelationshipEdge edge) {
        String to;
        String from;
        Set<ForeignKeyRelationshipEdge> edges;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("edgeAdded: " + edge);
        }
        if ((edges = (HashSet<ForeignKeyRelationshipEdge>)this.fkEdgesPerTable.get(from = (String)edge.getFrom())) == null) {
            edges = new HashSet<ForeignKeyRelationshipEdge>();
            this.fkEdgesPerTable.put(from, edges);
        }
        if (!edges.contains(edge)) {
            edges.add(edge);
        }
        if ((edges = (Set)this.fkReverseEdgesPerTable.get(to = (String)edge.getTo())) == null) {
            edges = new HashSet();
            this.fkReverseEdgesPerTable.put(to, edges);
        }
        if (!edges.contains(edge)) {
            edges.add(edge);
        }
        this.updatePkCache(to, edge);
    }

    @Override
    public boolean isValidName(String tableName) throws DataSetException {
        return true;
    }

    @Override
    public ITableIterator iterator(IDataSet dataSet, boolean reversed) throws DataSetException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Filter.iterator()");
        }
        try {
            this.searchPKs(dataSet);
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
        return new FilterIterator(reversed ? dataSet.reverseIterator() : dataSet.iterator());
    }

    private void searchPKs(IDataSet dataSet) throws DataSetException, SQLException {
        this.logger.debug("searchPKs(dataSet={}) - start", (Object)dataSet);
        int counter = 0;
        while (!this.pksToScanPerTable.isEmpty()) {
            ++counter;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("RUN # " + counter);
            }
            int i = this.tableNames.size() - 1;
            while (i >= 0) {
                String tableName = (String)this.tableNames.get(i);
                String pkColumn = dataSet.getTable(tableName).getTableMetaData().getPrimaryKeys()[0].getColumnName();
                SortedSet tmpSet = this.pksToScanPerTable.get(tableName);
                if (tmpSet != null && !tmpSet.isEmpty()) {
                    HashSet pksToScan = new HashSet(tmpSet);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("before search: " + tableName + "=>" + pksToScan);
                    }
                    this.scanPKs(tableName, pkColumn, pksToScan);
                    this.scanReversePKs(tableName, pksToScan);
                    this.allowPKs(tableName, pksToScan);
                    this.removePKsToScan(tableName, pksToScan);
                }
                --i;
            }
            this.removeScannedTables();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finished searchIds()");
        }
    }

    private void removeScannedTables() {
        this.logger.debug("removeScannedTables() - start");
        this.pksToScanPerTable.retainOnly(this.tableNames);
    }

    private void allowPKs(String table, Set newAllowedPKs) {
        this.logger.debug("allowPKs(table={}, newAllowedPKs={}) - start", (Object)table, (Object)newAllowedPKs);
        SortedSet forcedAllowedPKs = this.allowedPKsInput.get(table);
        if (forcedAllowedPKs == null || forcedAllowedPKs.isEmpty()) {
            this.allowedPKsPerTable.addAll(table, newAllowedPKs);
        } else {
            for (Object id : newAllowedPKs) {
                if (forcedAllowedPKs.contains(id)) {
                    this.allowedPKsPerTable.add(table, id);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Discarding id " + id + " of table " + table + " as it was not included in the input!");
            }
        }
    }

    private void scanPKs(String table, String pkColumn, Set allowedIds) throws SQLException {
        Set fkEdges;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("scanPKs(table={}, pkColumn={}, allowedIds={}) - start", new Object[]{table, pkColumn, allowedIds});
        }
        if ((fkEdges = (Set)this.fkEdgesPerTable.get(table)) == null || fkEdges.isEmpty()) {
            return;
        }
        ArrayList<Object> fkTables = new ArrayList<Object>(fkEdges.size());
        StringBuffer colsBuffer = new StringBuffer();
        Iterator iterator = fkEdges.iterator();
        while (iterator.hasNext()) {
            ForeignKeyRelationshipEdge edge = (ForeignKeyRelationshipEdge)iterator.next();
            fkTables.add(edge.getTo());
            colsBuffer.append(edge.getFKColumn());
            if (!iterator.hasNext()) continue;
            colsBuffer.append(", ");
        }
        String sql = "SELECT " + colsBuffer + " FROM " + table + " WHERE " + pkColumn + " = ? ";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: " + sql);
        }
        this.scanPKs(table, sql, allowedIds, fkTables);
    }

    private void scanPKs(String table, String sql, Set allowedIds, List fkTables) throws SQLException {
        block12: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = this.connection.getConnection().prepareStatement(sql);
                    for (Object pk : allowedIds) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Executing sql for ? = " + pk);
                        }
                        pstmt.setObject(1, pk);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int i = 0;
                            while (i < fkTables.size()) {
                                String newTable = (String)fkTables.get(i);
                                Object fk = rs.getObject(i + 1);
                                if (fk != null) {
                                    if (this.logger.isDebugEnabled()) {
                                        this.logger.debug("New ID: " + newTable + "->" + fk);
                                    }
                                    this.addPKToScan(newTable, fk);
                                } else {
                                    this.logger.warn("Found null FK for relationship  " + table + "=>" + newTable);
                                }
                                ++i;
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    this.logger.error("scanPKs()", (Throwable)e);
                    SQLHelper.close(rs, pstmt);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                SQLHelper.close(rs, pstmt);
                throw throwable;
            }
            SQLHelper.close(rs, pstmt);
        }
    }

    private void scanReversePKs(String table, Set pksToScan) throws SQLException {
        this.logger.debug("scanReversePKs(table={}, pksToScan={}) - start", (Object)table, (Object)pksToScan);
        if (!this.reverseScan) {
            return;
        }
        Set fkReverseEdges = (Set)this.fkReverseEdgesPerTable.get(table);
        if (fkReverseEdges == null || fkReverseEdges.isEmpty()) {
            return;
        }
        for (ForeignKeyRelationshipEdge edge : fkReverseEdges) {
            this.addReverseEdge(edge, pksToScan);
        }
    }

    private void addReverseEdge(ForeignKeyRelationshipEdge edge, Set idsToScan) throws SQLException {
        this.logger.debug("addReverseEdge(edge={}, idsToScan=) - start", (Object)edge, (Object)idsToScan);
        String fkTable = (String)edge.getFrom();
        String fkColumn = edge.getFKColumn();
        String pkColumn = this.getPKColumn(fkTable);
        String sql = "SELECT " + pkColumn + " FROM " + fkTable + " WHERE " + fkColumn + " = ? ";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Preparing SQL query '" + sql + "'");
            }
            pstmt = this.connection.getConnection().prepareStatement(sql);
            for (Object pk : idsToScan) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("executing query '" + sql + "' for ? = " + pk);
                }
                pstmt.setObject(1, pk);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    Object fk = rs.getObject(1);
                    this.addPKToScan(fkTable, fk);
                }
            }
        }
        catch (Throwable throwable) {
            SQLHelper.close(rs, pstmt);
            throw throwable;
        }
        SQLHelper.close(rs, pstmt);
    }

    private void updatePkCache(String table, ForeignKeyRelationshipEdge edge) {
        this.logger.debug("updatePkCache(to={}, edge={}) - start", (Object)table, (Object)edge);
        Object pkTo = this.pkColumnPerTable.get(table);
        if (pkTo == null) {
            String pkColumn = edge.getPKColumn();
            this.pkColumnPerTable.put(table, pkColumn);
        }
    }

    private String getPKColumn(String table) throws SQLException {
        this.logger.debug("getPKColumn(table={}) - start", (Object)table);
        String pkColumn = (String)this.pkColumnPerTable.get(table);
        if (pkColumn == null) {
            pkColumn = SQLHelper.getPrimaryKeyColumn(this.connection.getConnection(), table);
            this.pkColumnPerTable.put(table, pkColumn);
        }
        return pkColumn;
    }

    private void removePKsToScan(String table, Set ids) {
        this.logger.debug("removePKsToScan(table={}, ids={}) - start", (Object)table, (Object)ids);
        SortedSet pksToScan = this.pksToScanPerTable.get(table);
        if (pksToScan != null) {
            if (pksToScan == ids) {
                throw new RuntimeException("INTERNAL ERROR on removeIdsToScan() for table " + table);
            }
            pksToScan.removeAll(ids);
        }
    }

    private void addPKToScan(String table, Object pk) {
        this.logger.debug("addPKToScan(table={}, pk={}) - start", (Object)table, pk);
        if (this.allowedPKsPerTable.contains(table, pk)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Discarding already scanned id=" + pk + " for table " + table);
            }
            return;
        }
        this.pksToScanPerTable.add(table, pk);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("tableNames=").append(this.tableNames);
        sb.append(", allowedPKsInput=").append(this.allowedPKsInput);
        sb.append(", allowedPKsPerTable=").append(this.allowedPKsPerTable);
        sb.append(", fkEdgesPerTable=").append(this.fkEdgesPerTable);
        sb.append(", fkReverseEdgesPerTable=").append(this.fkReverseEdgesPerTable);
        sb.append(", pkColumnPerTable=").append(this.pkColumnPerTable);
        sb.append(", pksToScanPerTable=").append(this.pksToScanPerTable);
        sb.append(", reverseScan=").append(this.reverseScan);
        sb.append(", connection=").append(this.connection);
        return sb.toString();
    }

    private class FilterIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public FilterIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        @Override
        public boolean next() throws DataSetException {
            if (PrimaryKeyFilter.this.logger.isDebugEnabled()) {
                PrimaryKeyFilter.this.logger.debug("Iterator.next()");
            }
            while (this._iterator.next()) {
                if (!PrimaryKeyFilter.this.accept(this._iterator.getTableMetaData().getTableName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public ITableMetaData getTableMetaData() throws DataSetException {
            if (PrimaryKeyFilter.this.logger.isDebugEnabled()) {
                PrimaryKeyFilter.this.logger.debug("Iterator.getTableMetaData()");
            }
            return this._iterator.getTableMetaData();
        }

        @Override
        public ITable getTable() throws DataSetException {
            if (PrimaryKeyFilter.this.logger.isDebugEnabled()) {
                PrimaryKeyFilter.this.logger.debug("Iterator.getTable()");
            }
            ITable table = this._iterator.getTable();
            String tableName = table.getTableMetaData().getTableName();
            SortedSet allowedPKs = PrimaryKeyFilter.this.allowedPKsPerTable.get(tableName);
            if (allowedPKs != null) {
                return new PrimaryKeyFilteredTableWrapper(table, allowedPKs);
            }
            return table;
        }
    }

    public static class PkTableMap {
        private final ListOrderedMap pksPerTable;
        private final Logger logger = LoggerFactory.getLogger(PkTableMap.class);

        public PkTableMap() {
            this.pksPerTable = new ListOrderedMap();
        }

        public PkTableMap(PkTableMap allowedPKs) {
            this.pksPerTable = new ListOrderedMap();
            for (Map.Entry entry : allowedPKs.pksPerTable.entrySet()) {
                String table = (String)entry.getKey();
                SortedSet pkObjectSet = (SortedSet)entry.getValue();
                TreeSet newSet = new TreeSet(pkObjectSet);
                this.pksPerTable.put((Object)table, newSet);
            }
        }

        public int size() {
            return this.pksPerTable.size();
        }

        public boolean isEmpty() {
            return this.pksPerTable.isEmpty();
        }

        public boolean contains(String table, Object pkObject) {
            SortedSet pksPerTable = this.get(table);
            return pksPerTable != null && pksPerTable.contains(pkObject);
        }

        public void remove(String tableName) {
            this.pksPerTable.remove((Object)tableName);
        }

        public void put(String table, SortedSet pkObjects) {
            this.pksPerTable.put((Object)table, (Object)pkObjects);
        }

        public void add(String tableName, Object pkObject) {
            SortedSet pksPerTable = this.getCreateIfNeeded(tableName);
            pksPerTable.add(pkObject);
        }

        public void addAll(String tableName, Set pkObjectsToAdd) {
            SortedSet pksPerTable = this.getCreateIfNeeded(tableName);
            pksPerTable.addAll(pkObjectsToAdd);
        }

        public SortedSet get(String tableName) {
            return (SortedSet)this.pksPerTable.get((Object)tableName);
        }

        private SortedSet getCreateIfNeeded(String tableName) {
            TreeSet pksPerTable = this.get(tableName);
            if (pksPerTable == null) {
                pksPerTable = new TreeSet();
                this.pksPerTable.put((Object)tableName, pksPerTable);
            }
            return pksPerTable;
        }

        public String[] getTableNames() {
            return this.pksPerTable.keySet().toArray(new String[0]);
        }

        public void retainOnly(List tableNames) {
            ArrayList<String> tablesToRemove = new ArrayList<String>();
            for (Map.Entry entry : this.pksPerTable.entrySet()) {
                String table = (String)entry.getKey();
                SortedSet pksToScan = (SortedSet)entry.getValue();
                boolean removeIt = pksToScan.isEmpty();
                if (!tableNames.contains(table)) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Discarding ids " + pksToScan + " of table " + table + "as this table has not been passed as input");
                    }
                    removeIt = true;
                }
                if (!removeIt) continue;
                tablesToRemove.add(table);
            }
            Iterator iterator = tablesToRemove.iterator();
            while (iterator.hasNext()) {
                this.remove((String)iterator.next());
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("pKsPerTable=").append(this.pksPerTable);
            return sb.toString();
        }
    }
}

