/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.database.AbstractResultSetTable;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardOnlyResultSetTable
extends AbstractResultSetTable {
    private static final Logger logger = LoggerFactory.getLogger(ForwardOnlyResultSetTable.class);
    private int _lastRow = -1;
    private boolean _eot = false;

    public ForwardOnlyResultSetTable(ITableMetaData metaData, ResultSet resultSet) throws SQLException, DataSetException {
        super(metaData, resultSet);
    }

    public ForwardOnlyResultSetTable(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException, SQLException {
        super(metaData, connection);
    }

    public ForwardOnlyResultSetTable(String tableName, String selectStatement, IDatabaseConnection connection) throws DataSetException, SQLException {
        super(tableName, selectStatement, connection);
    }

    @Override
    public int getRowCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue(int row, String columnName) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)columnName);
        }
        try {
            while (!this._eot && row > this._lastRow) {
                this._eot = !this._resultSet.next();
                ++this._lastRow;
            }
            if (row < this._lastRow) {
                throw new UnsupportedOperationException("Cannot go backward!");
            }
            if (this._eot || row > this._lastRow) {
                this.close();
                throw new RowOutOfBoundsException(String.valueOf(row) + " > " + this._lastRow);
            }
            int columnIndex = this.getColumnIndex(columnName);
            Column column = this._metaData.getColumns()[columnIndex];
            return column.getDataType().getSqlValue(columnIndex + 1, this._resultSet);
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(2000);
        sb.append(super.toString());
        sb.append(", ");
        sb.append(this.getClass().getName()).append("[");
        sb.append("_eot=[").append(this._eot).append("], ");
        sb.append("_lastRow=[").append(this._lastRow).append("]");
        sb.append("]");
        return sb.toString();
    }
}

