/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import pureconfig.ConfigObjectSource;
import pureconfig.ConfigReader;
import pureconfig.ConfigSource$;
import pureconfig.ConfigWriter;
import pureconfig.Derivation;
import pureconfig.error.ConfigReaderException;
import pureconfig.error.ConfigReaderFailures;
import scala.Function1;
import scala.Function2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.reflect.ClassTag;
import scala.util.Either;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public <A> Either<ConfigReaderFailures, A> loadConfig(Derivation<ConfigReader<A>> reader) {
        return ConfigSource$.MODULE$.default().load(reader);
    }

    public <A> Either<ConfigReaderFailures, A> loadConfig(String namespace, Derivation<ConfigReader<A>> reader) {
        return ConfigSource$.MODULE$.default().at(namespace).load(reader);
    }

    public <A> Either<ConfigReaderFailures, A> loadConfig(Path path, Derivation<ConfigReader<A>> reader) {
        return ConfigSource$.MODULE$.default(ConfigSource$.MODULE$.file(path)).load(reader);
    }

    public <A> Either<ConfigReaderFailures, A> loadConfig(Path path, String namespace, Derivation<ConfigReader<A>> reader) {
        return ConfigSource$.MODULE$.default(ConfigSource$.MODULE$.file(path)).at(namespace).load(reader);
    }

    public <A> Either<ConfigReaderFailures, A> loadConfig(Config conf, Derivation<ConfigReader<A>> reader) {
        return ConfigSource$.MODULE$.fromConfig(conf).load(reader);
    }

    public <A> Either<ConfigReaderFailures, A> loadConfig(Config conf, String namespace, Derivation<ConfigReader<A>> reader) {
        return ConfigSource$.MODULE$.fromConfig(conf).at(namespace).load(reader);
    }

    public <A> Either<ConfigReaderFailures, A> loadConfigWithFallback(Config conf, Derivation<ConfigReader<A>> reader) {
        return ConfigSource$.MODULE$.fromConfig(conf).withFallback(ConfigSource$.MODULE$.default()).load(reader);
    }

    public <A> Either<ConfigReaderFailures, A> loadConfigWithFallback(Config conf, String namespace, Derivation<ConfigReader<A>> reader) {
        return ConfigSource$.MODULE$.fromConfig(conf).withFallback(ConfigSource$.MODULE$.default()).at(namespace).load(reader);
    }

    public <A> A loadConfigOrThrow(ClassTag<A> evidence$1, Derivation<ConfigReader<A>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default().loadOrThrow(evidence$1, reader);
    }

    public <A> A loadConfigOrThrow(String namespace, ClassTag<A> evidence$2, Derivation<ConfigReader<A>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default().at(namespace).loadOrThrow(evidence$2, reader);
    }

    public <A> A loadConfigOrThrow(Path path, ClassTag<A> evidence$3, Derivation<ConfigReader<A>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default(ConfigSource$.MODULE$.file(path)).loadOrThrow(evidence$3, reader);
    }

    public <A> A loadConfigOrThrow(Path path, String namespace, ClassTag<A> evidence$4, Derivation<ConfigReader<A>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default(ConfigSource$.MODULE$.file(path)).at(namespace).loadOrThrow(evidence$4, reader);
    }

    public <A> A loadConfigOrThrow(Config conf, ClassTag<A> evidence$5, Derivation<ConfigReader<A>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.fromConfig(conf).loadOrThrow(evidence$5, reader);
    }

    public <A> A loadConfigOrThrow(Config conf, String namespace, ClassTag<A> evidence$6, Derivation<ConfigReader<A>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.fromConfig(conf).at(namespace).loadOrThrow(evidence$6, reader);
    }

    public <A> A loadConfigWithFallbackOrThrow(Config conf, ClassTag<A> evidence$7, Derivation<ConfigReader<A>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.fromConfig(conf).withFallback(ConfigSource$.MODULE$.default()).loadOrThrow(evidence$7, reader);
    }

    public <A> A loadConfigWithFallbackOrThrow(Config conf, String namespace, ClassTag<A> evidence$8, Derivation<ConfigReader<A>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.fromConfig(conf).withFallback(ConfigSource$.MODULE$.default()).at(namespace).loadOrThrow(evidence$8, reader);
    }

    public <A> void saveConfigAsPropertyFile(A conf, Path outputPath, boolean overrideOutputPath, ConfigRenderOptions options, Derivation<ConfigWriter<A>> writer) throws IllegalArgumentException {
        if (!overrideOutputPath && Files.isRegularFile(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(62).append("Cannot save configuration in file '").append(outputPath).append("' because it already exists").toString());
        }
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(81).append("Cannot save configuration in file '").append(outputPath).append("' because it already exists and is a directory").toString());
        }
        this.saveConfigToStream(conf, Files.newOutputStream(outputPath, new OpenOption[0]), options, writer);
    }

    public <A> boolean saveConfigAsPropertyFile$default$3() {
        return false;
    }

    public <A> ConfigRenderOptions saveConfigAsPropertyFile$default$4() {
        return ConfigRenderOptions.defaults();
    }

    public <A> void saveConfigToStream(A conf, OutputStream outputStream, ConfigRenderOptions options, Derivation<ConfigWriter<A>> writer) {
        OutputStreamWriter printOutputStream = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        ConfigValue rawConf = writer.value().to(conf);
        printOutputStream.write(rawConf.render(options));
        printOutputStream.close();
    }

    public <A> ConfigRenderOptions saveConfigToStream$default$3() {
        return ConfigRenderOptions.defaults();
    }

    public <A> Either<ConfigReaderFailures, A> loadConfigFromFiles(Iterable<Path> files, boolean failOnReadError, String namespace, Derivation<ConfigReader<A>> reader) {
        return ConfigSource$.MODULE$.default((ConfigObjectSource)((IterableOnceOps)((IterableOps)files.map((Function1 & Serializable)path -> ConfigSource$.MODULE$.file((Path)path))).map((Function1 & Serializable)cs -> failOnReadError ? cs : cs.optional())).foldLeft((Object)ConfigSource$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> x$1.withFallback((ConfigObjectSource)x$2))).at(namespace).load(reader);
    }

    public <A> boolean loadConfigFromFiles$default$2() {
        return false;
    }

    public <A> String loadConfigFromFiles$default$3() {
        return "";
    }

    public <A> A loadConfigFromFilesOrThrow(Iterable<Path> files, ClassTag<A> evidence$9, Derivation<ConfigReader<A>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default((ConfigObjectSource)((IterableOnceOps)files.map((Function1 & Serializable)x$3 -> ConfigSource$.MODULE$.file((Path)x$3).optional())).foldLeft((Object)ConfigSource$.MODULE$.empty(), (Function2 & Serializable)(x$4, x$5) -> x$4.withFallback((ConfigObjectSource)x$5))).loadOrThrow(evidence$9, reader);
    }

    private package$() {
    }
}

