/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.StaticService;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.language.simple.SimpleTokenizer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Language(value="simple")
public class SimpleLanguage
extends LanguageSupport
implements StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleLanguage.class);
    private static final SimpleLanguage SIMPLE = new SimpleLanguage();
    boolean allowEscape = true;
    private Map<String, Expression> cacheExpression;
    private Map<String, Predicate> cachePredicate;

    public void init() {
        if (this.cacheExpression == null && this.cachePredicate == null && this.getCamelContext() != null) {
            int maxSize = CamelContextHelper.getMaximumSimpleCacheSize((CamelContext)this.getCamelContext());
            if (maxSize > 0) {
                this.cacheExpression = LRUCacheFactory.newLRUCache((int)16, (int)maxSize, (boolean)false);
                this.cachePredicate = LRUCacheFactory.newLRUCache((int)16, (int)maxSize, (boolean)false);
                LOG.debug("Simple language predicate/expression cache size: {}", (Object)maxSize);
            } else {
                LOG.debug("Simple language disabled predicate/expression cache");
            }
        }
    }

    public void start() {
    }

    public void stop() {
        LRUCache cache;
        if (this.cachePredicate instanceof LRUCache) {
            if (LOG.isDebugEnabled()) {
                cache = (LRUCache)this.cachePredicate;
                LOG.debug("Clearing simple language predicate cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{cache.size(), cache.getHits(), cache.getMisses(), cache.getEvicted()});
            }
            this.cachePredicate.clear();
        }
        if (this.cacheExpression instanceof LRUCache) {
            if (LOG.isDebugEnabled()) {
                cache = (LRUCache)this.cacheExpression;
                LOG.debug("Clearing simple language expression cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{cache.size(), cache.getHits(), cache.getMisses(), cache.getEvicted()});
            }
            this.cacheExpression.clear();
        }
    }

    public Predicate createPredicate(String expression) {
        Predicate answer;
        ObjectHelper.notNull((Object)expression, (String)"expression");
        Predicate predicate = answer = this.cachePredicate != null ? this.cachePredicate.get(expression) : null;
        if (answer == null) {
            expression = this.loadResource(expression);
            SimplePredicateParser parser = new SimplePredicateParser(expression, this.allowEscape, this.cacheExpression);
            answer = parser.parsePredicate();
            if (this.cachePredicate != null && answer != null) {
                this.cachePredicate.put(expression, answer);
            }
        }
        return answer;
    }

    public Expression createExpression(String expression) {
        Expression answer;
        ObjectHelper.notNull((Object)expression, (String)"expression");
        Expression expression2 = answer = this.cacheExpression != null ? this.cacheExpression.get(expression) : null;
        if (answer == null) {
            expression = this.loadResource(expression);
            SimpleExpressionParser parser = new SimpleExpressionParser(expression, this.allowEscape, this.cacheExpression);
            answer = parser.parseExpression();
            if (this.cacheExpression != null && answer != null) {
                this.cacheExpression.put(expression, answer);
            }
        }
        return answer;
    }

    public static Expression simple(String expression) {
        return SimpleLanguage.expression(expression);
    }

    public static Expression simple(String expression, Class<?> resultType) {
        return new SimpleLanguage().createExpression(expression, resultType);
    }

    public Expression createExpression(String expression, Class<?> resultType) {
        if (resultType == Boolean.class || resultType == Boolean.TYPE) {
            Predicate predicate = this.createPredicate(expression);
            return PredicateToExpressionAdapter.toExpression((Predicate)predicate);
        }
        Expression exp = this.createExpression(expression);
        if (resultType != null) {
            exp = ExpressionBuilder.convertToExpression((Expression)exp, resultType);
        }
        return exp;
    }

    public static Expression expression(String expression) {
        return SIMPLE.createExpression(expression);
    }

    public static Predicate predicate(String predicate) {
        return SIMPLE.createPredicate(predicate);
    }

    public static boolean hasSimpleFunction(String expression) {
        return SimpleTokenizer.hasFunctionStartToken(expression);
    }
}

