/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment.setter;

import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.deployment.setter.AbstractPropertySetter;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreviousBehaviourPropertySetter
extends AbstractPropertySetter {
    public static final String PREVIOUS_BEHAVIOUR_KEY = "server.mapping.override.deployed.fields.on.update.previous.behaviour";
    private static final Logger logger = LoggerFactory.getLogger(PreviousBehaviourPropertySetter.class);

    @Autowired
    public PreviousBehaviourPropertySetter(RepositoryService repository) {
        super(repository);
    }

    private void checkWhetherValueIsSecureAndPropertyIsPassword(Object value, PropertyDescriptor deployedDesc, Object deployablePropertyValue) throws DictionaryValueException {
        if (value instanceof EncryptedStringValue && !deployedDesc.isPassword()) {
            logger.warn("The deployable value [{}] resolved to an encrypted value, but property [{}] is not a password field.", deployablePropertyValue, (Object)deployedDesc.getFqn());
            throw new DictionaryValueException("The deployable value [%s] resolved to an encrypted value, but property [%s] is not a password field.", new Object[]{deployablePropertyValue, deployedDesc.getFqn()});
        }
    }

    @Override
    public void setProperty(ConfigurationItem currentTarget, ConfigurationItem previousTarget, ConfigurationItem currentSource, ConfigurationItem previousSource, ConsolidatedDictionary dictionary, PropertyDescriptor targetPropertyDescriptor, PropertyDescriptor sourcePropertyDescriptor) {
        boolean oldDeployableValueNotSet;
        String targetPropertyName = targetPropertyDescriptor.getName();
        String sourcePropertyName = sourcePropertyDescriptor != null ? sourcePropertyDescriptor.getName() : null;
        Object previousTargetValue = this.getValueIfExists(previousTarget, targetPropertyName);
        Object previousSourceValue = this.getValueIfExists(previousSource, sourcePropertyName);
        Object currentSourceValue = this.getValueIfExists(currentSource, sourcePropertyName);
        Object valueToSet = previousTargetValue;
        PropertyDescriptor valueToSetPropDesc = targetPropertyDescriptor;
        if (previousTargetValue != null) {
            this.setSilently(currentTarget, targetPropertyDescriptor, previousTargetValue);
            return;
        }
        boolean oldDeployableHadPLaceholder = previousSourceValue != null && MustachePlaceholderScanner.hasPlaceholders((Object)previousSourceValue, (PropertyDescriptor)sourcePropertyDescriptor);
        boolean bl = oldDeployableValueNotSet = previousSourceValue == null && currentSourceValue != null;
        if (oldDeployableHadPLaceholder || oldDeployableValueNotSet) {
            valueToSet = currentSourceValue;
            valueToSetPropDesc = sourcePropertyDescriptor;
        }
        if (this.isNullOrEmpty(valueToSet, valueToSetPropDesc)) {
            this.setDeployedFromDictionary(currentTarget, dictionary, targetPropertyDescriptor, sourcePropertyDescriptor);
            return;
        }
        try {
            HashSet missingPlaceholdersAggregator = new HashSet();
            Object deployedPropertyValue = dictionary.resolve(valueToSet, valueToSetPropDesc, missingPlaceholdersAggregator);
            this.checkWhetherValueIsSecureAndPropertyIsPassword(deployedPropertyValue, targetPropertyDescriptor, valueToSet);
            this.setSilently(currentTarget, targetPropertyDescriptor, this.convertIfNeeded(deployedPropertyValue, valueToSetPropDesc, targetPropertyDescriptor));
        }
        catch (DictionaryValueException e) {
            logger.info("Could not resolve dictionary keys for property {} on {}.", (Object)sourcePropertyDescriptor, (Object)currentTarget);
            logger.trace("Exception was", (Throwable)e);
        }
    }
}

