/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.jboss.resteasy.core.NoMessageBodyWriterFoundFailure;

@Provider
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class StreamXmlReaderWriter
implements MessageBodyReader<Stream<Object>>,
MessageBodyWriter<Stream<Object>> {
    private static byte[] DEFAULT_START_LIST = new byte[]{60, 108, 105, 115, 116, 62};
    private static byte[] DEFAULT_END_LIST = new byte[]{60, 47, 108, 105, 115, 116, 62};
    private Map<String, ElementHolder> elementsCache = new HashMap<String, ElementHolder>();
    @Context
    private Providers providers;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Stream.class.isAssignableFrom(type) && genericType instanceof ParameterizedType;
    }

    public Stream<Object> readFrom(Class<Stream<Object>> type, final Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ParameterizedType listType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return ((ParameterizedType)genericType).getActualTypeArguments();
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
        MessageBodyReader listReader = this.providers.getMessageBodyReader(List.class, (Type)listType, annotations, mediaType);
        List list = (List)listReader.readFrom(List.class, (Type)listType, annotations, mediaType, httpHeaders, entityStream);
        return list.stream();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Stream.class.isAssignableFrom(type) && genericType instanceof ParameterizedType;
    }

    public long getSize(Stream<Object> stream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Stream<Object> stream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Type argumentType;
        Class argumentClass;
        MessageBodyWriter writer;
        byte[] startList = DEFAULT_START_LIST;
        byte[] endList = DEFAULT_END_LIST;
        XmlElementWrapper wrapper = StreamXmlReaderWriter.findAnnotation(annotations, XmlElementWrapper.class);
        if (wrapper != null) {
            ElementHolder holder = this.elementsCache.computeIfAbsent(wrapper.name(), x$0 -> ElementHolder.create(x$0));
            startList = holder.startList;
            endList = holder.endList;
        }
        if ((writer = this.providers.getMessageBodyWriter(argumentClass = (Class)(argumentType = ((ParameterizedType)genericType).getActualTypeArguments()[0]), argumentType, annotations, mediaType)) == null) {
            throw new NoMessageBodyWriterFoundFailure((Class)argumentType, mediaType);
        }
        this.doWrite(stream, argumentClass, argumentType, annotations, mediaType, httpHeaders, entityStream, startList, endList, writer);
    }

    private void doWrite(Stream<Object> stream, Class actualClass, Type argumentType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream, byte[] startList, byte[] endList, MessageBodyWriter actualWriter) throws IOException {
        try (Stream<Object> s = stream;){
            entityStream.write(startList);
            s.forEachOrdered(o -> {
                try {
                    actualWriter.writeTo(o, actualClass, argumentType, annotations, mediaType, httpHeaders, entityStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            entityStream.write(endList);
        }
    }

    private static <T extends Annotation> T findAnnotation(Annotation[] annotations, Class<T> type) {
        for (Annotation annotation : annotations) {
            if (!type.isInstance(annotation)) continue;
            return (T)((Annotation)type.cast(annotation));
        }
        return null;
    }

    static byte[] createStartElement(String elementName) {
        byte[] startList = new byte[elementName.length() + 2];
        startList[0] = 60;
        System.arraycopy(elementName.getBytes(), 0, startList, 1, startList.length - 2);
        startList[startList.length - 1] = 62;
        return startList;
    }

    static byte[] createEndElement(String elementName) {
        byte[] endList = new byte[elementName.length() + 3];
        endList[0] = 60;
        endList[1] = 47;
        System.arraycopy(elementName.getBytes(), 0, endList, 2, endList.length - 3);
        endList[endList.length - 1] = 62;
        return endList;
    }

    private static class ElementHolder {
        private final byte[] startList;
        private final byte[] endList;

        private ElementHolder(byte[] startList, byte[] endList) {
            this.startList = startList;
            this.endList = endList;
        }

        private static ElementHolder create(String s) {
            return new ElementHolder(StreamXmlReaderWriter.createStartElement(s), StreamXmlReaderWriter.createEndElement(s));
        }
    }
}

