/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Address;
import akka.annotation.InternalApi;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$ClusterShuttingDown$;
import akka.cluster.ClusterEvent$InitialStateAsEvents$;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterEvent$ReachableDataCenter$;
import akka.cluster.ClusterEvent$UnreachableDataCenter$;
import akka.cluster.Gossip;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.cluster.MemberStatus$Down$;
import akka.cluster.MemberStatus$Exiting$;
import akka.cluster.MemberStatus$Joining$;
import akka.cluster.MemberStatus$Leaving$;
import akka.cluster.MemberStatus$PreparingForShutdown$;
import akka.cluster.MemberStatus$ReadyForShutdown$;
import akka.cluster.MemberStatus$Removed$;
import akka.cluster.MemberStatus$Up$;
import akka.cluster.MemberStatus$WeaklyUp$;
import akka.cluster.MembershipState;
import akka.cluster.Reachability;
import akka.cluster.UniqueAddress;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.VectorBuilder;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterEvent$ {
    public static final ClusterEvent$ MODULE$ = new ClusterEvent$();

    public ClusterEvent$InitialStateAsSnapshot$ initialStateAsSnapshot() {
        return ClusterEvent$InitialStateAsSnapshot$.MODULE$;
    }

    public ClusterEvent$InitialStateAsEvents$ initialStateAsEvents() {
        return ClusterEvent$InitialStateAsEvents$.MODULE$;
    }

    public ClusterEvent$ClusterShuttingDown$ getClusterShuttingDownInstance() {
        return ClusterEvent$ClusterShuttingDown$.MODULE$;
    }

    @InternalApi
    public Seq<ClusterEvent.UnreachableMember> diffUnreachable(MembershipState oldState, MembershipState newState) {
        Nil$ nil$;
        if (newState == oldState) {
            nil$ = Nil$.MODULE$;
        } else {
            Gossip newGossip = newState.latestGossip();
            scala.collection.immutable.Set<UniqueAddress> oldUnreachableNodes = oldState.dcReachabilityNoOutsideNodes().allUnreachableOrTerminated();
            nil$ = (Seq)newState.dcReachabilityNoOutsideNodes().allUnreachableOrTerminated().iterator().collect((PartialFunction)new Serializable(oldUnreachableNodes, newState, newGossip){
                private static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Set oldUnreachableNodes$1;
                private final MembershipState newState$1;
                private final Gossip newGossip$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends UniqueAddress, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (!this.oldUnreachableNodes$1.contains(A1)) {
                        A1 A12 = A1;
                        UniqueAddress uniqueAddress = this.newState$1.selfUniqueAddress();
                        if (A12 == null ? uniqueAddress != null : !((Object)A12).equals(uniqueAddress)) {
                            object = new ClusterEvent.UnreachableMember(this.newGossip$1.member(A1));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(UniqueAddress x1) {
                    UniqueAddress uniqueAddress = x1;
                    if (this.oldUnreachableNodes$1.contains((Object)uniqueAddress)) return false;
                    UniqueAddress uniqueAddress2 = uniqueAddress;
                    UniqueAddress uniqueAddress3 = this.newState$1.selfUniqueAddress();
                    if (uniqueAddress2 == null) {
                        if (uniqueAddress3 == null) return false;
                        return true;
                    } else if (((Object)uniqueAddress2).equals(uniqueAddress3)) return false;
                    return true;
                }
                {
                    this.oldUnreachableNodes$1 = oldUnreachableNodes$1;
                    this.newState$1 = newState$1;
                    this.newGossip$1 = newGossip$1;
                }
            }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
        }
        return nil$;
    }

    @InternalApi
    public Seq<ClusterEvent.ReachableMember> diffReachable(MembershipState oldState, MembershipState newState) {
        Nil$ nil$;
        if (newState == oldState) {
            nil$ = Nil$.MODULE$;
        } else {
            Gossip newGossip = newState.latestGossip();
            nil$ = (Seq)oldState.dcReachabilityNoOutsideNodes().allUnreachable().iterator().collect((PartialFunction)new Serializable(newGossip, newState){
                private static final long serialVersionUID = 0L;
                private final Gossip newGossip$2;
                private final MembershipState newState$2;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends UniqueAddress, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (this.newGossip$2.hasMember(A1) && this.newState$2.dcReachabilityNoOutsideNodes().isReachable(A1)) {
                        A1 A12 = A1;
                        UniqueAddress uniqueAddress = this.newState$2.selfUniqueAddress();
                        if (A12 == null ? uniqueAddress != null : !((Object)A12).equals(uniqueAddress)) {
                            object = new ClusterEvent.ReachableMember(this.newGossip$2.member(A1));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(UniqueAddress x1) {
                    UniqueAddress uniqueAddress = x1;
                    if (!this.newGossip$2.hasMember(uniqueAddress)) return false;
                    if (!this.newState$2.dcReachabilityNoOutsideNodes().isReachable(uniqueAddress)) return false;
                    UniqueAddress uniqueAddress2 = uniqueAddress;
                    UniqueAddress uniqueAddress3 = this.newState$2.selfUniqueAddress();
                    if (uniqueAddress2 == null) {
                        if (uniqueAddress3 == null) return false;
                        return true;
                    } else if (((Object)uniqueAddress2).equals(uniqueAddress3)) return false;
                    return true;
                }
                {
                    this.newGossip$2 = newGossip$2;
                    this.newState$2 = newState$2;
                }
            }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
        }
        return nil$;
    }

    @InternalApi
    public boolean isDataCenterReachable(MembershipState state, String otherDc) {
        SortedSet unrelatedDcNodes = (SortedSet)state.latestGossip().members().collect((PartialFunction)new Serializable(otherDc, state){
            private static final long serialVersionUID = 0L;
            private final String otherDc$1;
            private final MembershipState state$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                String string = A1.dataCenter();
                String string2 = this.otherDc$1;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String string3 = A1.dataCenter();
                    String string4 = this.state$1.selfDc();
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        object = A1.uniqueAddress();
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Member x1) {
                Member member = x1;
                String string = member.dataCenter();
                String string2 = this.otherDc$1;
                if (string == null) {
                    if (string2 == null) return false;
                } else if (string.equals(string2)) return false;
                String string3 = member.dataCenter();
                String string4 = this.state$1.selfDc();
                if (string3 == null) {
                    if (string4 == null) return false;
                    return true;
                } else if (string3.equals(string4)) return false;
                return true;
            }
            {
                this.otherDc$1 = otherDc$1;
                this.state$1 = state$1;
            }
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Reachability reachabilityForOtherDc = state.dcReachabilityWithoutObservationsWithin().remove((Iterable<UniqueAddress>)unrelatedDcNodes);
        return reachabilityForOtherDc.allUnreachable().isEmpty();
    }

    @InternalApi
    public Seq<ClusterEvent.UnreachableDataCenter> diffUnreachableDataCenter(MembershipState oldState, MembershipState newState) {
        Nil$ nil$;
        if (newState == oldState) {
            nil$ = Nil$.MODULE$;
        } else {
            scala.collection.immutable.Set otherDcs = (scala.collection.immutable.Set)((SetOps)oldState.latestGossip().allDataCenters().union(newState.latestGossip().allDataCenters())).$minus((Object)newState.selfDc());
            scala.collection.immutable.Set oldUnreachableDcs = (scala.collection.immutable.Set)otherDcs.filterNot((Function1 & Serializable)otherDc -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.MODULE$.isDataCenterReachable(oldState, otherDc)));
            scala.collection.immutable.Set currentUnreachableDcs = (scala.collection.immutable.Set)otherDcs.filterNot((Function1 & Serializable)otherDc -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.MODULE$.isDataCenterReachable(newState, otherDc)));
            nil$ = (Seq)currentUnreachableDcs.diff((Set)oldUnreachableDcs).iterator().map((Function1)ClusterEvent$UnreachableDataCenter$.MODULE$).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
        }
        return nil$;
    }

    @InternalApi
    public Seq<ClusterEvent.ReachableDataCenter> diffReachableDataCenter(MembershipState oldState, MembershipState newState) {
        Nil$ nil$;
        if (newState == oldState) {
            nil$ = Nil$.MODULE$;
        } else {
            scala.collection.immutable.Set otherDcs = (scala.collection.immutable.Set)((SetOps)oldState.latestGossip().allDataCenters().union(newState.latestGossip().allDataCenters())).$minus((Object)newState.selfDc());
            scala.collection.immutable.Set oldUnreachableDcs = (scala.collection.immutable.Set)otherDcs.filterNot((Function1 & Serializable)otherDc -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.MODULE$.isDataCenterReachable(oldState, otherDc)));
            scala.collection.immutable.Set currentUnreachableDcs = (scala.collection.immutable.Set)otherDcs.filterNot((Function1 & Serializable)otherDc -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.MODULE$.isDataCenterReachable(newState, otherDc)));
            nil$ = (Seq)oldUnreachableDcs.diff((Set)currentUnreachableDcs).iterator().map((Function1)ClusterEvent$ReachableDataCenter$.MODULE$).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
        }
        return nil$;
    }

    @InternalApi
    public Seq<ClusterEvent.MemberEvent> diffMemberEvents(MembershipState oldState, MembershipState newState) {
        Nil$ nil$;
        if (newState == oldState) {
            nil$ = Nil$.MODULE$;
        } else {
            Gossip oldGossip = oldState.latestGossip();
            Gossip newGossip = newState.latestGossip();
            SortedSet newMembers = (SortedSet)newGossip.members().diff(oldGossip.members());
            Map membersGroupedByAddress = ((IterableOps)((StrictOptimizedIterableOps)new .colon.colon(newGossip.members(), (List)new .colon.colon(oldGossip.members(), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())).groupBy((Function1 & Serializable)x$3 -> x$3.uniqueAddress());
            scala.collection.immutable.Iterable changedMembers = (scala.collection.immutable.Iterable)membersGroupedByAddress.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<UniqueAddress, List<Member>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    List list;
                    A1 A1 = x1;
                    if (A1 != null && (list = (List)A1._2()) instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        Member newMember = (Member)colon2.head();
                        List list2 = colon2.next$access$1();
                        if (list2 instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list2;
                            Member oldMember = (Member)colon3.head();
                            List list3 = colon3.next$access$1();
                            if (Nil$.MODULE$.equals(list3)) {
                                MemberStatus memberStatus = newMember.status();
                                MemberStatus memberStatus2 = oldMember.status();
                                if ((memberStatus != null ? !memberStatus.equals(memberStatus2) : memberStatus2 != null) || newMember.upNumber() != oldMember.upNumber()) {
                                    object = newMember;
                                    return (B1)object;
                                }
                            }
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<UniqueAddress, List<Member>> x1) {
                    Tuple2<UniqueAddress, List<Member>> tuple2 = x1;
                    if (tuple2 == null) return false;
                    List list = (List)tuple2._2();
                    if (!(list instanceof .colon.colon)) return false;
                    .colon.colon colon2 = (.colon.colon)list;
                    Member newMember = (Member)colon2.head();
                    List list2 = colon2.next$access$1();
                    if (!(list2 instanceof .colon.colon)) return false;
                    .colon.colon colon3 = (.colon.colon)list2;
                    Member oldMember = (Member)colon3.head();
                    List list3 = colon3.next$access$1();
                    if (!Nil$.MODULE$.equals(list3)) return false;
                    MemberStatus memberStatus = newMember.status();
                    MemberStatus memberStatus2 = oldMember.status();
                    if (memberStatus == null) {
                        if (memberStatus2 != null) {
                            return true;
                        }
                    } else if (!memberStatus.equals(memberStatus2)) return true;
                    if (newMember.upNumber() == oldMember.upNumber()) return false;
                    return true;
                }
            });
            scala.collection.immutable.Set memberEvents = (scala.collection.immutable.Set)((SortedSet)newMembers.$plus$plus((IterableOnce)changedMembers)).unsorted().collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    MemberStatus memberStatus = A1.status();
                    MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
                    if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Joining$) : memberStatus$Joining$ != null)) {
                        object = new ClusterEvent.MemberJoined(A1);
                    } else {
                        MemberStatus memberStatus2 = A1.status();
                        MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
                        if (!(memberStatus2 != null ? !memberStatus2.equals(memberStatus$WeaklyUp$) : memberStatus$WeaklyUp$ != null)) {
                            object = new ClusterEvent.MemberWeaklyUp(A1);
                        } else {
                            MemberStatus memberStatus3 = A1.status();
                            MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                            if (!(memberStatus3 != null ? !memberStatus3.equals(memberStatus$Up$) : memberStatus$Up$ != null)) {
                                object = new ClusterEvent.MemberUp(A1);
                            } else {
                                MemberStatus memberStatus4 = A1.status();
                                MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
                                if (!(memberStatus4 != null ? !memberStatus4.equals(memberStatus$Leaving$) : memberStatus$Leaving$ != null)) {
                                    object = new ClusterEvent.MemberLeft(A1);
                                } else {
                                    MemberStatus memberStatus5 = A1.status();
                                    MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                                    if (!(memberStatus5 != null ? !memberStatus5.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null)) {
                                        object = new ClusterEvent.MemberExited(A1);
                                    } else {
                                        MemberStatus memberStatus6 = A1.status();
                                        MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                                        if (!(memberStatus6 != null ? !memberStatus6.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                                            object = new ClusterEvent.MemberDowned(A1);
                                        } else {
                                            MemberStatus memberStatus7 = A1.status();
                                            MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
                                            if (!(memberStatus7 != null ? !memberStatus7.equals(memberStatus$PreparingForShutdown$) : memberStatus$PreparingForShutdown$ != null)) {
                                                object = new ClusterEvent.MemberPreparingForShutdown(A1);
                                            } else {
                                                MemberStatus memberStatus8 = A1.status();
                                                MemberStatus$ReadyForShutdown$ memberStatus$ReadyForShutdown$ = MemberStatus$ReadyForShutdown$.MODULE$;
                                                object = !(memberStatus8 != null ? !memberStatus8.equals(memberStatus$ReadyForShutdown$) : memberStatus$ReadyForShutdown$ != null) ? new ClusterEvent.MemberReadyForShutdown(A1) : function1.apply(x2);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Member x2) {
                    boolean bl;
                    Member member = x2;
                    MemberStatus memberStatus = member.status();
                    MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
                    if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Joining$) : memberStatus$Joining$ != null)) {
                        bl = true;
                    } else {
                        MemberStatus memberStatus2 = member.status();
                        MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
                        if (!(memberStatus2 != null ? !memberStatus2.equals(memberStatus$WeaklyUp$) : memberStatus$WeaklyUp$ != null)) {
                            bl = true;
                        } else {
                            MemberStatus memberStatus3 = member.status();
                            MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                            if (!(memberStatus3 != null ? !memberStatus3.equals(memberStatus$Up$) : memberStatus$Up$ != null)) {
                                bl = true;
                            } else {
                                MemberStatus memberStatus4 = member.status();
                                MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
                                if (!(memberStatus4 != null ? !memberStatus4.equals(memberStatus$Leaving$) : memberStatus$Leaving$ != null)) {
                                    bl = true;
                                } else {
                                    MemberStatus memberStatus5 = member.status();
                                    MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                                    if (!(memberStatus5 != null ? !memberStatus5.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null)) {
                                        bl = true;
                                    } else {
                                        MemberStatus memberStatus6 = member.status();
                                        MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                                        if (!(memberStatus6 != null ? !memberStatus6.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                                            bl = true;
                                        } else {
                                            MemberStatus memberStatus7 = member.status();
                                            MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
                                            if (!(memberStatus7 != null ? !memberStatus7.equals(memberStatus$PreparingForShutdown$) : memberStatus$PreparingForShutdown$ != null)) {
                                                bl = true;
                                            } else {
                                                MemberStatus memberStatus8 = member.status();
                                                MemberStatus$ReadyForShutdown$ memberStatus$ReadyForShutdown$ = MemberStatus$ReadyForShutdown$.MODULE$;
                                                bl = !(memberStatus8 != null ? !memberStatus8.equals(memberStatus$ReadyForShutdown$) : memberStatus$ReadyForShutdown$ != null);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    return bl;
                }
            });
            SortedSet removedMembers = (SortedSet)oldGossip.members().diff(newGossip.members());
            scala.collection.immutable.Set removedEvents = (scala.collection.immutable.Set)removedMembers.unsorted().map((Function1 & Serializable)m -> new ClusterEvent.MemberRemoved(m.copy(MemberStatus$Removed$.MODULE$), m.status()));
            nil$ = ((VectorBuilder)new VectorBuilder().$plus$plus$eq((IterableOnce)removedEvents).$plus$plus$eq((IterableOnce)memberEvents)).result();
        }
        return nil$;
    }

    @InternalApi
    public Seq<ClusterEvent.LeaderChanged> diffLeader(MembershipState oldState, MembershipState newState) {
        Option<UniqueAddress> newLeader;
        Option<UniqueAddress> option = newLeader = newState.leader();
        Option<UniqueAddress> option2 = oldState.leader();
        return (option == null ? option2 != null : !option.equals(option2)) ? (Seq)new .colon.colon((Object)new ClusterEvent.LeaderChanged((Option<Address>)newLeader.map((Function1 & Serializable)x$4 -> x$4.address())), (List)Nil$.MODULE$) : Nil$.MODULE$;
    }

    @InternalApi
    public scala.collection.immutable.Set<ClusterEvent.RoleLeaderChanged> diffRolesLeader(MembershipState oldState, MembershipState newState) {
        return (scala.collection.immutable.Set)((IterableOps)oldState.latestGossip().allRoles().union(newState.latestGossip().allRoles()).map((Function1 & Serializable)role -> {
            Option<UniqueAddress> newLeader = newState.roleLeader((String)role);
            return new Tuple2(role, newLeader);
        })).withFilter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterEvent$.$anonfun$diffRolesLeader$2(oldState, x$6))).map((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String role = (String)tuple2._1();
            Option newLeader = (Option)tuple2._2();
            ClusterEvent.RoleLeaderChanged roleLeaderChanged = new ClusterEvent.RoleLeaderChanged(role, (Option<Address>)newLeader.map((Function1 & Serializable)x$5 -> x$5.address()));
            return roleLeaderChanged;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @InternalApi
    public Seq<ClusterEvent.SeenChanged> diffSeen(MembershipState oldState, MembershipState newState) {
        Nil$ nil$;
        block5: {
            scala.collection.immutable.Set<UniqueAddress> newSeenBy;
            boolean newConvergence;
            block4: {
                if (oldState == newState) {
                    nil$ = Nil$.MODULE$;
                    return nil$;
                }
                newConvergence = newState.convergence((scala.collection.immutable.Set<UniqueAddress>)Predef$.MODULE$.Set().empty());
                newSeenBy = newState.latestGossip().seenBy();
                if (newConvergence != oldState.convergence((scala.collection.immutable.Set<UniqueAddress>)Predef$.MODULE$.Set().empty())) break block4;
                scala.collection.immutable.Set<UniqueAddress> set = newSeenBy;
                scala.collection.immutable.Set<UniqueAddress> set2 = oldState.latestGossip().seenBy();
                if (!(set == null ? set2 != null : !set.equals(set2))) break block5;
            }
            nil$ = (Seq)new .colon.colon((Object)new ClusterEvent.SeenChanged(newConvergence, (scala.collection.immutable.Set<Address>)((scala.collection.immutable.Set)newSeenBy.map((Function1 & Serializable)x$8 -> x$8.address()))), (List)Nil$.MODULE$);
            return nil$;
        }
        nil$ = Nil$.MODULE$;
        return nil$;
    }

    @InternalApi
    public Seq<ClusterEvent.ReachabilityChanged> diffReachability(MembershipState oldState, MembershipState newState) {
        return newState.overview().reachability() == oldState.overview().reachability() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)new ClusterEvent.ReachabilityChanged(newState.overview().reachability()), (List)Nil$.MODULE$);
    }

    @InternalApi
    public Seq<ClusterEvent.MemberTombstonesChanged> diffTombstones(MembershipState oldState, MembershipState newState) {
        Nil$ nil$;
        Map<UniqueAddress, Object> map = newState.latestGossip().tombstones();
        Map<UniqueAddress, Object> map2 = oldState.latestGossip().tombstones();
        if (!(map != null ? !map.equals(map2) : map2 != null)) {
            nil$ = Nil$.MODULE$;
        } else {
            ClusterEvent.MemberTombstonesChanged memberTombstonesChanged = new ClusterEvent.MemberTombstonesChanged((scala.collection.immutable.Set<UniqueAddress>)newState.latestGossip().tombstones().keySet());
            nil$ = Nil$.MODULE$.$colon$colon((Object)memberTombstonesChanged);
        }
        return nil$;
    }

    @InternalApi
    public void publishDiff(MembershipState oldState, MembershipState newState, Function1<Object, BoxedUnit> pub) {
        this.diffTombstones(oldState, newState).foreach(pub);
        this.diffMemberEvents(oldState, newState).foreach(pub);
        this.diffUnreachable(oldState, newState).foreach(pub);
        this.diffReachable(oldState, newState).foreach(pub);
        this.diffUnreachableDataCenter(oldState, newState).foreach(pub);
        this.diffReachableDataCenter(oldState, newState).foreach(pub);
        this.diffLeader(oldState, newState).foreach(pub);
        this.diffRolesLeader(oldState, newState).foreach(pub);
        this.diffSeen(oldState, newState).foreach(pub);
        this.diffReachability(oldState, newState).foreach(pub);
    }

    public static final /* synthetic */ boolean $anonfun$diffRolesLeader$2(MembershipState oldState$3, Tuple2 x$6) {
        Option newLeader;
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String role = (String)tuple2._1();
        Option option = newLeader = (Option)tuple2._2();
        Option<UniqueAddress> option2 = oldState$3.roleLeader(role);
        boolean bl = option == null ? option2 != null : !option.equals(option2);
        return bl;
    }

    private ClusterEvent$() {
    }
}

