/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.cli;

import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.materializer.FilePlugin;
import com.xebialabs.plugin.manager.materializer.FilePlugin$;
import com.xebialabs.plugin.manager.sql.DbPlugin;
import com.xebialabs.plugin.manager.sql.SqlPluginRepository;
import com.xebialabs.xlplatform.sugar.PathSugar$;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005y4Aa\u0003\u0007\u0001/!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u00159\u0004\u0001\"\u00019\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015Q\b\u0001\"\u0003|\u0005A\u0001F.^4j]6\u000bg.Y4fe\u000ec\u0017N\u0003\u0002\u000e\u001d\u0005\u00191\r\\5\u000b\u0005=\u0001\u0012aB7b]\u0006<WM\u001d\u0006\u0003#I\ta\u0001\u001d7vO&t'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0011a2,x-\u001b8SKB|7/\u001b;pef\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\b\u0002\u0007M\fH.\u0003\u0002%C\t\u00192+\u001d7QYV<\u0017N\u001c*fa>\u001c\u0018\u000e^8ss\u0006IQ\r\u001f;f]NLwN\u001c\t\u0003O9r!\u0001\u000b\u0017\u0011\u0005%RR\"\u0001\u0016\u000b\u0005-2\u0012A\u0002\u001fs_>$h(\u0003\u0002.5\u00051\u0001K]3eK\u001aL!a\f\u0019\u0003\rM#(/\u001b8h\u0015\ti#$\u0001\u0004=S:LGO\u0010\u000b\u0004gU2\u0004C\u0001\u001b\u0001\u001b\u0005a\u0001\"\u0002\u0010\u0004\u0001\u0004y\u0002\"B\u0013\u0004\u0001\u00041\u0013a\u0001:v]R\t\u0011\b\u0005\u0002\u001au%\u00111H\u0007\u0002\u0005+:LG/A\thKR4%o\\7GS2,7/_:uK6$\u0012A\u0010\t\u0004\u007f\u0011;eB\u0001!C\u001d\tI\u0013)C\u0001\u001c\u0013\t\u0019%$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%aA*fc*\u00111I\u0007\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015:\tA\"\\1uKJL\u0017\r\\5{KJL!\u0001T%\u0003\u0015\u0019KG.\u001a)mk\u001eLg.\u0001\u000bbg.4uN\u001d)mk\u001eLg\u000eV8EK2,G/\u001a\u000b\u0003\u001fz#\"\u0001U-\u0015\u0007e\nv\u000bC\u0003S\r\u0001\u000f1+A\u0005eEBcWoZ5ogB\u0019q\b\u0012+\u0011\u0005\u0001*\u0016B\u0001,\"\u0005!!%\r\u00157vO&t\u0007\"\u0002-\u0007\u0001\bq\u0014!\u00034t!2,x-\u001b8t\u0011\u0015Qf\u00011\u0001\\\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0003B\r]MeJ!!\u0018\u000e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"B0\u0007\u0001\u0004\u0001\u0017!B:uI&t\u0007CA1g\u001b\u0005\u0011'BA2e\u0003\tIwNC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0014'A\u0004\"vM\u001a,'/\u001a3SK\u0006$WM]\u0001\u0007I\u0016dW\r^3\u0015\u0005)lGcA\u001dlY\")\u0001l\u0002a\u0002}!)!k\u0002a\u0002'\")an\u0002a\u0001M\u0005IQo]3s\u0013:\u0004X\u000f^\u0001\rI\u0016dW\r^3Ge>lgi\u001d\u000b\u0003cR$\"!\u000f:\t\u000bMD\u00019\u0001 \u0002\u000fAdWoZ5og\")a\u000e\u0003a\u0001M\u0005aA-\u001a7fi\u00164%o\\7EER\u0011q/\u001f\u000b\u0003saDQa]\u0005A\u0004MCQA\\\u0005A\u0002\u0019\nA\u0002\u001d:j]R\u0004F.^4j]N$2!\u000f?~\u0011\u0015\u0011&\u00021\u0001T\u0011\u0015A&\u00021\u0001?\u0001")
public class PluginManagerCli {
    private final SqlPluginRepository pluginRepository;
    private final String extension;

    public void run() {
        ConfigWrapper$.MODULE$.extension_$eq(this.extension);
        Predef$.MODULE$.println((Object)"------Welcome to Plugin Manager CLI------");
        ObjectRef pluginsFromDb = ObjectRef.create(this.pluginRepository.getAllWithoutBytes());
        ObjectRef pluginsFromFs = ObjectRef.create(this.getFromFilesystem());
        if (((Seq)pluginsFromDb.elem).nonEmpty() || ((Seq)pluginsFromFs.elem).nonEmpty()) {
            boolean deleteAnotherPlugin = true;
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            while ((((Seq)pluginsFromDb.elem).nonEmpty() || ((Seq)pluginsFromFs.elem).nonEmpty()) && deleteAnotherPlugin) {
                this.printPlugins((Seq<DbPlugin>)((Seq)pluginsFromDb.elem), (Seq<FilePlugin>)((Seq)pluginsFromFs.elem));
                this.askForPluginToDelete(stdin, (Function1<String, BoxedUnit>)(Function1 & Serializable)userInput -> {
                    this.delete(userInput, (Seq<FilePlugin>)((Seq)pluginsFromFs.elem), (Seq<DbPlugin>)((Seq)pluginsFromDb.elem));
                    return BoxedUnit.UNIT;
                }, (Seq<DbPlugin>)((Seq)pluginsFromDb.elem), (Seq<FilePlugin>)((Seq)pluginsFromFs.elem));
                Predef$.MODULE$.println((Object)"Do you want to delete another plugin? yes/no");
                if (stdin.readLine().equalsIgnoreCase("yes")) {
                    pluginsFromDb.elem = this.pluginRepository.getAllWithoutBytes();
                    pluginsFromFs.elem = this.getFromFilesystem();
                    continue;
                }
                deleteAnotherPlugin = false;
            }
        } else {
            Predef$.MODULE$.println((Object)"------No plugins in database or file system------");
        }
        Predef$.MODULE$.println((Object)"------Shutting down Plugin Manager CLI------");
        System.exit(0);
    }

    public Seq<FilePlugin> getFromFilesystem() {
        Path pluginsDir = Paths.get("plugins", new String[0]);
        return CollectionConverters$.MODULE$.IteratorHasAsScala(Files.walk(pluginsDir, new FileVisitOption[0]).filter(x$1 -> PathSugar$.MODULE$.path2File(x$1).isFile()).filter(file -> ((Object)file.getFileName()).toString().endsWith(ConfigWrapper$.MODULE$.extension())).map(filePath -> FilePlugin$.MODULE$.apply((Path)filePath)).iterator()).asScala().toSeq();
    }

    public void askForPluginToDelete(BufferedReader stdin, Function1<String, BoxedUnit> callback, Seq<DbPlugin> dbPlugins, Seq<FilePlugin> fsPlugins) {
        Predef$.MODULE$.println((Object)"If you want to exit Plugin Manager CLI type q or quit ");
        Predef$.MODULE$.println((Object)"Which plugin do you want to delete? (Please type full name without version)");
        Predef$.MODULE$.print((Object)"> ");
        String userInput = stdin.readLine();
        if (userInput.equalsIgnoreCase("q") || userInput.equalsIgnoreCase("quit")) {
            Predef$.MODULE$.println((Object)"------Shutting down Plugin Manager CLI------");
            System.exit(0);
        } else if (dbPlugins.exists((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginManagerCli.$anonfun$askForPluginToDelete$1(userInput, dbPlugin))) || fsPlugins.exists((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginManagerCli.$anonfun$askForPluginToDelete$2(userInput, fsPlugin)))) {
            callback.apply((Object)userInput);
        } else {
            Predef$.MODULE$.println((Object)"This is not a valid plugin name.");
        }
    }

    public void delete(String userInput, Seq<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins) {
        if (fsPlugins.exists((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginManagerCli.$anonfun$delete$1(userInput, fsPlugin)))) {
            this.deleteFromFs(userInput, fsPlugins);
        }
        if (dbPlugins.exists((Function1 & Serializable)dbPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginManagerCli.$anonfun$delete$2(userInput, dbPlugin)))) {
            this.deleteFromDb(userInput, dbPlugins);
        }
        Predef$.MODULE$.println((Object)"Please verify and delete plugin file in other cluster members' plugins directory if needed");
    }

    public void deleteFromFs(String userInput, Seq<FilePlugin> plugins) {
        FileUtils.forceDelete((File)PathSugar$.MODULE$.path2File(((FilePlugin)((IterableOps)plugins.filter((Function1 & Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)PluginManagerCli.$anonfun$deleteFromFs$1(userInput, plugin)))).head()).filePath()));
        Predef$.MODULE$.println((Object)new StringBuilder(24).append(userInput).append(" deleted from filesystem").toString());
    }

    public void deleteFromDb(String userInput, Seq<DbPlugin> plugins) {
        this.pluginRepository.delete((DbPlugin)((IterableOps)plugins.filter((Function1 & Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)PluginManagerCli.$anonfun$deleteFromDb$1(userInput, plugin)))).head());
        Predef$.MODULE$.println((Object)new StringBuilder(22).append(userInput).append(" deleted from database").toString());
    }

    private void printPlugins(Seq<DbPlugin> dbPlugins, Seq<FilePlugin> fsPlugins) {
        Predef$.MODULE$.println((Object)String.format("%-10s%-40s%-20s%-10s%-10s", "NUMBER", "NAME", "VERSION", "DATABASE", "FILESYSTEM"));
        Predef$.MODULE$.println((Object)"-------------------------------------------------------------------------------------------");
        IntRef pluginCounter = IntRef.create((int)1);
        dbPlugins.foreach((Function1 & Serializable)plugin -> {
            PluginManagerCli.$anonfun$printPlugins$1(fsPlugins, pluginCounter, plugin);
            return BoxedUnit.UNIT;
        });
        fsPlugins.foreach((Function1 & Serializable)plugin -> {
            PluginManagerCli.$anonfun$printPlugins$5(dbPlugins, pluginCounter, plugin);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"-------------------------------------------------------------------------------------------");
    }

    public static final /* synthetic */ boolean $anonfun$askForPluginToDelete$1(String userInput$1, DbPlugin dbPlugin) {
        return dbPlugin.name().equals(userInput$1);
    }

    public static final /* synthetic */ boolean $anonfun$askForPluginToDelete$2(String userInput$1, FilePlugin fsPlugin) {
        return fsPlugin.name().equals(userInput$1);
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(String userInput$2, FilePlugin fsPlugin) {
        return fsPlugin.name().equals(userInput$2);
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(String userInput$2, DbPlugin dbPlugin) {
        return dbPlugin.name().equals(userInput$2);
    }

    public static final /* synthetic */ boolean $anonfun$deleteFromFs$1(String userInput$3, FilePlugin plugin) {
        String string = plugin.name();
        String string2 = userInput$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteFromDb$1(String userInput$4, DbPlugin plugin) {
        String string = plugin.name();
        String string2 = userInput$4;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$printPlugins$2(DbPlugin plugin$1, FilePlugin fsPlugin) {
        return fsPlugin.name().equals(plugin$1.name()) && fsPlugin.version().equals(plugin$1.version().getOrElse((Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ void $anonfun$printPlugins$1(Seq fsPlugins$1, IntRef pluginCounter$1, DbPlugin plugin) {
        boolean existInFs = fsPlugins$1.exists((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginManagerCli.$anonfun$printPlugins$2(plugin, fsPlugin)));
        Predef$.MODULE$.println((Object)String.format("%-10s%-40s%-20s%-10s%-14s", BoxesRunTime.boxToInteger((int)pluginCounter$1.elem), plugin.name(), plugin.version().getOrElse((Function0 & Serializable)() -> ""), "+", existInFs ? "+" : "-"));
        ++pluginCounter$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$printPlugins$6(FilePlugin plugin$2, DbPlugin fsPlugin) {
        return fsPlugin.name().equals(plugin$2.name()) && ((String)fsPlugin.version().getOrElse((Function0 & Serializable)() -> "")).equals(plugin$2.version());
    }

    public static final /* synthetic */ void $anonfun$printPlugins$5(Seq dbPlugins$1, IntRef pluginCounter$1, FilePlugin plugin) {
        if (!dbPlugins$1.exists((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginManagerCli.$anonfun$printPlugins$6(plugin, fsPlugin)))) {
            Predef$.MODULE$.println((Object)String.format("%-10s%-40s%-20s%-10s%-14s", BoxesRunTime.boxToInteger((int)pluginCounter$1.elem), plugin.name(), plugin.version(), "-", "+"));
        }
        ++pluginCounter$1.elem;
    }

    public PluginManagerCli(SqlPluginRepository pluginRepository, String extension) {
        this.pluginRepository = pluginRepository;
        this.extension = extension;
    }
}

