/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2.client;

import akka.annotation.InternalApi;
import akka.http.impl.engine.http2.Http2SubStream;
import akka.http.impl.engine.http2.RequestParsing$;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.server.HttpAttributes;
import akka.http.javadsl.model.AttributeKey;
import akka.http.scaladsl.model.AttributeKeys$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.SslSessionInfo$;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCode$;
import akka.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import akka.http.scaladsl.settings.ParserSettings;
import akka.stream.Attributes;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.Serializable;
import javax.net.ssl.SSLSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

@InternalApi
public final class ResponseParsing$ {
    public static final ResponseParsing$ MODULE$ = new ResponseParsing$();

    public Function1<Http2SubStream, HttpResponse> parseResponse(HttpHeaderParser httpHeaderParser, ParserSettings settings, Attributes attributes) {
        return (Function1 & Serializable)subStream -> {
            None$ tlsSessionInfoHeader = settings.includeTlsSessionInfoHeader() ? attributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable)sslSessionInfo -> new Tls$minusSession$minusInfo(sslSessionInfo.session())) : None$.MODULE$;
            None$ sslSessionAttribute = settings.includeSslSessionAttribute() ? attributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable)x$1 -> x$1.session()) : None$.MODULE$;
            return this.rec$1((Seq)subStream.initialHeaders().keyValuePairs(), ResponseParsing$.rec$default$2$1(), ResponseParsing$.rec$default$3$1(), ResponseParsing$.rec$default$4$1(), ResponseParsing$.rec$default$5$1(), ResponseParsing$.rec$default$6$1(), (Http2SubStream)subStream, (Option)tlsSessionInfoHeader, (Option)sslSessionAttribute, httpHeaderParser);
        };
    }

    private final HttpResponse rec$1(Seq remainingHeaders, StatusCode status, ContentType contentType, long contentLength, boolean seenRegularHeader, VectorBuilder headers2, Http2SubStream subStream$1, Option tlsSessionInfoHeader$1, Option sslSessionAttribute$1, HttpHeaderParser httpHeaderParser$1) {
        HttpMessage httpMessage;
        block14: {
            Tuple2 tuple2;
            while (true) {
                String name;
                if (remainingHeaders.isEmpty()) {
                    RequestParsing$.MODULE$.checkRequiredPseudoHeader(":status", status);
                    RequestEntity entity = subStream$1.createEntity(contentLength, contentType);
                    Object object = tlsSessionInfoHeader$1.isDefined() ? headers2.$plus$eq(tlsSessionInfoHeader$1.get()) : BoxedUnit.UNIT;
                    HttpMessage response = HttpResponse$.MODULE$.apply(status, (Seq<HttpHeader>)headers2.result(), entity, HttpProtocols$.MODULE$.HTTP$div2$u002E0()).withAttributes((Map)subStream$1.correlationAttributes());
                    Option option = sslSessionAttribute$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        SSLSession sslSession = (SSLSession)some.value();
                        httpMessage = (HttpResponse)((HttpResponse)response).addAttribute((AttributeKey)AttributeKeys$.MODULE$.sslSession(), SslSessionInfo$.MODULE$.apply(sslSession));
                        break block14;
                    }
                    if (None$.MODULE$.equals(option)) {
                        httpMessage = response;
                        break block14;
                    }
                    throw new MatchError((Object)option);
                }
                tuple2 = (Tuple2)remainingHeaders.head();
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String statusCodeValue = (String)tuple2._2();
                    if (":status".equals(string)) {
                        RequestParsing$.MODULE$.checkUniquePseudoHeader(":status", status);
                        RequestParsing$.MODULE$.checkNoRegularHeadersBeforePseudoHeader(":status", seenRegularHeader);
                        status = StatusCode$.MODULE$.int2StatusCode(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(statusCodeValue)));
                        remainingHeaders = (Seq)remainingHeaders.tail();
                        continue;
                    }
                }
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String ct = (String)tuple2._2();
                    if ("content-type".equals(string)) {
                        if (OptionVal$.MODULE$.isEmpty$extension((Object)contentType)) {
                            ContentType contentTypeValue = (ContentType)ContentType$.MODULE$.parse(ct).right().getOrElse((Function0 & Serializable)() -> RequestParsing$.MODULE$.malformedRequest(new StringBuilder(24).append("Invalid content-type: '").append(ct).append("'").toString()));
                            contentType = (ContentType)OptionVal.Some$.MODULE$.apply((Object)contentTypeValue);
                            remainingHeaders = (Seq)remainingHeaders.tail();
                            continue;
                        }
                        throw RequestParsing$.MODULE$.malformedRequest("HTTP message must not contain more than one content-type header");
                    }
                }
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String length = (String)tuple2._2();
                    if ("content-length".equals(string)) {
                        if (contentLength == -1L) {
                            long contentLengthValue = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(length));
                            if (contentLengthValue < 0L) {
                                throw RequestParsing$.MODULE$.malformedRequest("HTTP message must not contain a negative content-length header");
                            }
                            contentLength = contentLengthValue;
                            remainingHeaders = (Seq)remainingHeaders.tail();
                            continue;
                        }
                        throw RequestParsing$.MODULE$.malformedRequest("HTTP message must not contain more than one content-length header");
                    }
                }
                if (tuple2 != null && (name = (String)tuple2._1()).startsWith(":")) {
                    throw RequestParsing$.MODULE$.malformedRequest(new StringBuilder(39).append("Unexpected pseudo-header '").append(name).append("' in response").toString());
                }
                if (tuple2 == null) break;
                String name2 = (String)tuple2._1();
                String value = (String)tuple2._2();
                HttpHeader httpHeader = RequestParsing$.MODULE$.parseHeaderPair(httpHeaderParser$1, name2, value);
                RequestParsing$.MODULE$.validateHeader(httpHeader);
                headers2 = (VectorBuilder)headers2.$plus$eq((Object)httpHeader);
                seenRegularHeader = true;
                remainingHeaders = (Seq)remainingHeaders.tail();
            }
            throw new MatchError((Object)tuple2);
        }
        return httpMessage;
    }

    private static final StatusCode rec$default$2$1() {
        return null;
    }

    private static final ContentType rec$default$3$1() {
        OptionVal$.MODULE$.None();
        return null;
    }

    private static final long rec$default$4$1() {
        return -1L;
    }

    private static final boolean rec$default$5$1() {
        return false;
    }

    private static final VectorBuilder rec$default$6$1() {
        return new VectorBuilder();
    }

    private ResponseParsing$() {
    }
}

