/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.ConfigurationException;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props$;
import akka.actor.RootActorPath;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster$;
import akka.cluster.Cluster$ClusterLogger$;
import akka.cluster.ClusterActorRefProvider;
import akka.cluster.ClusterDaemon;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterJmx;
import akka.cluster.ClusterReadView;
import akka.cluster.ClusterSettings;
import akka.cluster.ClusterUserAction;
import akka.cluster.DowningProvider;
import akka.cluster.DowningProvider$;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GetClusterCoreRef$;
import akka.cluster.JoinConfigCompatChecker;
import akka.cluster.JoinConfigCompatChecker$;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.dispatch.MonitorableThreadFactory;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.japi.Util$;
import akka.pattern.AskableActorRef$;
import akka.remote.AddressUidExtension;
import akka.remote.AddressUidExtension$;
import akka.remote.DefaultFailureDetectorRegistry;
import akka.remote.FailureDetectorLoader$;
import akka.remote.FailureDetectorRegistry;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0011Ut!B/_\u0011\u0003\u0019g!B3_\u0011\u00031\u0007B\u0002@\u0002\t\u0003!\t\u0006C\u0004\u0005T\u0005!\t\u0005\"\u0016\t\u000f\u0011M\u0013\u0001\"\u0011\u0005`!9A\u0011N\u0001\u0005B\u0011E\u0003b\u0002C6\u0003\u0011\u0005CQ\u000e\u0005\u000b\tc\n!\u0019!C\u0003=\n=\u0001\u0002\u0003C:\u0003\u0001\u0006iA!\u0005\u0007\t\u0015t\u0006\u0001\u001e\u0005\tq&\u0011)\u0019!C\u0001s\"AQ0\u0003B\u0001B\u0003%!\u0010C\u0003\u007f\u0013\u0011\u0005q\u0010C\u0005\u0002\u0004%\u0011\r\u0011\"\u0001\u0002\u0006!A\u0011QB\u0005!\u0002\u0013\t9\u0001C\u0005\u0002\u0010%\u0011\r\u0011\"\u0003\u0002\u0012!A\u0011\u0011D\u0005!\u0002\u0013\t\u0019\u0002C\u0005\u0002\u001c%\u0011\r\u0011\"\u0001\u0002\u001e!A\u0011QE\u0005!\u0002\u0013\ty\u0002C\u0004\u0002(%!\t!!\u000b\t\u000f\u0005E\u0012\u0002\"\u0001\u00024!9\u0011\u0011K\u0005\u0005\u0002\u0005M\u0003bBA6\u0013\u0011\u0005\u0011Q\u000e\u0005\n\u0003{J!\u0019!C\u0005\u0003\u007fB\u0001\"!%\nA\u0003%\u0011\u0011\u0011\u0005\n\u0003'K!\u0019!C\u0005\u0003+C\u0001\"a)\nA\u0003%\u0011q\u0013\u0005\n\u0003KK\u0001\u0019!C\u0005\u0003OC\u0011\"!.\n\u0001\u0004%I!a.\t\u0011\u0005\r\u0017\u0002)Q\u0005\u0003SC\u0011\"!2\n\u0005\u0004%\t!a2\t\u0011\u0005U\u0017\u0002)A\u0005\u0003\u0013D\u0011\"a6\n\u0005\u0004%\t!a2\t\u0011\u0005e\u0017\u0002)A\u0005\u0003\u0013D!\"a7\n\u0011\u000b\u0007I\u0011AAo\u0011)\t)/\u0003b\u0001\n\u0003q\u0016q\u001d\u0005\t\u0003_L\u0001\u0015!\u0003\u0002j\"I\u0011\u0011_\u0005C\u0002\u0013%\u00111\u001f\u0005\t\u0003wL\u0001\u0015!\u0003\u0002v\"Q\u0011Q`\u0005C\u0002\u0013\u0005a,a=\t\u0011\u0005}\u0018\u0002)A\u0005\u0003kD!B!\u0001\n\u0005\u0004%\tA\u0018B\u0002\u0011!\u0011Y!\u0003Q\u0001\n\t\u0015\u0001b\u0002B\u0007\u0013\u0011\u0005!q\u0002\u0005\b\u0005/IA\u0011\u0001B\r\u0011\u001d\u0011I#\u0003C\u0001\u0005WAqAa\r\n\t\u0003\u0011)\u0004C\u0004\u00034%!\tA!\u001d\t\u000f\t=\u0015\u0002\"\u0001\u0003\u0012\"9!qR\u0005\u0005\u0002\tU\u0005b\u0002BS\u0013\u0011\u0005!q\u0015\u0005\b\u0005[KA\u0011\u0001BX\u0011\u001d\u0011),\u0003C\u0005\u0005oCqAa/\n\t\u0003\u0011i\fC\u0004\u0003<&!\tAa5\t\u000f\tu\u0017\u0002\"\u0001\u0003`\"9!1]\u0005\u0005\u0002\t\u0015\bb\u0002Bu\u0013\u0011\u0005!1\u001e\u0005\b\u0005SLA\u0011\u0001B\u0000\u0011\u001d\u0019\t\"\u0003C\u0001\u0007'Aqa!\u0005\n\t\u0003\u0019y\u0002C\u0004\u0004$%!\ta!\n\t\u0011\rE\u0012\u0002\"\u0001_\u0007gAqa!\u0011\n\t\u0013\u0019\u0019d\u0002\u0005\u0004D%A\tAXB#\r!\u0019I%\u0003E\u0001=\u000e-\u0003B\u0002@B\t\u0003\u0019i\u0005C\u0004\u0004P\u0005#\tAa\u0004\t\u000f\rE\u0013\t\"\u0001\u0004T!91\u0011K!\u0005\u0002\re\u0003bBB)\u0003\u0012\u000511\r\u0005\b\u0007#\nE\u0011AB7\u0011\u001d\u0019I(\u0011C\u0001\u0007wBqa!\u001fB\t\u0003\u0019y\bC\u0004\u0004z\u0005#\ta!\"\t\u000f\re\u0014\t\"\u0001\u0004\u000e\"91qS!\u0005\u0002\re\u0005bBBL\u0003\u0012\u00051Q\u0014\u0005\b\u0007/\u000bE\u0011ABR\u0011\u001d\u00199*\u0011C\u0001\u0007WCqa!.B\t\u0003\u00199\fC\u0004\u00046\u0006#\taa/\t\u000f\rU\u0016\t\"\u0001\u0004B\"91QW!\u0005\u0002\r%\u0007bBB[\u0003\u0012\u000511\u001b\u0005\b\u0007k\u000bE\u0011ABw\u0011\u001d\u0019),\u0011C\u0001\u0007kDqa!.B\t\u0003\u0019y\u0010C\u0004\u0005\f\u0005#I\u0001\"\u0004\t\u000f\u0011-\u0011\t\"\u0003\u0005(!9A1B!\u0005\n\u0011=\u0002b\u0002C\u0006\u0003\u0012%A\u0011\b\u0005\b\t\u000b\nE\u0011\u0002C$\u0003\u001d\u0019E.^:uKJT!a\u00181\u0002\u000f\rdWo\u001d;fe*\t\u0011-\u0001\u0003bW.\f7\u0001\u0001\t\u0003I\u0006i\u0011A\u0018\u0002\b\u00072,8\u000f^3s'\u0015\tq-\u001cC&!\tA7.D\u0001j\u0015\u0005Q\u0017!B:dC2\f\u0017B\u00017j\u0005\u0019\te.\u001f*fMB\u0019a.]:\u000e\u0003=T!\u0001\u001d1\u0002\u000b\u0005\u001cGo\u001c:\n\u0005I|'aC#yi\u0016t7/[8o\u0013\u0012\u0004\"\u0001Z\u0005\u0014\u0007%9W\u000f\u0005\u0002om&\u0011qo\u001c\u0002\n\u000bb$XM\\:j_:\faa]=ti\u0016lW#\u0001>\u0011\u00059\\\u0018B\u0001?p\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\na\u0001P5oSRtDcA:\u0002\u0002!)\u0001\u0010\u0004a\u0001u\u0006A1/\u001a;uS:<7/\u0006\u0002\u0002\bA\u0019A-!\u0003\n\u0007\u0005-aLA\bDYV\u001cH/\u001a:TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%A\fk_&t7i\u001c8gS\u001e\u001cu.\u001c9bi\u000eCWmY6feV\u0011\u00111\u0003\t\u0004I\u0006U\u0011bAA\f=\n9\"j\\5o\u0007>tg-[4D_6\u0004\u0018\r^\"iK\u000e\\WM]\u0001\u0019U>LgnQ8oM&<7i\\7qCR\u001c\u0005.Z2lKJ\u0004\u0013!E:fY\u001a,f.[9vK\u0006#GM]3tgV\u0011\u0011q\u0004\t\u0004I\u0006\u0005\u0012bAA\u0012=\niQK\\5rk\u0016\fE\r\u001a:fgN\f!c]3mMVs\u0017.];f\u0003\u0012$'/Z:tA\u0005Y1/\u001a7g\u0003\u0012$'/Z:t+\t\tY\u0003E\u0002o\u0003[I1!a\fp\u0005\u001d\tE\r\u001a:fgN\fab]3mM\u0012\u000bG/Y\"f]R,'/\u0006\u0002\u00026A!\u0011qGA&\u001d\u0011\tI$a\u0012\u000f\t\u0005m\u0012Q\t\b\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t2\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0017BA0a\u0013\r\tIEX\u0001\u0010\u00072,8\u000f^3s'\u0016$H/\u001b8hg&!\u0011QJA(\u0005)!\u0015\r^1DK:$XM\u001d\u0006\u0004\u0003\u0013r\u0016!C:fY\u001a\u0014v\u000e\\3t+\t\t)\u0006\u0005\u0004\u0002X\u0005}\u0013Q\r\b\u0005\u00033\nY\u0006E\u0002\u0002>%L1!!\u0018j\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011MA2\u0005\r\u0019V\r\u001e\u0006\u0004\u0003;J\u0007\u0003BA,\u0003OJA!!\u001b\u0002d\t11\u000b\u001e:j]\u001e\fAbZ3u'\u0016dgMU8mKN,\"!a\u001c\u0011\r\u0005E\u00141PA3\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014\u0001B;uS2T!!!\u001f\u0002\t)\fg/Y\u0005\u0005\u0003C\n\u0019(A\u0007`SN$VM]7j]\u0006$X\rZ\u000b\u0003\u0003\u0003\u0003B!a!\u0002\u000e6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003\u0017\u000b\u0019(\u0001\u0006d_:\u001cWO\u001d:f]RLA!a$\u0002\u0006\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\fabX5t)\u0016\u0014X.\u001b8bi\u0016$\u0007%A\u0002m_\u001e,\"!a&\u0011\t\u0005e\u0015qT\u0007\u0003\u00037S1!!(a\u0003\u0015)g/\u001a8u\u0013\u0011\t\t+a'\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006!An\\4!\u0003)\u0019G.^:uKJTU\u000e_\u000b\u0003\u0003S\u0003R\u0001[AV\u0003_K1!!,j\u0005\u0019y\u0005\u000f^5p]B\u0019A-!-\n\u0007\u0005MfL\u0001\u0006DYV\u001cH/\u001a:K[b\fab\u00197vgR,'OS7y?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0006}\u0006c\u00015\u0002<&\u0019\u0011QX5\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0003d\u0012\u0011!a\u0001\u0003S\u000b1\u0001\u001f\u00132\u0003-\u0019G.^:uKJTU\u000e\u001f\u0011\u0002\u001f\u0019\f\u0017\u000e\\;sK\u0012+G/Z2u_J,\"!!3\u0011\r\u0005-\u0017\u0011[A\u0016\u001b\t\tiMC\u0002\u0002P\u0002\faA]3n_R,\u0017\u0002BAj\u0003\u001b\u0014qCR1jYV\u0014X\rR3uK\u000e$xN\u001d*fO&\u001cHO]=\u0002!\u0019\f\u0017\u000e\\;sK\u0012+G/Z2u_J\u0004\u0013AF2s_N\u001cHi\u0019$bS2,(/\u001a#fi\u0016\u001cGo\u001c:\u0002/\r\u0014xn]:EG\u001a\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\u0004\u0013a\u00043po:Lgn\u001a)s_ZLG-\u001a:\u0016\u0005\u0005}\u0007c\u00013\u0002b&\u0019\u00111\u001d0\u0003\u001f\u0011{wO\\5oOB\u0013xN^5eKJ\f\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\u0005%\bc\u00018\u0002l&\u0019\u0011Q^8\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005q1\r\\;ti\u0016\u0014H)Y3n_:\u001cXCAA{!\rq\u0017q_\u0005\u0004\u0003s|'\u0001C!di>\u0014(+\u001a4\u0002\u001f\rdWo\u001d;fe\u0012\u000bW-\\8og\u0002\n1b\u00197vgR,'oQ8sK\u0006a1\r\\;ti\u0016\u00148i\u001c:fA\u0005A!/Z1e-&,w/\u0006\u0002\u0003\u0006A\u0019AMa\u0002\n\u0007\t%aLA\bDYV\u001cH/\u001a:SK\u0006$g+[3x\u0003%\u0011X-\u00193WS\u0016<\b%\u0001\u0007jgR+'/\\5oCR,G-\u0006\u0002\u0003\u0012A\u0019\u0001Na\u0005\n\u0007\tU\u0011NA\u0004C_>dW-\u00198\u0002\u000bM$\u0018\r^3\u0016\u0005\tm\u0001\u0003\u0002B\u000f\u0005Gq1\u0001\u001aB\u0010\u0013\r\u0011\tCX\u0001\r\u00072,8\u000f^3s\u000bZ,g\u000e^\u0005\u0005\u0005K\u00119CA\nDkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$XMC\u0002\u0003\"y\u000b!b]3mM6+WNY3s+\t\u0011i\u0003E\u0002e\u0005_I1A!\r_\u0005\u0019iU-\u001c2fe\u0006I1/\u001e2tGJL'-\u001a\u000b\u0007\u0003s\u00139Da\u000f\t\u000f\teb\u00061\u0001\u0002v\u0006Q1/\u001e2tGJL'-\u001a:\t\u000f\tub\u00061\u0001\u0003@\u0005\u0011Ao\u001c\t\u0006Q\n\u0005#QI\u0005\u0004\u0005\u0007J'A\u0003\u001fsKB,\u0017\r^3e}A\"!q\tB)!\u0019\t9F!\u0013\u0003N%!!1JA2\u0005\u0015\u0019E.Y:t!\u0011\u0011yE!\u0015\r\u0001\u0011a!1\u000bB\u001e\u0003\u0003\u0005\tQ!\u0001\u0003V\t\u0019q\fJ\u0019\u0012\t\t]#Q\f\t\u0004Q\ne\u0013b\u0001B.S\n9aj\u001c;iS:<\u0007c\u00015\u0003`%\u0019!\u0011M5\u0003\u0007\u0005s\u0017\u0010K\u0002/\u0005K\u0002BAa\u001a\u0003n5\u0011!\u0011\u000e\u0006\u0004\u0005WJ\u0017AC1o]>$\u0018\r^5p]&!!q\u000eB5\u0005\u001d1\u0018M]1sON$\u0002\"!/\u0003t\tU$q\u0010\u0005\b\u0005sy\u0003\u0019AA{\u0011\u001d\u00119h\fa\u0001\u0005s\n\u0001#\u001b8ji&\fGn\u0015;bi\u0016lu\u000eZ3\u0011\t\tu!1P\u0005\u0005\u0005{\u00129C\u0001\u000fTk\n\u001c8M]5qi&|g.\u00138ji&\fGn\u0015;bi\u0016lu\u000eZ3\t\u000f\tur\u00061\u0001\u0003\u0002B)\u0001N!\u0011\u0003\u0004B\"!Q\u0011BE!\u0019\t9F!\u0013\u0003\bB!!q\nBE\t1\u0011YIa \u0002\u0002\u0003\u0005)\u0011\u0001B+\u0005\ryFE\r\u0015\u0004_\t\u0015\u0014aC;ogV\u00147o\u0019:jE\u0016$B!!/\u0003\u0014\"9!\u0011\b\u0019A\u0002\u0005UHCBA]\u0005/\u0013I\nC\u0004\u0003:E\u0002\r!!>\t\u000f\tu\u0012\u00071\u0001\u0003\u001cB\"!Q\u0014BQ!\u0019\t9F!\u0013\u0003 B!!q\nBQ\t1\u0011\u0019K!'\u0002\u0002\u0003\u0005)\u0011\u0001B+\u0005\ryFeM\u0001\u0018g\u0016tGmQ;se\u0016tGo\u00117vgR,'o\u0015;bi\u0016$B!!/\u0003*\"9!1\u0016\u001aA\u0002\u0005U\u0018\u0001\u0003:fG\u0016Lg/\u001a:\u0002\t)|\u0017N\u001c\u000b\u0005\u0003s\u0013\t\fC\u0004\u00034N\u0002\r!a\u000b\u0002\u000f\u0005$GM]3tg\u0006Ia-\u001b7m\u0019>\u001c\u0017\r\u001c\u000b\u0005\u0003W\u0011I\fC\u0004\u00034R\u0002\r!a\u000b\u0002\u001b)|\u0017N\\*fK\u0012tu\u000eZ3t)\u0011\tILa0\t\u000f\t\u0005W\u00071\u0001\u0003D\u0006I1/Z3e\u001d>$Wm\u001d\t\u0007\u0005\u000b\u0014y-a\u000b\u000e\u0005\t\u001d'\u0002\u0002Be\u0005\u0017\f\u0011\"[7nkR\f'\r\\3\u000b\u0007\t5\u0017.\u0001\u0006d_2dWm\u0019;j_:LAA!5\u0003H\n\u00191+Z9\u0015\t\u0005e&Q\u001b\u0005\b\u0005\u00034\u0004\u0019\u0001Bl!\u0019\t\tH!7\u0002,%!!1\\A:\u0005\u0011a\u0015n\u001d;\u0002\u000b1,\u0017M^3\u0015\t\u0005e&\u0011\u001d\u0005\b\u0005g;\u0004\u0019AA\u0016\u0003\u0011!wn\u001e8\u0015\t\u0005e&q\u001d\u0005\b\u0005gC\u0004\u0019AA\u0016\u0003I\u0011XmZ5ti\u0016\u0014xJ\\'f[\n,'/\u00169\u0016\t\t5(1 \u000b\u0005\u0003s\u0013y\u000f\u0003\u0005\u0003rf\"\t\u0019\u0001Bz\u0003\u0011\u0019w\u000eZ3\u0011\u000b!\u0014)P!?\n\u0007\t]\u0018N\u0001\u0005=Eft\u0017-\\3?!\u0011\u0011yEa?\u0005\u000f\tu\u0018H1\u0001\u0003V\t\tA\u000b\u0006\u0003\u0002:\u000e\u0005\u0001bBB\u0002u\u0001\u00071QA\u0001\tG\u0006dGNY1dWB!1qAB\u0007\u001b\t\u0019IA\u0003\u0003\u0004\f\u0005]\u0014\u0001\u00027b]\u001eLAaa\u0004\u0004\n\tA!+\u001e8oC\ndW-A\fsK\u001eL7\u000f^3s\u001f:lU-\u001c2feJ+Wn\u001c<fIV!1QCB\u000f)\u0011\tIla\u0006\t\u0011\tE8\b\"a\u0001\u00073\u0001R\u0001\u001bB{\u00077\u0001BAa\u0014\u0004\u001e\u00119!Q`\u001eC\u0002\tUC\u0003BA]\u0007CAqaa\u0001=\u0001\u0004\u0019)!\u0001\u0007sK6|G/\u001a)bi\"|e\r\u0006\u0003\u0004(\r5\u0002c\u00018\u0004*%\u001911F8\u0003\u0013\u0005\u001bGo\u001c:QCRD\u0007bBB\u0018{\u0001\u0007\u0011Q_\u0001\tC\u000e$xN\u001d*fM\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002:\"\u001aaha\u000e\u0011\t\re2QH\u0007\u0003\u0007wQ1Aa\u001ba\u0013\u0011\u0019yda\u000f\u0003\u0017%sG/\u001a:oC2\f\u0005/[\u0001\u000fG2|7/Z*dQ\u0016$W\u000f\\3s\u00035\u0019E.^:uKJdunZ4feB\u00191qI!\u000e\u0003%\u0011Qb\u00117vgR,'\u000fT8hO\u0016\u00148CA!h)\t\u0019)%\u0001\bjg\u0012+'-^4F]\u0006\u0014G.\u001a3\u0002\u00111|w\rR3ck\u001e$B!!/\u0004V!91q\u000b#A\u0002\u0005\u0015\u0014aB7fgN\fw-\u001a\u000b\u0007\u0003s\u001bYfa\u0018\t\u000f\ruS\t1\u0001\u0002f\u0005AA/Z7qY\u0006$X\rC\u0004\u0004b\u0015\u0003\rA!\u0018\u0002\t\u0005\u0014x-\r\u000b\t\u0003s\u001b)ga\u001a\u0004j!91Q\f$A\u0002\u0005\u0015\u0004bBB1\r\u0002\u0007!Q\f\u0005\b\u0007W2\u0005\u0019\u0001B/\u0003\u0011\t'o\u001a\u001a\u0015\u0015\u0005e6qNB9\u0007g\u001a)\bC\u0004\u0004^\u001d\u0003\r!!\u001a\t\u000f\r\u0005t\t1\u0001\u0003^!911N$A\u0002\tu\u0003bBB<\u000f\u0002\u0007!QL\u0001\u0005CJ<7'A\u0004m_\u001eLeNZ8\u0015\t\u0005e6Q\u0010\u0005\b\u0007/B\u0005\u0019AA3)\u0019\tIl!!\u0004\u0004\"91QL%A\u0002\u0005\u0015\u0004bBB1\u0013\u0002\u0007!Q\f\u000b\t\u0003s\u001b9i!#\u0004\f\"91Q\f&A\u0002\u0005\u0015\u0004bBB1\u0015\u0002\u0007!Q\f\u0005\b\u0007WR\u0005\u0019\u0001B/))\tIla$\u0004\u0012\u000eM5Q\u0013\u0005\b\u0007;Z\u0005\u0019AA3\u0011\u001d\u0019\tg\u0013a\u0001\u0005;Bqaa\u001bL\u0001\u0004\u0011i\u0006C\u0004\u0004x-\u0003\rA!\u0018\u0002\u00151|wmV1s]&tw\r\u0006\u0003\u0002:\u000em\u0005bBB,\u0019\u0002\u0007\u0011Q\r\u000b\u0007\u0003s\u001byj!)\t\u000f\ruS\n1\u0001\u0002f!91\u0011M'A\u0002\tuC\u0003CA]\u0007K\u001b9k!+\t\u000f\ruc\n1\u0001\u0002f!91\u0011\r(A\u0002\tu\u0003bBB6\u001d\u0002\u0007!Q\f\u000b\u000b\u0003s\u001bika,\u00042\u000eM\u0006bBB/\u001f\u0002\u0007\u0011Q\r\u0005\b\u0007Cz\u0005\u0019\u0001B/\u0011\u001d\u0019Yg\u0014a\u0001\u0005;Bqaa\u001eP\u0001\u0004\u0011i&\u0001\u0005m_\u001e,%O]8s)\u0011\tIl!/\t\u000f\r]\u0003\u000b1\u0001\u0002fQ1\u0011\u0011XB_\u0007\u007fCqa!\u0018R\u0001\u0004\t)\u0007C\u0004\u0004bE\u0003\rA!\u0018\u0015\u0011\u0005e61YBc\u0007\u000fDqa!\u0018S\u0001\u0004\t)\u0007C\u0004\u0004bI\u0003\rA!\u0018\t\u000f\r-$\u000b1\u0001\u0003^QQ\u0011\u0011XBf\u0007\u001b\u001cym!5\t\u000f\ru3\u000b1\u0001\u0002f!91\u0011M*A\u0002\tu\u0003bBB6'\u0002\u0007!Q\f\u0005\b\u0007o\u001a\u0006\u0019\u0001B/)\u0019\tIl!6\u0004l\"91q\u001b+A\u0002\re\u0017!B2bkN,\u0007\u0003BBn\u0007KtAa!8\u0004b:!\u0011QHBp\u0013\u0005Q\u0017bABrS\u00069\u0001/Y2lC\u001e,\u0017\u0002BBt\u0007S\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\r\r\u0018\u000eC\u0004\u0004XQ\u0003\r!!\u001a\u0015\u0011\u0005e6q^By\u0007gDqaa6V\u0001\u0004\u0019I\u000eC\u0004\u0004^U\u0003\r!!\u001a\t\u000f\r\u0005T\u000b1\u0001\u0003^QQ\u0011\u0011XB|\u0007s\u001cYp!@\t\u000f\r]g\u000b1\u0001\u0004Z\"91Q\f,A\u0002\u0005\u0015\u0004bBB1-\u0002\u0007!Q\f\u0005\b\u0007W2\u0006\u0019\u0001B/)1\tI\f\"\u0001\u0005\u0004\u0011\u0015Aq\u0001C\u0005\u0011\u001d\u00199n\u0016a\u0001\u00073Dqa!\u0018X\u0001\u0004\t)\u0007C\u0004\u0004b]\u0003\rA!\u0018\t\u000f\r-t\u000b1\u0001\u0003^!91qO,A\u0002\tu\u0013A\u00037pO\u0006#H*\u001a<fYR1\u0011\u0011\u0018C\b\tKAq\u0001\"\u0005Y\u0001\u0004!\u0019\"\u0001\u0005m_\u001edUM^3m!\u0011!)\u0002b\b\u000f\t\u0011]A1\u0004\b\u0005\u0003w!I\"C\u0002\u0002\u001e\u0002LA\u0001\"\b\u0002\u001c\u00069Aj\\4hS:<\u0017\u0002\u0002C\u0011\tG\u0011\u0001\u0002T8h\u0019\u00164X\r\u001c\u0006\u0005\t;\tY\nC\u0004\u0004Xa\u0003\r!!\u001a\u0015\u0011\u0005eF\u0011\u0006C\u0016\t[Aq\u0001\"\u0005Z\u0001\u0004!\u0019\u0002C\u0004\u0004^e\u0003\r!!\u001a\t\u000f\r\u0005\u0014\f1\u0001\u0003^QQ\u0011\u0011\u0018C\u0019\tg!)\u0004b\u000e\t\u000f\u0011E!\f1\u0001\u0005\u0014!91Q\f.A\u0002\u0005\u0015\u0004bBB15\u0002\u0007!Q\f\u0005\b\u0007WR\u0006\u0019\u0001B/)1\tI\fb\u000f\u0005>\u0011}B\u0011\tC\"\u0011\u001d!\tb\u0017a\u0001\t'Aqa!\u0018\\\u0001\u0004\t)\u0007C\u0004\u0004bm\u0003\rA!\u0018\t\u000f\r-4\f1\u0001\u0003^!91qO.A\u0002\tu\u0013AD5t\u0019\u00164X\r\\#oC\ndW\r\u001a\u000b\u0005\u0005#!I\u0005C\u0004\u0005\u0012q\u0003\r\u0001b\u0005\u0011\u00079$i%C\u0002\u0005P=\u00141#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012aY\u0001\u0004O\u0016$HcA:\u0005X!1\u0001p\u0001a\u0001\t3\u00022A\u001cC.\u0013\r!if\u001c\u0002\f\u0003\u000e$xN]*zgR,W\u000eF\u0002t\tCBa\u0001\u001f\u0003A\u0002\u0011\r\u0004c\u00018\u0005f%\u0019AqM8\u00035\rc\u0017m]:jG\u0006\u001bGo\u001c:TsN$X-\u001c)s_ZLG-\u001a:\u0002\r1|wn[;q\u0003=\u0019'/Z1uK\u0016CH/\u001a8tS>tGcA:\u0005p!)\u0001P\u0002a\u0001u\u0006I\u0012n]!tg\u0016\u0014H/\u00138wCJL\u0017M\u001c;t\u000b:\f'\r\\3e\u0003iI7/Q:tKJ$\u0018J\u001c<be&\fg\u000e^:F]\u0006\u0014G.\u001a3!\u0001")
public class Cluster
implements Extension {
    private DowningProvider downingProvider;
    private volatile Cluster$ClusterLogger$ ClusterLogger$module;
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final LoggingAdapter akka$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile boolean bitmap$0;

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public static Cluster get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Cluster$.MODULE$.get(classicActorSystemProvider);
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Cluster$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public Cluster$ClusterLogger$ ClusterLogger() {
        if (this.ClusterLogger$module == null) {
            this.ClusterLogger$lzycompute$1();
        }
        return this.ClusterLogger$module;
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    private JoinConfigCompatChecker joinConfigCompatChecker() {
        return this.joinConfigCompatChecker;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public String selfDataCenter() {
        return this.settings().SelfDataCenter();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public LoggingAdapter akka$cluster$Cluster$$log() {
        return this.akka$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    private DowningProvider downingProvider$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (!this.bitmap$0) {
                this.downingProvider = DowningProvider$.MODULE$.load(this.settings().DowningProviderClassName(), (ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.downingProvider;
    }

    public DowningProvider downingProvider() {
        return !this.bitmap$0 ? this.downingProvider$lzycompute() : this.downingProvider;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public Member selfMember() {
        return this.readView().self();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        this.subscribe(subscriber, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsSnapshot$.MODULE$, to);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        Predef$.MODULE$.require(to.length() > 0, (Function0 & Serializable)() -> "at least one `ClusterDomainEvent` class is required");
        Predef$.MODULE$.require(to.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Cluster.$anonfun$subscribe$2(x$1))), (Function0 & Serializable)() -> new StringBuilder(81).append("subscribe to `akka.cluster.ClusterEvent.ClusterDomainEvent` or subclasses, was [").append(((IterableOnceOps)to.map((Function1 & Serializable)x$1 -> x$1.getName())).mkString(", ")).append("]").toString());
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$12 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$12);
        qual$1.$bang((Object)x$12, x$2);
    }

    public void unsubscribe(ActorRef subscriber) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$1 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$1 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.SendCurrentClusterState x$1 = new InternalClusterAction.SendCurrentClusterState(receiver);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void join(Address address) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.JoinTo x$1 = new ClusterUserAction.JoinTo(this.fillLocal(address));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Address fillLocal(Address address) {
        Address address2;
        if (address.hasLocalScope()) {
            String string = address.system();
            String string2 = this.selfAddress().system();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                address2 = this.selfAddress();
                return address2;
            }
        }
        address2 = address;
        return address2;
    }

    public void joinSeedNodes(Seq<Address> seedNodes) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.JoinSeedNodes x$1 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)((IndexedSeq)seedNodes.toVector().map((Function1 & Serializable)address -> this.fillLocal((Address)address))));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void joinSeedNodes(List<Address> seedNodes) {
        this.joinSeedNodes((Seq<Address>)Util$.MODULE$.immutableSeq(seedNodes));
    }

    public void leave(Address address) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Leave x$1 = new ClusterUserAction.Leave(this.fillLocal(address));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void down(Address address) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Down x$1 = new ClusterUserAction.Down(this.fillLocal(address));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(null, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
        InternalClusterAction.AddOnMemberUpListener x$1 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public <T> void registerOnMemberRemoved(Function0<T> code) {
        this.registerOnMemberRemoved(new Runnable(null, code){
            private final Function0 code$2;

            public void run() {
                this.code$2.apply();
            }
            {
                this.code$2 = code$2;
            }
        });
    }

    public void registerOnMemberRemoved(Runnable callback) {
        if (this._isTerminated().get()) {
            callback.run();
        } else {
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
            InternalClusterAction.AddOnMemberRemovedListener x$1 = new InternalClusterAction.AddOnMemberRemovedListener(callback);
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
    }

    public ActorPath remotePathOf(ActorRef actorRef) {
        ActorPath actorPath;
        ActorPath path = actorRef.path();
        if (path.address().host().isDefined()) {
            actorPath = path;
        } else {
            RootActorPath qual$1 = path.root();
            Address x$1 = this.selfAddress();
            String x$2 = qual$1.copy$default$2();
            actorPath = qual$1.copy(x$1, x$2).$div((Iterable)path.elements()).withUid(path.uid());
        }
        return actorPath;
    }

    @InternalApi
    public void shutdown() {
        block1: {
            if (!this._isTerminated().compareAndSet(false, true)) break block1;
            this.ClusterLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            if (this.readView() != null) {
                this.readView().close();
            }
            this.closeScheduler();
            this.clusterJmx().foreach((Function1 & Serializable)x$2 -> {
                x$2.unregisterMBean();
                return BoxedUnit.UNIT;
            });
            this.ClusterLogger().logInfo("Successfully shut down");
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)scheduler2).close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void ClusterLogger$lzycompute$1() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.ClusterLogger$module == null) {
                this.ClusterLogger$module = new Cluster$ClusterLogger$(this);
            }
        }
    }

    private final ActorRef liftedTree1$1(Timeout timeout$1) {
        ActorRef actorRef;
        try {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.clusterDaemons());
            InternalClusterAction$GetClusterCoreRef$ x$1 = InternalClusterAction$GetClusterCoreRef$.MODULE$;
            Timeout x$2 = timeout$1;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.akka$cluster$Cluster$$log().error(e, "Failed to startup Cluster. You can try to increase 'akka.actor.creation-timeout'.");
            this.shutdown();
            ActorRef actorRef2 = this.system().deadLetters();
            actorRef = actorRef2;
        }
        return actorRef;
    }

    public static final /* synthetic */ boolean $anonfun$subscribe$2(Class x$1) {
        return ClusterEvent.ClusterDomainEvent.class.isAssignableFrom(x$1);
    }

    public Cluster(ExtendedActorSystem system) {
        Scheduler scheduler;
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        this.joinConfigCompatChecker = JoinConfigCompatChecker$.MODULE$.load(system, this.settings());
        ActorRefProvider actorRefProvider = system.provider();
        if (!(actorRefProvider instanceof ClusterActorRefProvider)) {
            throw new ConfigurationException(new StringBuilder(107).append("ActorSystem [").append(system).append("] needs to have 'akka.actor.provider' set to 'cluster' in the configuration, currently uses [").append(actorRefProvider.getClass().getName()).append("]").toString());
        }
        ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
        UniqueAddress uniqueAddress = new UniqueAddress(clusterActorRefProvider.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).longAddressUid());
        this.selfUniqueAddress = uniqueAddress;
        this._isTerminated = new AtomicBoolean(false);
        this.akka$cluster$Cluster$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.clusterJmx = None$.MODULE$;
        this.ClusterLogger().logInfo("Starting up, Akka version [{}] ...", system.settings().ConfigVersion());
        Function0 & Serializable createFailureDetector = (Function0 & Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)this.system());
        this.failureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector);
        Function0 & Serializable createFailureDetector2 = (Function0 & Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().ImplementationClass(), this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().config(), (ActorSystem)this.system());
        this.crossDcFailureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector2);
        package.DurationInt durationInt = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1));
        if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
            ThreadFactory threadFactory;
            this.ClusterLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'akka.scheduler.tick-duration' [{} ms] <=  'akka.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
            Config cfg = ConfigFactory.parseString((String)new StringBuilder(31).append("akka.scheduler.tick-duration=").append(this.settings().SchedulerTickDuration().toMillis()).append("ms").toString()).withFallback((ConfigMergeable)system.settings().config());
            ThreadFactory threadFactory2 = system.threadFactory();
            if (threadFactory2 instanceof MonitorableThreadFactory) {
                MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                threadFactory = monitorableThreadFactory.withName(new StringBuilder(18).append(monitorableThreadFactory.name()).append("-cluster-scheduler").toString());
            } else {
                threadFactory = threadFactory2;
            }
            ThreadFactory threadFactory3 = threadFactory;
            scheduler = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.akka$cluster$Cluster$$log()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)threadFactory3)})), ClassTag$.MODULE$.apply(Scheduler.class)).get();
        } else {
            Scheduler systemScheduler = system.scheduler();
            scheduler = new Scheduler(null, systemScheduler){
                private final Scheduler systemScheduler$1;

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                    return Scheduler.schedule$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, f, (ExecutionContext)executor);
                }

                public Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
                    return Scheduler.scheduleOnce$default$5$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable scheduleOnce(java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (java.time.Duration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, f, (ExecutionContext)executor);
                }

                public Cancellable scheduleOnce(java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (java.time.Duration)delay, (Runnable)runnable, (ExecutionContext)executor);
                }

                public void close() {
                }

                public double maxFrequency() {
                    return this.systemScheduler$1.maxFrequency();
                }

                public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.schedule(initialDelay, interval, runnable, executor);
                }

                public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.scheduleOnce(delay, runnable, executor);
                }
                {
                    this.systemScheduler$1 = systemScheduler$1;
                    Scheduler.$init$((Scheduler)this);
                }
            };
        }
        this.scheduler = scheduler;
        this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.joinConfigCompatChecker()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
        Timeout timeout = system.settings().CreationTimeout();
        this.clusterCore = this.liftedTree1$1(timeout);
        this.readView = new ClusterReadView(this);
        system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> this.shutdown());
        if (this.settings().JmxEnabled()) {
            ClusterJmx jmx = new ClusterJmx(this, this.akka$cluster$Cluster$$log());
            jmx.createMBean();
            this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
        }
        this.ClusterLogger().logInfo("Started up successfully");
    }
}

