/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;

public class OptimalMulticastDelayGenerator
implements FeedbackDelayGenerator {
    private final double calculatedN;
    private final double randMax;
    private final double baseX;
    private final double constantT;
    private final double factorT;

    public OptimalMulticastDelayGenerator(double maxBackoffT, double groupSize, double gRtt) {
        double lambda = Math.log(groupSize) + 1.0;
        this.calculatedN = Math.exp(1.2 * lambda / (2.0 * maxBackoffT / gRtt));
        this.randMax = lambda / maxBackoffT;
        this.baseX = lambda / (maxBackoffT * (Math.exp(lambda) - 1.0));
        this.constantT = maxBackoffT / lambda;
        this.factorT = (Math.exp(lambda) - 1.0) * (maxBackoffT / lambda);
    }

    @Override
    public long generateDelay() {
        return (long)this.generateNewOptimalDelay();
    }

    public double generateNewOptimalDelay() {
        double x = OptimalMulticastDelayGenerator.uniformRandom(this.randMax) + this.baseX;
        return this.constantT * Math.log(x * this.factorT);
    }

    public double calculatedN() {
        return this.calculatedN;
    }

    public static double uniformRandom(double max) {
        return Math.random() * max;
    }
}

