/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.util.HashCode$;
import akka.util.ManifestInfo$;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]u!B\u0015+\u0011\u0003yc!B\u0019+\u0011\u0003\u0011\u0004B\u0002&\u0002\t\u0003\ty\u0005C\u0005\u0002R\u0005\u0011\r\u0011\"\u0003\u0002T!9\u0011QK\u0001!\u0002\u0013Q\b\"CA,\u0003\t\u0007I\u0011BA*\u0011\u001d\tI&\u0001Q\u0001\niD\u0011\"a\u0017\u0002\u0005\u0004%I!a\u0015\t\u000f\u0005u\u0013\u0001)A\u0005u\"I\u0011qL\u0001C\u0002\u0013%\u00111\u000b\u0005\b\u0003C\n\u0001\u0015!\u0003{\u0011%\t\u0019'\u0001b\u0001\n\u0013\t\u0019\u0006C\u0004\u0002f\u0005\u0001\u000b\u0011\u0002>\t\u0013\u0005\u001d\u0014A1A\u0005\n\u0005M\u0003bBA5\u0003\u0001\u0006IA\u001f\u0005\n\u0003W\n!\u0019!C\u0005\u0003[B\u0001\"!\u001e\u0002A\u0003%\u0011q\u000e\u0005\b\u0003o\nA\u0011IA=\u0011\u001d\t9(\u0001C!\u0003\u0007Cq!!$\u0002\t\u0003\ny\tC\u0004\u0002\u0012\u0006!\t%a%\u0007\t}\u000b!\u0001\u0019\u0005\tWV\u0011)\u0019!C\u0001Y\"AQ.\u0006B\u0001B\u0003%!\fC\u0003K+\u0011\u0005a\u000e\u0003\u0006q+A\u0005\t1!Q\u0001\nEDq\u0001`\u000bC\u0002\u0013%Q\u0010\u0003\u0004\u007f+\u0001\u0006I\u0001\u001e\u0005\b\u007fV\u0011\r\u0011\"\u0003m\u0011\u001d\t\t!\u0006Q\u0001\niCq!a\u0001\u0016\t\u0003\n)\u0001C\u0004\u0002\fU!\t%!\u0004\t\u000f\u0005}Q\u0003\"\u0011\u0002\"!9\u00111E\u000b\u0005B\u0005\u0015b\u0001B\u0019+\u0005\u0001C\u0001\u0002\u0012\u0012\u0003\u0006\u0004%\t!\u0012\u0005\t\u0013\n\u0012\t\u0011)A\u0005\r\")!J\tC\u0001\u0017\"9QJ\tb\u0001\n\u0003q\u0005bBA\u0014E\u0001\u0006Ia\u0014\u0005\b\u0003S\u0011C\u0011AA\u0016\u00031i\u0015M\\5gKN$\u0018J\u001c4p\u0015\tYC&\u0001\u0003vi&d'\"A\u0017\u0002\t\u0005\\7.Y\u0002\u0001!\t\u0001\u0014!D\u0001+\u00051i\u0015M\\5gKN$\u0018J\u001c4p'\u0015\t1'OA%!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fMB\u0019!(P \u000e\u0003mR!\u0001\u0010\u0017\u0002\u000b\u0005\u001cGo\u001c:\n\u0005yZ$aC#yi\u0016t7/[8o\u0013\u0012\u0004\"\u0001\r\u0012\u0014\u0007\t\u001a\u0014\t\u0005\u0002;\u0005&\u00111i\u000f\u0002\n\u000bb$XM\\:j_:\faa]=ti\u0016lW#\u0001$\u0011\u0005i:\u0015B\u0001%<\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\na\u0001P5oSRtDCA M\u0011\u0015!U\u00051\u0001G\u0003!1XM]:j_:\u001cX#A(\u0011\tA;&,\u0018\b\u0003#V\u0003\"AU\u001b\u000e\u0003MS!\u0001\u0016\u0018\u0002\rq\u0012xn\u001c;?\u0013\t1V'\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u00131!T1q\u0015\t1V\u0007\u0005\u0002Q7&\u0011A,\u0017\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005y+bB\u0001\u0019\u0001\u0005\u001d1VM]:j_:\u001c2!F\u001ab!\r\u0011w-[\u0007\u0002G*\u0011A-Z\u0001\u0005Y\u0006twMC\u0001g\u0003\u0011Q\u0017M^1\n\u0005!\u001c'AC\"p[B\f'/\u00192mKB\u0011!.F\u0007\u0002\u0003\u00059a/\u001a:tS>tW#\u0001.\u0002\u0011Y,'o]5p]\u0002\"\"![8\t\u000b-D\u0002\u0019\u0001.\u0002\u0007a$\u0013\u0007\u0005\u00035eRT\u0018BA:6\u0005\u0019!V\u000f\u001d7feA\u0019A'^<\n\u0005Y,$!B!se\u0006L\bC\u0001\u001by\u0013\tIXGA\u0002J]R\u0004\"AY>\n\u0005q\u001b\u0017a\u00028v[\n,'o]\u000b\u0002i\u0006Aa.^7cKJ\u001c\b%\u0001\u0003sKN$\u0018!\u0002:fgR\u0004\u0013!C2p[B\f'/\u001a+p)\r9\u0018q\u0001\u0005\u0007\u0003\u0013q\u0002\u0019A5\u0002\u000b=$\b.\u001a:\u0002\r\u0015\fX/\u00197t)\u0011\ty!!\u0006\u0011\u0007Q\n\t\"C\u0002\u0002\u0014U\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0018}\u0001\r!!\u0007\u0002\u0003=\u00042\u0001NA\u000e\u0013\r\ti\"\u000e\u0002\u0004\u0003:L\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003]\f\u0001\u0002^8TiJLgn\u001a\u000b\u00025\u0006Ia/\u001a:tS>t7\u000fI\u0001\u0011G\",7m[*b[\u00164VM]:j_:$\u0002\"a\u0004\u0002.\u0005E\u0012Q\t\u0005\u0007\u0003_A\u0003\u0019\u0001.\u0002\u0017A\u0014x\u000eZ;di:\u000bW.\u001a\u0005\b\u0003gA\u0003\u0019AA\u001b\u00031!W\r]3oI\u0016t7-[3t!\u0015\t9$!\u0011[\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012!C5n[V$\u0018M\u00197f\u0015\r\ty$N\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\"\u0003s\u00111aU3r\u0011\u001d\t9\u0005\u000ba\u0001\u0003\u001f\t!\u0002\\8h/\u0006\u0014h.\u001b8h!\rQ\u00141J\u0005\u0004\u0003\u001bZ$aE#yi\u0016t7/[8o\u0013\u0012\u0004&o\u001c<jI\u0016\u0014H#A\u0018\u0002\u0013%k\u0007\u000f\u001c+ji2,W#\u0001>\u0002\u0015%k\u0007\u000f\u001c+ji2,\u0007%A\u0006J[Bdg+\u001a:tS>t\u0017\u0001D%na24VM]:j_:\u0004\u0013AC%na24VM\u001c3pe\u0006Y\u0011*\u001c9m-\u0016tGm\u001c:!\u0003)\u0011UO\u001c3mK:\u000bW.Z\u0001\f\u0005VtG\r\\3OC6,\u0007%A\u0007Ck:$G.\u001a,feNLwN\\\u0001\u000f\u0005VtG\r\\3WKJ\u001c\u0018n\u001c8!\u00031\u0011UO\u001c3mKZ+g\u000eZ8s\u00035\u0011UO\u001c3mKZ+g\u000eZ8sA\u0005a1N\\8x]Z+g\u000eZ8sgV\u0011\u0011q\u000e\t\u0006\u0003o\t\tH_\u0005\u0005\u0003g\nIDA\u0002TKR\fQb\u001b8po:4VM\u001c3peN\u0004\u0013aA4fiR\u0019q(a\u001f\t\r\u0011\u000b\u0002\u0019AA?!\rQ\u0014qP\u0005\u0004\u0003\u0003[$aC!di>\u00148+_:uK6$2aPAC\u0011\u0019!%\u00031\u0001\u0002\bB\u0019!(!#\n\u0007\u0005-5H\u0001\u000eDY\u0006\u001c8/[2BGR|'oU=ti\u0016l\u0007K]8wS\u0012,'/\u0001\u0004m_>\\W\u000f\u001d\u000b\u0002=\u0006y1M]3bi\u0016,\u0005\u0010^3og&|g\u000eF\u0002@\u0003+CQ\u0001\u0012\u000bA\u0002\u0019\u0003")
public final class ManifestInfo
implements Extension {
    private final ExtendedActorSystem system;
    private final Map<String, Version> versions;

    public static ManifestInfo createExtension(ExtendedActorSystem extendedActorSystem) {
        return ManifestInfo$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ManifestInfo$ lookup() {
        return ManifestInfo$.MODULE$.lookup();
    }

    public static ManifestInfo get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.get(classicActorSystemProvider);
    }

    public static ManifestInfo get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.apply(actorSystem);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Map<String, Version> versions() {
        return this.versions;
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning) {
        boolean bl;
        Map filteredVersions = this.versions().filterKeys((Function1)dependencies.toSet());
        Set values = filteredVersions.values().toSet();
        if (values.size() > 1) {
            if (logWarning) {
                String conflictingVersions = values.mkString(", ");
                String fullInfo = ((TraversableOnce)filteredVersions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    Version v = (Version)tuple2._2();
                    String string = new StringBuilder(1).append(k).append(":").append(v).toString();
                    return string;
                }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
                Version highestVersion = (Version)values.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning(new StringBuilder(279).append("Detected possible incompatible versions on the classpath. ").append(new StringBuilder(74).append("Please note that a given ").append(productName).append(" version MUST be the same across all modules of ").append(productName).append(" ").toString()).append("that you are using, e.g. if you use [{}] all other modules that are released together MUST be of the ").append("same version. Make sure you're using a compatible set of libraries. ").append("Possibly conflicting versions [{}] in libraries [{}]").toString(), highestVersion, conflictingVersions, fullInfo);
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final void liftedTree2$1(ObjectRef manifests$1) {
        try {
            Enumeration<URL> resources = this.system().dynamicAccess().classLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try (InputStream ios = resources.nextElement().openStream();){
                    Manifest manifest = new Manifest(ios);
                    Attributes attributes = manifest.getMainAttributes();
                    String string = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplTitle()));
                    String string2 = string == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleName())) : string;
                    String title = string2;
                    String string3 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplVersion()));
                    String string4 = string3 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleVersion())) : string3;
                    String version = string4;
                    String string5 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplVendor()));
                    String string6 = string5 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleVendor())) : string5;
                    String vendor = string6;
                    if (title == null || version == null || vendor == null || !ManifestInfo$.MODULE$.akka$util$ManifestInfo$$knownVendors().apply((Object)vendor)) continue;
                    manifests$1.elem = ((Map)manifests$1.elem).updated((Object)title, (Object)new Version(version));
                }
            }
        }
        catch (IOException ioe) {
            Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning("Could not read manifest information. {}", ioe);
        }
    }

    public ManifestInfo(ExtendedActorSystem system) {
        this.system = system;
        ObjectRef manifests = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        this.liftedTree2$1(manifests);
        this.versions = (Map)manifests.elem;
    }

    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final /* synthetic */ Tuple2 x$1;
        private final int[] numbers;
        private final String rest;

        public String version() {
            return this.version;
        }

        private int[] numbers() {
            return this.numbers;
        }

        private String rest() {
            return this.rest;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Version other) {
            void var2_2;
            block0: {
                int diff = 0;
                diff = this.numbers()[0] - other.numbers()[0];
                if (diff != 0 || (diff = this.numbers()[1] - other.numbers()[1]) != 0 || (diff = this.numbers()[2] - other.numbers()[2]) != 0) break block0;
                diff = this.rest().compareTo(other.rest());
            }
            return (int)var2_2;
        }

        public boolean equals(Object o) {
            Version version;
            Object object = o;
            boolean bl = object instanceof Version ? this.compareTo(version = (Version)object) == 0 : false;
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result = HashCode$.MODULE$.SEED();
            result = HashCode$.MODULE$.hash(result, this.numbers()[0]);
            result = HashCode$.MODULE$.hash(result, this.numbers()[1]);
            result = HashCode$.MODULE$.hash(result, this.numbers()[2]);
            result = HashCode$.MODULE$.hash(result, this.rest());
            return (int)var1_1;
        }

        public String toString() {
            return this.version();
        }

        private static final void liftedTree1$1(int[] numbers$1, IntRef numbersPos$1, String[] segments$1, IntRef segmentPos$1) {
            try {
                numbers$1[numbersPos$1.elem] = new StringOps(Predef$.MODULE$.augmentString(segments$1[segmentPos$1.elem])).toInt();
                ++segmentPos$1.elem;
            }
            catch (NumberFormatException numberFormatException) {
                numbers$1[numbersPos$1.elem] = Integer.MAX_VALUE;
            }
        }

        public Version(String version) {
            int[] nArray;
            String rest;
            block6: {
                Tuple2 tuple2;
                block5: {
                    this.version = version;
                    int[] numbers = new int[3];
                    String[] segments = version.split("[.-]");
                    IntRef segmentPos = IntRef.create((int)0);
                    IntRef numbersPos = IntRef.create((int)0);
                    while (numbersPos.elem < 3) {
                        if (segmentPos.elem < segments.length) {
                            Version.liftedTree1$1(numbers, numbersPos, segments, segmentPos);
                        }
                        ++numbersPos.elem;
                    }
                    String rest2 = segmentPos.elem >= segments.length ? "" : String.join((CharSequence)"-", Arrays.asList(Arrays.copyOfRange((Object[])segments, segmentPos.elem, segments.length)));
                    tuple2 = new Tuple2((Object)numbers, (Object)rest2);
                    if (tuple2 == null) break block5;
                    int[] numbers2 = (int[])tuple2._1();
                    rest = (String)tuple2._2();
                    if (numbers2 == null) break block5;
                    nArray = numbers2;
                    if (rest != null) break block6;
                }
                throw new MatchError((Object)tuple2);
            }
            String string = rest;
            Tuple2 tuple2 = new Tuple2((Object)nArray, (Object)string);
            this.x$1 = tuple2;
            this.numbers = (int[])this.x$1._1();
            this.rest = (String)this.x$1._2();
        }
    }
}

