/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.client.DeployitRemoteClient;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.api.internal.PrintHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.engine.api.TaskBlockService;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="deployit")
@ClassHelp(description="The main gateway to interfacing with XL Deploy.")
public class DeployitClient
extends DocumentedObject {
    private ProxiesInstance proxies;
    private DeployitCommunicator communicator;
    private static final Logger logger = LoggerFactory.getLogger(DeployitClient.class);

    public DeployitClient() {
    }

    public DeployitClient(ProxiesInstance proxies) {
        this.proxies = proxies;
        this.communicator = proxies.getCommunicator();
    }

    @MethodHelp(description="Import a package that is located on the server, on the local file system, or in an external location.", parameters={@ParameterHelp(name="importablePackage", description="This is:\n\t- The name of the importable package on the server\n\t- The absolute path to a local importable package\n\t- The URI of an externally stored package")})
    public ConfigurationItem importPackage(String importablePackageName) {
        return new DeployitRemoteClient(this.communicator).importPackage(importablePackageName);
    }

    @MethodHelp(description="List all importable packages on the server.")
    public List<String> listImportablePackages() {
        return this.proxies.getImportablePackage().list();
    }

    @MethodHelp(description="Gracefully stop an active deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void stopTask(String taskId) {
        this.proxies.getTaskBlockRegistry().stop(taskId);
    }

    @MethodHelp(description="Start a deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void startTask(String taskId) {
        DeployitClient.startTask(taskId, this.proxies);
    }

    @MethodHelp(description="Start a deployment task and wait for it to finish", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void startTaskAndWait(String taskId) {
        DeployitClient.startTaskAndWait(taskId, this.proxies, false);
    }

    public void waitForTask(String taskId) {
        DeployitClient.waitForTask(taskId, this.proxies, false);
    }

    @MethodHelp(description="Abort an active deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void abortTask(String taskId) {
        this.proxies.getTaskBlockRegistry().abort(taskId);
    }

    @MethodHelp(description="Cancel a stopped deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void cancelTask(String taskId) {
        this.proxies.getTaskBlockRegistry().cancel(taskId);
    }

    public void skipSteps(String taskId, List<Integer> stepIds) {
        if (stepIds == null || stepIds.isEmpty()) {
            return;
        }
        TaskWithSteps steps = this.proxies.getTaskRegistry().getSteps(taskId);
        ArrayList<Integer> skip = new ArrayList<Integer>();
        ArrayList<Integer> unskip = new ArrayList<Integer>();
        for (Integer stepId : stepIds) {
            StepExecutionState state = ((StepState)steps.getSteps().get(stepId - 1)).getState();
            if (state == StepExecutionState.PENDING || state == StepExecutionState.FAILED) {
                skip.add(stepId);
                continue;
            }
            if (state != StepExecutionState.SKIP) continue;
            unskip.add(stepId);
        }
        if (!skip.isEmpty()) {
            this.proxies.getTaskRegistry().skip(taskId, skip);
        }
        if (!unskip.isEmpty()) {
            this.proxies.getTaskRegistry().unskip(taskId, unskip);
        }
    }

    @MethodHelp(description="(Un)skip steps of the task.\n- If a step is in the PENDING or FAILED state, it will be SKIPPED.\n- If a step is in the SKIPPED state it will be PENDING. ", parameters={@ParameterHelp(name="taskId", description="The id of the task"), @ParameterHelp(name="stepIds", description="The ids of the steps to skip or unskip")})
    public void skipSteps(String taskId, Integer[] stepIds) {
        if (stepIds == null) {
            return;
        }
        this.skipSteps(taskId, Lists.newArrayList((Object[])stepIds));
    }

    @MethodHelp(description="Assign a pending task to another principal", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="owner", description="The new task owner.")})
    public void assignTask(String taskId, String owner) {
        this.proxies.getTaskBlockRegistry().assign(taskId, owner);
    }

    @MethodHelp(description="Creates a task to discover middleware starting with given CI. Refer to plugin configuration item documentation to see which fields are required for discover.", parameters={@ParameterHelp(name="ci", description="The configuration item with all required discovery fields filled in.")})
    public String createDiscoveryTask(ConfigurationItem ci) {
        return this.proxies.getDiscovery().createTask(this.proxies.getDiscovery().prepare(ci));
    }

    @MethodHelp(description="Returns results for the already executed discovery task.", parameters={@ParameterHelp(name="taskId", description="Id of the executed discovery task.")})
    public List<ConfigurationItem> retrieveDiscoveryResults(String taskId) {
        return this.proxies.getDiscovery().retrieveInspectionResults(taskId);
    }

    @MethodHelp(description="Prepares a control task object which can be used to set parameters and have control over the execution of the control task.", parameters={@ParameterHelp(name="ci", description="The configuration item to execute the control task on"), @ParameterHelp(name="taskName", description="The control task name eg. \"start\"")})
    public Control prepareControlTask(ConfigurationItem ci, String taskName) {
        Control prepare = this.proxies.getControlTask().prepare(taskName, ci.getId());
        logger.info("Control[params] = " + prepare.getParameters());
        logger.info("Control[ci] = " + prepare.getConfigurationItem());
        return prepare;
    }

    @MethodHelp(description="Create the prepared control task and returns the task id. Needs to be manually executed using the task service.", parameters={@ParameterHelp(name="control", description="The prepared control task object")})
    public String createControlTask(Control control) {
        return this.proxies.getControlTask().createTask(control);
    }

    @MethodHelp(description="Execute the control task on the provided configuration item. If the control tasks executes successfully, no output is shown. In the case of an error, log output is shown.", parameters={@ParameterHelp(name="taskName", description="The control task name eg. \"start\""), @ParameterHelp(name="ci", description="The configuration item to execute the control task on")})
    public void executeControlTask(String taskName, ConfigurationItem ci) {
        Control control = this.proxies.getControlTask().prepare(taskName, ci.getId());
        String task = this.proxies.getControlTask().createTask(control);
        this.startTaskAndWait(task);
    }

    @MethodHelp(description="Describe the CI class, with all the values it takes.", parameters={@ParameterHelp(name="shortName", description="The (Short) name of the CI eg. \"Host\", \"WasDataSource\", etc")})
    public void describe(String typeName) {
        DescriptorHelper.describe(typeName);
    }

    @MethodHelp(description="Print a tree-view of a CI", parameters={@ParameterHelp(name="ci", description="The CI to print")})
    public void print(ConfigurationItem ci) {
        PrintHelper.getInstance().printCi(ci, this.proxies.getRepository());
    }

    public void print(Collection<ConfigurationItem> cis) {
        PrintHelper.getInstance().printCis(cis, this.proxies.getRepository());
    }

    public Comparison compare(String reference, List<String> ids) {
        return this.proxies.getComparison().compare(reference, ids);
    }

    @MethodHelp(description="Retrieve XL Deploy server information")
    public ServerInfo info() {
        return this.proxies.getServer().getInfo();
    }

    @MethodHelp(description="Run the XL Deploy server garbage collector")
    public void runGarbageCollector() {
        this.proxies.getServer().gc();
    }

    @MethodHelp(description="Shutdown the XL Deploy server")
    public void shutdown() {
        this.proxies.getServer().shutdown();
    }

    protected static void startTask(String taskId, ProxiesInstance proxies) {
        proxies.getTaskBlockRegistry().start(taskId);
    }

    protected static void startTaskAndWait(String taskId, ProxiesInstance proxies, boolean cancelIfFailed) {
        logger.debug("Starting and waiting for task {}", (Object)taskId);
        DeployitClient.startTask(taskId, proxies);
        DeployitClient.waitForTask(taskId, proxies, cancelIfFailed);
    }

    protected static void waitForTask(String taskId, ProxiesInstance proxies, boolean cancelIfFailed) {
        boolean done = false;
        TaskWithBlock task = null;
        while (!done) {
            task = proxies.getTaskBlockRegistry().getTask(taskId);
            TaskExecutionState st = task.getState();
            if (st.isPassiveAfterExecuting()) {
                logger.debug("Task {} passive with state {}", (Object)taskId, (Object)st);
                done = true;
                continue;
            }
            try {
                logger.debug("Task {} still active {}, sleeping", (Object)taskId, (Object)st);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.debug("Task {} still active {}, interrupted", (Object)taskId, (Object)st);
                Thread.currentThread().interrupt();
            }
        }
        TaskExecutionState state = task.getState();
        if (state == TaskExecutionState.EXECUTED) {
            logger.debug("Task {} passive with state {}, archiving....", (Object)taskId, (Object)state);
            DeployitClient.archiveAndWait(taskId, proxies);
        } else if (cancelIfFailed && state.isExecutionHalted()) {
            logger.debug("Task {} passive with state {}, canceling....", (Object)taskId, (Object)state);
            proxies.getTaskBlockRegistry().cancel(taskId);
        }
        logger.debug("Task {} has finished waiting with state {}", (Object)taskId, (Object)state);
    }

    private static void archiveAndWait(String taskId, ProxiesInstance proxies) {
        TaskBlockService taskRegistry = proxies.getTaskBlockRegistry();
        logger.debug("Archiving task {}", (Object)taskId);
        taskRegistry.archive(taskId);
        boolean archived = false;
        int tries = 0;
        int sleepTime = 200;
        int timeout = 20000;
        CountDownLatch latch = new CountDownLatch(3);
        while (!archived && tries < timeout / sleepTime && latch.getCount() > 0L) {
            try {
                TaskWithBlock task = taskRegistry.getTask(taskId);
                TaskExecutionState st = task.getState();
                if (st.isFinal()) {
                    logger.debug("Task {} archiving complete with state {}", (Object)taskId, (Object)st);
                    archived = true;
                    continue;
                }
                DeployitClient.sleepForAwhile(taskId, st, sleepTime);
                ++tries;
            }
            catch (DeployitClientException e) {
                latch.countDown();
                DeployitClient.sleepForAwhile(taskId, null, sleepTime);
                ++tries;
            }
        }
        if (!archived) {
            throw new IllegalStateException("Timeout waiting for task " + taskId + " to archive after " + timeout + " ms.");
        }
        logger.debug("Task {} done archiving", (Object)taskId);
    }

    private static void sleepForAwhile(String taskId, TaskExecutionState st, int sleepTime) {
        try {
            logger.debug("Task {} still not archived {}, sleeping", (Object)taskId, (Object)st);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            logger.debug("Task {} still not archived {} but interrupted", (Object)taskId, (Object)st);
            Thread.currentThread().interrupt();
        }
    }
}

