/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io.copy;

import com.typesafe.config.Config;
import com.xebialabs.deployit.io.copy.CopyStrategies$;
import com.xebialabs.deployit.io.copy.CopyStrategy;
import com.xebialabs.deployit.io.copy.package$;
import com.xebialabs.deployit.plugin.overthere.CopyStrategyName;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlplatform.config.ConfigurationHolder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class ArtifactCopier$
implements Logging {
    public static ArtifactCopier$ MODULE$;
    private final List<CopyStrategy> knownStrategies;
    private final scala.collection.immutable.Map<OperatingSystemFamily, List<CopyStrategy>> tryOrder;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ArtifactCopier$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArtifactCopier$ artifactCopier$ = this;
        synchronized (artifactCopier$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void copyWithConfig(LocalFile src, OverthereFile dest, Map<String, String> config) {
        if (src.isFile()) {
            src.copyTo(dest);
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Determining copy strategy for ").append(dest.getConnection()).append("...").toString());
            Option specifiedStrategy = Option$.MODULE$.apply(dest.getConnection().getOptions().getOptional("ARTIFACTFILE_COPYSTRATEGY"));
            ObjectRef configMap = ObjectRef.create((Object)new HashMap());
            if (config != null) {
                configMap.elem = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config).asScala()).toMap(Predef$.MODULE$.$conforms());
            }
            CopyStrategy copyStrategy = (CopyStrategy)specifiedStrategy.map((Function1 & Serializable & scala.Serializable)strategyName -> MODULE$.getStrategy((CopyStrategyName)strategyName)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.detectStrategy(dest.getConnection(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)configMap$1.elem)));
            copyStrategy.copyZipped(src, dest);
        }
    }

    private List<CopyStrategy> knownStrategies() {
        return this.knownStrategies;
    }

    /*
     * WARNING - void declaration
     */
    private CopyStrategy getStrategy(CopyStrategyName strategyName) {
        void var2_2;
        CopyStrategy detected = (CopyStrategy)this.knownStrategies().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArtifactCopier$.$anonfun$getStrategy$1(strategyName, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Unhandled specified format ").append(strategyName.name()).append(" - using ").append(CopyStrategyName.OneByOne.name()).append(" instead").toString());
            return CopyStrategies$.MODULE$.oneByOne();
        });
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Specified strategy: ").append(detected.zipFormat().name()).toString());
        return var2_2;
    }

    private CopyStrategy detectStrategy(OverthereConnection conn, scala.collection.immutable.Map<String, String> backupConfig) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("No copy strategy specified on ").append(conn).toString());
        Config config = ConfigurationHolder$.MODULE$.get();
        String autodetectSetting = "xl.task.artifact-copy-strategy.autodetect";
        BooleanRef allowDetect = BooleanRef.create((boolean)false);
        allowDetect.elem = config == null ? new StringOps(Predef$.MODULE$.augmentString(backupConfig.getOrElse((Object)autodetectSetting, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false).toString())).toBoolean() : config.hasPath(autodetectSetting) && config.getBoolean(autodetectSetting);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Auto-detection of strategy is allowed: ").append(allowDetect$1.elem).toString());
        CopyStrategy workingStrategy = !allowDetect.elem ? CopyStrategies$.MODULE$.oneByOne() : this.detect(conn);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Picking the strategy ").append(workingStrategy.name()).append(".").toString());
        return workingStrategy;
    }

    private scala.collection.immutable.Map<OperatingSystemFamily, List<CopyStrategy>> tryOrder() {
        return this.tryOrder;
    }

    private CopyStrategy detect(OverthereConnection connection) {
        List strategies = (List)this.tryOrder().apply((Object)connection.getHostOperatingSystem());
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Trying capabilities in the next order: ").append(strategies.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), List$.MODULE$.canBuildFrom())).toString());
        return (CopyStrategy)package$.MODULE$.withTempDirectory((Function1 & Serializable & scala.Serializable)tmpDir -> {
            Path subdir = tmpDir.resolve("preflight").resolve("subdir");
            Files.createDirectories(subdir, new FileAttribute[0]);
            Path testfile = subdir.resolve("testfile.txt");
            Files.write(testfile, "This is a preflight test file to detect unzip/untar capabilities".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return (CopyStrategy)strategies.find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ArtifactCopier$.$anonfun$detect$4(testfile, connection, s))).getOrElse((Function0 & Serializable & scala.Serializable)() -> CopyStrategies$.MODULE$.oneByOne());
        });
    }

    public static final /* synthetic */ boolean $anonfun$getStrategy$1(CopyStrategyName strategyName$1, CopyStrategy x$1) {
        return x$1.zipFormat().equals((Object)strategyName$1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$detect$4(Path testfile$1, OverthereConnection connection$1, CopyStrategy s) {
        void var3_3;
        MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Trying ").append(s.name()).append("...").toString());
        boolean success = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> s.copyZipped(LocalFile.from((File)testfile$1.toFile()), connection$1.getTempFile("preflight"))).isSuccess();
        MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Was ").append(s.name()).append(" successful? --> ").append(success).toString());
        return (boolean)var3_3;
    }

    private ArtifactCopier$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.knownStrategies = new .colon.colon((Object)CopyStrategies$.MODULE$.oneByOne(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.untar(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.unzipUnix(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.unzipWindows(), (List)Nil$.MODULE$))));
        this.tryOrder = ((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OperatingSystemFamily.WINDOWS), (Object)new .colon.colon((Object)CopyStrategies$.MODULE$.unzipWindows(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.untar(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.unzipUnix(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.oneByOne(), (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OperatingSystemFamily.UNIX), (Object)new .colon.colon((Object)CopyStrategies$.MODULE$.untar(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.unzipUnix(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.unzipWindows(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.oneByOne(), (List)Nil$.MODULE$)))))}))).withDefaultValue((Object)new .colon.colon((Object)CopyStrategies$.MODULE$.oneByOne(), (List)Nil$.MODULE$));
    }
}

