/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.core.Authentication;

public class PermissionHelper {
    public static boolean hasPermission(Permission ... permission) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission);
    }

    public static boolean hasPermission(Permission permission, String onConfigurationItem) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission, onConfigurationItem);
    }

    public static boolean hasPermission(List<Permission> permission, String onConfigurationItem) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission, onConfigurationItem);
    }

    public static boolean hasPermission(Permission[] permission, String onConfigurationItem) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(Arrays.asList(permission), onConfigurationItem);
    }

    public static void applyPermission(SearchParameters parameters, Permission permission) {
        SecurityServiceLocator.getPermissionEnforcer().applyLoggedInUserPermission(parameters, permission);
    }

    public static List<Role> getCurrentRoles() {
        return SecurityServiceLocator.getPermissionEnforcer().getUserRoles(Permissions.getAuthentication());
    }

    public static boolean isCurrentUserAdmin() {
        return SecurityServiceLocator.getPermissionEnforcer().isCurrentUserAdmin();
    }

    public static boolean isAdmin(Authentication authentication) {
        return SecurityServiceLocator.getPermissionEnforcer().isAdmin(authentication);
    }
}

