'use strict';

angular.module('DeploymentScreen', ['ui.router', 'xl.components', 'xl.templates', 'ui.bootstrap', 'xl.online.commons'])
    .config(function ($stateProvider, $urlRouterProvider) {
        $urlRouterProvider.otherwise('/deployment-screen');
        $stateProvider.
            state('deployment-screen', {
                url: '/deployment-screen',
                templateUrl: 'web-src/deployment-screen/deployment.html',
                controller: 'deploymentCtrl'
            });
    })
    .run(function ($rootScope, typeSystemService, dipHandlers) {
        typeSystemService.loadTypesDescriptors();

        // Used in DIP Forms
        $rootScope.dipHandlers = dipHandlers;
    });

'use strict';

angular.module('DeploymentScreen').controller('deploymentCtrl', function ($scope, $timeout, $http, $state, deploymentService,
                                                                               treeService, ciTabsService, constantService, confirmDialogService) {


    $scope.applications = [];
    $scope.currentNode = {};

    $scope.selectNode = function (node) {
        $scope.currentNode.path = node.path;
    };

    $scope.unfoldPathToNode = function (targetNodePath) {
        var nodeLabelsInPath = targetNodePath.split('/');
        if (targetNodePath[0] === '/') {
            nodeLabelsInPath.splice(0, 1);
        }
        var parentNode = {path: constantService.ROOT.APPLICATIONS, children: $scope.applications, classType: 'dirClass'};
        treeService.unfoldNode(nodeLabelsInPath, 0, parentNode, $scope.selectNode, deploymentService.findCIStructureByParent);
    };

    $scope.getRootCIs = function () {
        deploymentService.findCIStructureByParent().then(function (rootCIs) {
            $scope.applications = rootCIs;
        });
    };

    $scope.findNodeChildren = function (node) {
        return deploymentService.findCIStructureByParent(node.path, node.classType);
    };

    $scope.removeNode = function(id) {
        var nodeLabelsInPath = id.split('/');
        treeService.removeNode(nodeLabelsInPath.splice(1), $scope.applications);
    };

    $scope.treeOptions = {
        clickAction: function (node) {
            openTab(node, 'AUTO');
        },
        dblClickAction: function (node) {
            openTab(node, 'FORCE_NEW');
        }
    };

    var openTab = function(node, tabMode) {
        if (node.classType === deploymentService.applicationTypeId) {
            ciTabsService.viewApplication(node.path, tabMode);
        } else if (node.classType === deploymentService.versionTypeId) {
            ciTabsService.viewDeploymentPackage(node.path);
        } else if (node.classType === deploymentService.deployableTypeId) {
            ciTabsService.viewDeployable(node.path, tabMode);
        }
    };

    $scope.getRootCIs();


    $scope.newDeploymentPackage = ciTabsService.newDeploymentPackage;
    $scope.importCIs = ciTabsService.importCIs;

    $scope.confirmDialog = function(cond, action) {
        confirmDialogService.confirmDialog(cond, 'Are you sure you want to leave? Any changes will be lost.', action);
    };


    console.log('CALLING');

    $scope.deployApplication = deploymentService.getApplications();
    //$scope.deployEnvironment = deploymentService.findCIStructureByParent(node.path, node.classType);





});

'use strict';

angular.module('DeploymentScreen').factory('deploymentResource', function ($http, constantService, repositoryQueryBuilder) {

    return {
        findAllApplications: function (namePattern) {
            var query = repositoryQueryBuilder.newQueryBuilder()
                .withType(constantService.TYPE.UDM_APPLICATIONS)
                .withNamePattern(namePattern)
                .query();
            return $http.get('/deployit/repository/query', query);
        },
        findAllApplicationsByParent: function (parentId, namePattern) {
            var query = repositoryQueryBuilder.newQueryBuilder()
                .withType(constantService.TYPE.UDM_APPLICATIONS)
                .withNamePattern(namePattern)
                .withParent(parentId)
                .query();
            return $http.get('/deployit/repository/query', query);
        }
    };
});

'use strict';

angular.module('DeploymentScreen').factory('deploymentService', function ($q, $http, ciResource, deploymentResource, directoryResource, versionResource, constantService, utils, repositoryQueryBuilder) {


    var applicationTypeId = 'appClass';
    var directoryTypeId = 'dirClass';
    var versionTypeId = 'versionClass';
    var deployableTypeId = 'deployableClass';

    function getCi(ciId) {
        return ciResource.get(ciId);
    }

    function getExistingDirectories(namePattern) {
        return directoryResource.findAllDirectoriesByAncestor(constantService.ROOT.APPLICATIONS, namePattern).then(utils.getCiIdsWithoutPrefix);
    }

    function findAllCis (type, namePattern) {
        return ciResource.findAllCis (type, namePattern);
    }

    function getApplications() {

        var query = repositoryQueryBuilder.newQueryBuilder()
            .withType('udm.Version')
            .query();

        console.log('CALLING');

        return $http.get('/deployit/repository/query', query);

    }


    function addCandidatesApplication(meta, params) {
        return deploymentResource.findAllApplications(params.term).then(function(response) {
            return _.map(response.data, function (ci) {
                ci.id = utils.removePrefix(ci.ref);
                return ci;
            });
        });
    }

    function ciExists(ciName) {
        return ciResource.ciExists(constantService.ROOT.APPLICATIONS + '/' + ciName);
    }

    function addTypeToReturnedData(responseData, classType) {
        _.each(responseData, function (it) {
            it.classType = classType;
        });
        return responseData;
    }


    function parseDeployableRefToNodeData(deployableRef) {
        return {ref: deployableRef, classType: deployableTypeId};
    }

    function parseDataToSingleNode(data) {
        var path = data.ref;
        var classType = data.classType;
        var labels = path.split('/');
        var id = 'id_' + path;
        var idDom = id.replace(new RegExp('/', 'g'), '-');
        idDom = idDom.replace(new RegExp(' ', 'g'), '-');
        var node = {id: 'id_' + path, path: path, label: _.last(labels), classType: classType, idDom: idDom};

        if (classType !== deployableTypeId) {
            node.children = [];
        }

        return node;
    }

    function findCIStructureByParent(parentPath, parentType) {
        if (!parentPath) {
            parentPath = constantService.ROOT.APPLICATIONS;
        }
        var promises = [];
        if (!parentType || parentType === directoryTypeId) {
            // we look for root nodes or children of a directory.
            var directoriesPromise = directoryResource.findAllDirectoriesByParent(parentPath).then(function (response) {
                return addTypeToReturnedData(response.data, directoryTypeId);
            });
            var applicationsPromise = deploymentResource.findAllApplicationsByParent(parentPath).then(function (response) {
                return addTypeToReturnedData(response.data, applicationTypeId);
            });
            promises.push(directoriesPromise);
            promises.push(applicationsPromise);
        } else if (parentType && parentType === applicationTypeId) {
            var versionsPromise = versionResource.findAllVersionsByParent(parentPath).then(function (response) {
                return addTypeToReturnedData(response.data, versionTypeId);
            });
            promises.push(versionsPromise);
        } else if (parentType && parentType === versionTypeId) {
            var deployablePromise = ciResource.get(parentPath).then(function (response) {
                return _.map(response.data.deployables, parseDeployableRefToNodeData);
            });
            promises.push(deployablePromise);
        }

        return $q.all(promises).then(function (allData) {
            var structureData = [];
            _.forEach(allData, function (data) {
                structureData = _.union(structureData, data);
            });
            structureData = _.map(structureData, parseDataToSingleNode);

            return structureData;
        });
    }

    return {
        applicationTypeId: applicationTypeId,
        directoryTypeId: directoryTypeId,
        versionTypeId: versionTypeId,
        deployableTypeId: deployableTypeId,

        getCi: getCi,
        findAllCis: findAllCis,
        ciExists: ciExists,
        getExistingDirectories: getExistingDirectories,
        addCandidatesApplication: addCandidatesApplication,
        findCIStructureByParent: findCIStructureByParent,
        addTypeToReturnedData: addTypeToReturnedData,
        getApplications: getApplications
    };

});

'use strict';

angular.module('DeploymentScreen')
    .config(function ($uiTabsProvider) {

        $uiTabsProvider
            .welcome({
                templateUrl: 'web-src/deployment-screen/tabs/welcome/welcome.html'
            })
            .onClose(['confirmDialogService', function (confirmDialogService) {
                return function (tab) {
                    return confirmDialogService.openConfirmDialog(tab.pristine, 'Are you sure you want to leave? Your changes will be lost.');
                };
            }]);
    });
'use strict';

angular.module('DeploymentScreen').factory('ciTabsService', function (utils, $uiTabs, constantService) {

    // application tabs
    var viewApplication = function (applicationId, forceNewTab) {
        openOrReplaceTab('applications.app.view', {
            title: utils.removePrefix(applicationId),
            $tabData: {
                applicationId: applicationId,
                mode: constantService.MODES.VIEW
            }
        }, forceNewTab);
    };

    var editApplication = function () {
        var currentTab = $uiTabs.getActiveTab();
        var $tabData = angular.copy(currentTab.$tabData);
        $tabData.mode = constantService.MODES.EDITION;
        openOrReplaceTab('applications.app.edit', {
            title: currentTab.title,
            $tabData: $tabData
        }, 'FORCE_SAME');
    };

    var switchToViewApplication = function () {
        var currentTab = $uiTabs.getActiveTab();
        openOrReplaceTab('applications.app.view', {
            title: utils.removePrefix(currentTab.$tabData.applicationId),
            $tabData: {
                applicationId: currentTab.$tabData.applicationId,
                mode: constantService.MODES.VIEW
            }
        }, 'FORCE_SAME');
    };

    // deployable tabs
    var viewDeployable = function (deployableId, forceNewTab) {
        openOrReplaceTab('applications.deployable.view', {
            title: utils.removePrefix(deployableId),
            $tabData: {
                deployableId: deployableId,
                mode: constantService.MODES.VIEW
            }
        }, forceNewTab);
    };

    var editDeployable = function () {
        var currentTab = $uiTabs.getActiveTab();
        var $tabData = angular.copy(currentTab.$tabData);
        $tabData.mode = constantService.MODES.EDITION;
        openOrReplaceTab('applications.deployable.edit', {
            title: currentTab.title,
            // initialized: currentTab.initialized,
            $tabData: $tabData
        }, 'FORCE_SAME');
    };

    var switchToViewDeployable = function () {
        var currentTab = $uiTabs.getActiveTab();
        var $tabData = angular.copy(currentTab.$tabData);
        $tabData.mode = constantService.MODES.VIEW;
        openOrReplaceTab('applications.deployable.view', {
            title: utils.removePrefix($tabData.deployableId),
            $tabData: $tabData
        }, 'FORCE_SAME');
    };


    // version deployment package
    var newDeploymentPackage = function () {
        openOrReplaceTab('applications.deployment.package', {
            mode: constantService.MODES.CREATION
        }, 'FORCE_NEW');
    };

    // view version deployment package
    var viewDeploymentPackage = function (versionId) {
        openOrReplaceTab('applications.deployment.package', {
            title: utils.removePrefix(versionId),
            versionId: versionId,
            mode: constantService.MODES.VIEW
        }, 'FORCE_NEW');
    };

    // import tabs
    var importCIs = function () {
        $uiTabs.addTab('applications.import', {});
    };

    /**
     * Opens or replace a CI tab
     * @param targetState target tab type
     * @param options tab options
     * @param tabMode
     *  FORCE_NEW - always opens new tab,
     *  FORCE_SAME - switches the same tab if possible,
     *  AUTO - if current tab is in visual mode, switches the current tab, if not - opens new
     */
    var openOrReplaceTab = function (targetState, options, tabMode) {
        var currentTab = $uiTabs.getActiveTab();
        if (!currentTab || !!currentTab.isWelcome || tabMode === 'FORCE_NEW') {
            $uiTabs.addTab(targetState, options);
        } else if (currentTab && (currentTab.$tabData.mode === 'visual' || tabMode === 'FORCE_SAME')) {
            $uiTabs.addTab(targetState, options, currentTab.$$id);
        }
    };


    /**
     * Public API
     */
    return {
        viewApplication: viewApplication,
        editApplication: editApplication,
        switchToViewApplication: switchToViewApplication,

        viewDeployable: viewDeployable,
        editDeployable: editDeployable,
        switchToViewDeployable: switchToViewDeployable,

        newDeploymentPackage: newDeploymentPackage,
        viewDeploymentPackage: viewDeploymentPackage,

        importCIs: importCIs
    };
});