
class DiscoverableCis(object):
    def __init__(self, metadataService, repositoryService):
        self._metadataService = metadataService
        self._repositoryService = repositoryService

    def _find_discoverable_types(self):
        return [d.type for d in self._metadataService.listDescriptors() if d.isInspectable()]

    def search_for_discoverable_cis(self):
        def query(discoverableType):
            return self._repositoryService.query(discoverableType, None, None, None, None, None, 0, -1)

        def convertId(ciId):
            return {"id": str(ciId.id), "type": str(ciId.type)}

        resultsPerType = map(query, self._find_discoverable_types())
        allResults = []
        for results in resultsPerType:
            if len(results):
                allResults.extend(map(convertId, results))

        return allResults
