from com.xebialabs.deployit.core import AbstractStringView as stringView
from com.xebialabs.deployit.core import MapStringStringView as mapView
from java.util.Collections import sort
from java.util import ArrayList

class PropertyUtil(object):

    @classmethod
    def to_string(cls, prop_value, kind):

        if isinstance(prop_value, stringView):
            result = []
            for wrapped in prop_value.getWrapped():
                result.append(str(wrapped.toPublicFacingValue()))
            return cls._ordered_str(result, kind)
        elif isinstance(prop_value, mapView):
            result = []
            wrapped = prop_value.getWrapped()
            for key in wrapped:
                value = wrapped[key]
                result.append(str(value.toPublicFacingValue()))

            return cls._ordered_str(result, kind)

        str_value = cls._ordered_str(prop_value, kind)

        if str_value in ["", "None", "null"]:
            return None

        return str_value

    @staticmethod
    def _ordered_str(collection, kind):

        if kind == 'SET_OF_STRING':
            as_list = ArrayList(collection)
            sort(as_list)
            return str(as_list)

        return str(collection)
