set -e

echo "Updating XLS ${deployed.file.name}"

INSTALL_DIR="${deployed.container.installationHome}"
PREVIOUS_XLS_HOME=$INSTALL_DIR/`basename ${previousDeployed.file.name} .zip`
NEW_XLS_HOME=$INSTALL_DIR/`basename ${deployed.file.name} .zip`
LINKED_XLS_HOME=$INSTALL_DIR/xl-satellite-current
SYSTEM_CONFIGURATION_LOCATION="$INSTALL_DIR/satellite.conf"

echo "Uninstalling ${previousDeployed.file.name}"
$PREVIOUS_XLS_HOME/bin/${previousDeployed.container.uninstallerExecutableName}

unzip -qo "${deployed.file.path}" -d $INSTALL_DIR

rm $LINKED_XLS_HOME
ln -sf $NEW_XLS_HOME $LINKED_XLS_HOME

echo "Updating XL Satellite in $NEW_XLS_HOME with $PREVIOUS_XLS_HOME"

cp -rf $PREVIOUS_XLS_HOME/conf $LINKED_XLS_HOME/
rm -rf $PREVIOUS_XLS_HOME

#INSTLLING EXTENSION
for ext in $INSTALL_DIR/ext/*; do
    if [ -f $ext ]; then
        echo "Installing extension $ext"
        cp -rfv $ext $LINKED_XLS_HOME/ext/
    fi
done

#INSTLLING PLUGINS
for plugin in $INSTALL_DIR/plugins/*; do
    if [ -f $plugin ]; then
        echo "Installing plugin $plugin"
        cp -fv $plugin $LINKED_XLS_HOME/plugins/
    fi
done

if [ -f "$SYSTEM_CONFIGURATION_LOCATION" ]; then
    echo "Installing system.conf"
    cp -f "$SYSTEM_CONFIGURATION_LOCATION" "$LINKED_XLS_HOME/conf/satellite.conf"
fi

echo "Installing XLS as a service"

yes root | $LINKED_XLS_HOME/bin/${deployed.container.installerExecutableName}

echo "SUCCESS"
