set -e

echo "Installation XL Deploy Data ${deployed.file.path}"

INSTALL_DIR="${deployed.container.installationHome}"
XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
DATA_DIR=$INSTALL_DIR/data

mkdir -p $DATA_DIR
unzip -qo "${deployed.file.path}" -d $DATA_DIR

EXT_DIR=$(find "$DATA_DIR" -type d -name '*-extensions' | head -1)
IMP_PCKGS_DIR=$(find "$DATA_DIR" -type d -name '*-importable-packages' | head -1)

if [ ! -z $EXT_DIR ] && [ -d $EXT_DIR ]; then
    echo "Copying ext folder"
    cp -rf $EXT_DIR/* $XLD_HOME/ext
fi

if [ ! -z $IMP_PCKGS_DIR ] && [ -d $IMP_PCKGS_DIR ]; then
    echo "Copying importablePackages folder"
    mkdir -p $XLD_HOME/importablePackages
    cp -rf $IMP_PCKGS_DIR/* $XLD_HOME/importablePackages
fi

rm -f ${deployed.file.path}*

echo "SUCCESS"
