
set -e

echo "Installing XLS"

INSTALL_DIR="${deployed.container.installationHome}"
SYSTEM_CONFIGURATION_LOCATION="$INSTALL_DIR/satellite.conf"
XLS_HOME=$INSTALL_DIR/`basename ${deployed.file.name} .zip`
LINKED_XLS_HOME=$INSTALL_DIR/xl-satellite-current

if [ ! -d "$INSTALL_DIR" ]; then
  echo "Directory $INSTALL_DIR does not exist."
fi

unzip -qo "${deployed.file.path}" -d "$INSTALL_DIR"
ln -sf $XLS_HOME $LINKED_XLS_HOME

echo "XL Satellite home is $XLS_HOME"

if [ -f "$SYSTEM_CONFIGURATION_LOCATION" ]; then
  echo "Installing system.conf"
  cp -f "$SYSTEM_CONFIGURATION_LOCATION" "$LINKED_XLS_HOME/conf/satellite.conf"
fi

#INSTLLING EXTENSION
for ext in $INSTALL_DIR/ext/*; do
    if [ -f $ext ]; then
        echo "Installing extension $ext"
        cp -rfv $ext $LINKED_XLS_HOME/ext/
    fi
done

#INSTLLING PLUGINS
for plugin in $INSTALL_DIR/plugins/*; do
    if [ -f $plugin ]; then
        echo "Installing plugin $plugin"
        cp -fv $plugin $LINKED_XLS_HOME/plugins/
    fi
done

echo "Installing XLS as a service"

yes root | $LINKED_XLS_HOME/bin/${deployed.container.installerExecutableName}

echo "SUCCESS"
