set -e

INSTALL_DIR="${deployed.container.installationHome}"
DATA_DIR=$INSTALL_DIR/data

mkdir -p $DATA_DIR
unzip -o "${deployed.file.path}" -d $DATA_DIR

XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
PACKAGES_DIR=$(find "$DATA_DIR" -type d -name 'xld-ci-explorer-*-importable-packages' | head -1)
DEST_DIR="$XLD_HOME/importablePackages"

if [ ! -z $PACKAGES_DIR ] && [ -d $PACKAGES_DIR ]; then
    echo "Installing XL Deploy Importable Packages from $PACKAGES_DIR into $DEST_DIR"
    cp -rf $PACKAGES_DIR/* $DEST_DIR
fi

echo "SUCCESS"