from sets import Set

def containersAndOperation():
    op = "NOOP"
    is_plg = False
    is_srv = False
    result = []
    for _delta in deltas.deltas:
        is_plg = _delta.deployedOrPrevious.type == "xl-satellite.DeployedPlugin"
        is_srv = _delta.deployedOrPrevious.type == "xl-satellite.DeployedServerDistribution"
        deployed = _delta.deployedOrPrevious
        current_container = deployed.container
        if _delta.operation != "NOOP" and current_container.type == "xl-satellite.Server":
            result.append(current_container)
            op = _delta.operation.name()
    return Set(result), op, is_srv, is_plg


xlsServers, operation, is_server, is_plugin = containersAndOperation()

for c in xlsServers:
    if (operation in ["MODIFY", "DESTROY"] and is_server) or is_plugin:
        context.addStep(steps.os_script(
            description="Stopping satellite %s" % c.name,
            order=20,
            script="xls/stop",
            freemarker_context={'container': c},
            target_host=c.host
        ))

    if (operation in ["CREATE", "MODIFY"] and is_server) or is_plugin:
        context.addStep(steps.os_script(
            description="Starting satellite %s" % c.name,
            order=80,
            script="xls/start",
            freemarker_context={'container': c},
            target_host=c.host
        ))
        context.addStep(steps.wait(
            description="Waiting for satellite start",
            order=85,
            seconds=60
        ))
