set -e

echo Starting the XL Deploy server

nohup service xl-deploy start

COUNT=60
url="http://localhost:${container.port}"
while [ $COUNT -gt 0 ]; do
	sleep 2
	if curl --output /dev/null --silent --head --fail "$url"; then
	  echo "XL Deploy has started on port ${container.port}"
	  exit 0
	else
	  echo "Waiting for XL Deploy to start on port ${container.port} ..."
	fi
    COUNT=$((COUNT-1))
done
echo "XL Deploy did not start in 2 minutes, please check its log files or try again"
exit 1
