set -e

INSTALL_DIR="${deployed.container.installationHome}"
XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
DEST_DIR="$XLD_HOME/conf"
mkdir -p $DEST_DIR

XL_DEPLOY_CONF_FILE=$XLD_HOME/conf/xl-deploy.conf

echo "Installing XL Deploy Config Data into $DEST_DIR"
unzip -o "${deployed.file.path}" -d $DEST_DIR

echo "Injecting Database configuration..."
DB_STRING="jdbc:derby://localhost:1527/xldrepo;create=true;user=admin;password=admin"
echo "xl.reporting.database.db-url=\"$DB_STRING\"" >> $XL_DEPLOY_CONF_FILE
echo "xl.repository.database.db-url=\"$DB_STRING\"" >> $XL_DEPLOY_CONF_FILE

echo "SUCCESS"