for _delta in deltas.deltas:
    operation = "NOOP"
    deployed = _delta.deployedOrPrevious
    current_container = deployed.container
    is_server = _delta.deployedOrPrevious.type == "xl-deploy.DeployedServerDistribution"

    if _delta.operation != "NOOP" and current_container.type == "xl-deploy.Server":
        operation = _delta.operation.name()

    if operation in ["MODIFY", "DESTROY"]:
        if context.getAttribute(current_container.name + ".stop") is None:
            context.addStep(steps.os_script(
                description="Stopping server '%s'" % current_container.name,
                order=20,
                script="xld/stop",
                freemarker_context={'container': current_container},
                target_host=current_container.host
            ))
            context.setAttribute(current_container.name + ".stop", True)

    if operation in ["CREATE", "MODIFY"]:
        if context.getAttribute(current_container.name + ".start") is None:
            context.addStep(steps.os_script(
                description="Starting server '%s'" % current_container.name,
                order=80,
                script="xld/start",
                freemarker_context={'container': current_container},
                target_host=current_container.host
            ))
            context.setAttribute(current_container.name + ".start", True)