
id = testRun.getTestRunId()

events = testRun.getEvents()

if events:
    right = {}
    wrong = {}
    for ev in events:
        if ev.type != 'junitresult':
            continue
        p = ev.getProperties()
        print 'properties', p
        #p = ev
        suite = p.get('suitename')

        if p.get('failed') > 0:
            wrong.setdefault(suite, []).append(1)
        else:
            right.setdefault(suite, []).append(1)

    suites = sorted(set(wrong.keys() + right.keys()))

    right = map(lambda t: len(right.get(t, [])), suites)
    wrong = map(lambda t: len(wrong.get(t, [])), suites)
    print 'Suites', suites
    print 'Right', right
    print 'Wrong', wrong


    resultHolder.setResult(
        {
            'chart': {
                'type': 'column',
                'width': '1400'
            },
            'title': {
                'text': 'Test result overview per suite'
            },
            'xAxis': {
                'categories': suites
            },
            'yAxis': {
                'min': 0,
                'title': {
                    'text': 'Total tests'
                },
                'stackLabels': {
                    'enabled': True,
                    'style': {
                        'fontWeight': 'bold'
                    }
                }
            },
            'legend': {
                'align': 'right',
                'x': -70,
                'verticalAlign': 'top',
                'y': 20,
                'floating': True,
                'borderColor': '#CCC',
                'borderWidth': 1,
                'shadow': False
            },
            'plotOptions': {
                'column': {
                    'stacking': 'normal',
                    'dataLabels': {
                        'enabled': True,
                        'color': 'white',
                        'style': {
                            'textShadow': '0 0 3px black, 0 0 3px black'
                        }
                    }
                }
            },
            'credits': {
                'enabled': False
            },
            "series": [{
                           "name": "Passed",
                           "data": right
                       },
                       {
                           "name": "Failed",
                           "data": wrong
                       }]
        })