from com.xebialabs.xltest.utils import Executor
from com.xebialabs.xltest.domain import Event
from com.xebialabs.overthere import OperatingSystemFamily
from com.xebialabs.overthere import CmdLine
from java.lang import ProcessBuilder
from java.lang import InterruptedException
from java.util.concurrent import TimeoutException
from org.slf4j import LoggerFactory
from java.lang import System

LOG = LoggerFactory.getLogger("Local Test run")

LOG.info("Performing: " + str(commandLine.toCommandArray(OperatingSystemFamily.getLocalHostOperatingSystemFamily(), False)))

processBuilder = ProcessBuilder(commandLine.toCommandArray(OperatingSystemFamily.getLocalHostOperatingSystemFamily(), False)).inheritIO()
processBuilder.environment().put("XLTEST_URL", self.getUri().toString())
process = processBuilder.start()

# timeout is in seconds
timeout = testSet.getTimeout();
cleanupCommandLine = testSet.getCleanupCommandUponTimeout()
exitCode = 0
try:
    eventDispatcher.notify(self.testRunId, Event({'run_id':self.name, 'type':'jobStatus', 'status':'started'}))
    startMoment = System.currentTimeMillis()
    exitCode = Executor.execute(process, timeout);
    eventDispatcher.notify(self.testRunId, Event({'run_id':self.name, 'type':'jobStatus', 'status':'finished', 'started':startMoment, 'reason':'success'}))
except (InterruptedException, TimeoutException):
    eventDispatcher.notify(self.testRunId, Event({'run_id':self.name, 'type':'jobStatus', 'status':'finished', 'started':startMoment, 'reason':'timeout'}))
    process.destroy();
    if cleanupCommandLine:
        processBuilder = ProcessBuilder(CmdLine().addArgument(cleanupCommandLine).toCommandArray(OperatingSystemFamily.getLocalHostOperatingSystemFamily(), False)).inheritIO()
        processBuilder.environment().put("XLTEST_URL", self.getUri().toString())
        process = processBuilder.start()
    exitCode = -1

resultHolder.setResult(exitCode)
