/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.pool.factory;

import javax.naming.directory.DirContext;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.pool.DirContextType;
import org.springframework.ldap.pool.validation.DirContextValidator;

class DirContextPoolableObjectFactory
extends BaseKeyedPoolableObjectFactory {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ContextSource contextSource;
    private DirContextValidator dirContextValidator;

    DirContextPoolableObjectFactory() {
    }

    public ContextSource getContextSource() {
        return this.contextSource;
    }

    public void setContextSource(ContextSource contextSource) {
        if (contextSource == null) {
            throw new IllegalArgumentException("contextSource may not be null");
        }
        this.contextSource = contextSource;
    }

    public DirContextValidator getDirContextValidator() {
        return this.dirContextValidator;
    }

    public void setDirContextValidator(DirContextValidator dirContextValidator) {
        if (dirContextValidator == null) {
            throw new IllegalArgumentException("dirContextValidator may not be null");
        }
        this.dirContextValidator = dirContextValidator;
    }

    public Object makeObject(Object key) throws Exception {
        Validate.notNull((Object)this.contextSource, (String)"ContextSource may not be null");
        Validate.isTrue((boolean)(key instanceof DirContextType), (String)"key must be a DirContextType");
        DirContextType contextType = (DirContextType)key;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating a new " + contextType + " DirContext"));
        }
        if (contextType == DirContextType.READ_WRITE) {
            DirContext readWriteContext = this.contextSource.getReadWriteContext();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created new " + DirContextType.READ_WRITE + " DirContext='" + readWriteContext + "'"));
            }
            return readWriteContext;
        }
        if (contextType == DirContextType.READ_ONLY) {
            DirContext readOnlyContext = this.contextSource.getReadOnlyContext();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created new " + DirContextType.READ_ONLY + " DirContext='" + readOnlyContext + "'"));
            }
            return readOnlyContext;
        }
        throw new IllegalArgumentException("Unrecognized ContextType: " + contextType);
    }

    public boolean validateObject(Object key, Object obj) {
        Validate.notNull((Object)this.dirContextValidator, (String)"DirContextValidator may not be null");
        Validate.isTrue((boolean)(key instanceof DirContextType), (String)"key must be a DirContextType");
        Validate.isTrue((boolean)(obj instanceof DirContext), (String)("The Object to validate must be of type '" + DirContext.class + "'"));
        try {
            DirContextType contextType = (DirContextType)key;
            DirContext dirContext = (DirContext)obj;
            return this.dirContextValidator.validateDirContext(contextType, dirContext);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to validate '" + obj + "' due to an unexpected exception."), (Throwable)e);
            return false;
        }
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        Validate.isTrue((boolean)(obj instanceof DirContext), (String)("The Object to validate must be of type '" + DirContext.class + "'"));
        try {
            DirContext dirContext = (DirContext)obj;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing " + key + " DirContext='" + dirContext + "'"));
            }
            dirContext.close();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closed " + key + " DirContext='" + dirContext + "'"));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("An exception occured while closing '" + obj + "'"), (Throwable)e);
        }
    }
}

