/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.compiler.expressions.CatchAllMultiParameterFunction;
import com.github.sommeri.less4j.core.parser.ConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Color
extends CatchAllMultiParameterFunction {
    Color() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, HiddenTokenAwareTree token) {
        CssString string = (CssString)splitParameters.get(0);
        String text = string.getValue();
        ColorExpression parsedColor = ConversionUtils.parseColor(token, text);
        if (parsedColor == null) {
            FaultyExpression faultyExpression = new FaultyExpression(token);
            problemsHandler.notAColor(faultyExpression, text);
        }
        return parsedColor;
    }

    @Override
    protected int getMinParameters() {
        return 1;
    }

    @Override
    protected int getMaxParameters() {
        return 1;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.STRING_EXPRESSION);
    }

    @Override
    protected String getName() {
        return "color";
    }
}

