/*
 * Decompiled with CFR 0.152.
 */
package org.lesscss;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.lesscss.LessException;
import org.lesscss.LessSource;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessCompiler {
    private static final String COMPILE_STRING = "function doIt(input, compress) { var result; var parser = new less.Parser(); parser.parse(input, function(e, tree) { if (e instanceof Object) { throw e; } ; result = tree.toCSS({compress: compress}); }); return result; }";
    private static final Log log = LogFactory.getLog(LessCompiler.class);
    private URL envJs = LessCompiler.class.getClassLoader().getResource("META-INF/env.rhino.js");
    private URL lessJs = LessCompiler.class.getClassLoader().getResource("META-INF/less.js");
    private List<URL> customJs = Collections.emptyList();
    private boolean compress = false;
    private String encoding = null;
    private Function doIt;
    private Scriptable scope;

    public URL getEnvJs() {
        return this.envJs;
    }

    public synchronized void setEnvJs(URL envJs) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.envJs = envJs;
    }

    public URL getLessJs() {
        return this.lessJs;
    }

    public synchronized void setLessJs(URL lessJs) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.lessJs = lessJs;
    }

    public List<URL> getCustomJs() {
        return Collections.unmodifiableList(this.customJs);
    }

    public synchronized void setCustomJs(URL customJs) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.customJs = Collections.singletonList(customJs);
    }

    public synchronized void setCustomJs(List<URL> customJs) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.customJs = new ArrayList<URL>(customJs);
    }

    public boolean isCompress() {
        return this.compress;
    }

    public synchronized void setCompress(boolean compress) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.compress = compress;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public synchronized void setEncoding(String encoding) {
        if (this.scope != null) {
            throw new IllegalStateException("This method can only be called before init()");
        }
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        long start = System.currentTimeMillis();
        try {
            Context cx = Context.enter();
            cx.setOptimizationLevel(-1);
            cx.setLanguageVersion(170);
            Global global = new Global();
            global.init(cx);
            this.scope = cx.initStandardObjects((ScriptableObject)global);
            ArrayList<URL> jsUrls = new ArrayList<URL>(2 + this.customJs.size());
            jsUrls.add(this.envJs);
            jsUrls.add(this.lessJs);
            jsUrls.addAll(this.customJs);
            for (URL url : jsUrls) {
                InputStreamReader inputStreamReader = new InputStreamReader(url.openConnection().getInputStream());
                try {
                    cx.evaluateReader(this.scope, (Reader)inputStreamReader, url.toString(), 1, null);
                }
                finally {
                    inputStreamReader.close();
                }
            }
            this.doIt = cx.compileFunction(this.scope, COMPILE_STRING, "doIt.js", 1, null);
        }
        catch (Exception e) {
            String message = "Failed to initialize LESS compiler.";
            log.error((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
        finally {
            Context.exit();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished initialization of LESS compiler in " + (System.currentTimeMillis() - start) + " ms."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compile(String input) throws LessException {
        LessCompiler lessCompiler = this;
        synchronized (lessCompiler) {
            if (this.scope == null) {
                this.init();
            }
        }
        long start = System.currentTimeMillis();
        try {
            Context cx = Context.enter();
            Object result = this.doIt.call(cx, this.scope, null, new Object[]{input, this.compress});
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished compilation of LESS source in " + (System.currentTimeMillis() - start) + " ms."));
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            Scriptable value;
            if (e instanceof JavaScriptException && (value = (Scriptable)((JavaScriptException)e).getValue()) != null && ScriptableObject.hasProperty((Scriptable)value, (String)"message")) {
                String message = ScriptableObject.getProperty((Scriptable)value, (String)"message").toString();
                throw new LessException(message, e);
            }
            throw new LessException(e);
        }
        finally {
            Context.exit();
        }
    }

    public String compile(File input) throws IOException, LessException {
        LessSource lessSource = new LessSource(input);
        return this.compile(lessSource);
    }

    public void compile(File input, File output) throws IOException, LessException {
        this.compile(input, output, true);
    }

    public void compile(File input, File output, boolean force) throws IOException, LessException {
        LessSource lessSource = new LessSource(input);
        this.compile(lessSource, output, force);
    }

    public String compile(LessSource input) throws LessException {
        return this.compile(input.getNormalizedContent());
    }

    public void compile(LessSource input, File output) throws IOException, LessException {
        this.compile(input, output, true);
    }

    public void compile(LessSource input, File output, boolean force) throws IOException, LessException {
        if (force || !output.exists() || output.lastModified() < input.getLastModifiedIncludingImports()) {
            String data = this.compile(input);
            FileUtils.writeStringToFile((File)output, (String)data, (String)this.encoding);
        }
    }
}

