/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockBuilder;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.repository.TestRuns;
import com.xebialabs.xltest.service.TestRunStatusProvider;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestRunner
implements TestRunStatusProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestRunner.class);
    private final TestRuns testRuns;
    private IEngine taskExecutionEngine;
    private Map<TestRunId, String> runIdToTaskId = new ConcurrentHashMap<TestRunId, String>();

    @Autowired
    public TestRunner(TestRuns testRuns, IEngine taskExecutionEngine) {
        this.testRuns = testRuns;
        this.taskExecutionEngine = taskExecutionEngine;
    }

    public TestRun run(TestRun testRun, URI eventUri) {
        this.testRuns.addRunOfTestSet(testRun, eventUri);
        LOG.info("Starting new test run for test set id {} on url {}", (Object)testRun.getTestSetDefinition().getId(), (Object)testRun.getUri());
        this.run(testRun);
        return testRun;
    }

    public void run(TestRun testRun) {
        LOG.info("Running job with id " + testRun.getTestRunId() + "; url: " + testRun.getUri());
        BlockBuilder planBuilder = testRun.planWithoutBuilding();
        Block plan = planBuilder.build();
        TaskSpecification taskSpecification = new TaskSpecification(String.format("Test Run %s", testRun.getId()), "owner", plan, null, false, false);
        taskSpecification.getListeners().add(new ExecutionStateMonitor(testRun));
        String taskId = this.taskExecutionEngine.register(taskSpecification);
        this.runIdToTaskId.put(testRun.getTestRunId(), taskId);
        this.taskExecutionEngine.execute(taskId);
    }

    @Override
    public boolean isRunning(TestRunId testRunId) {
        TaskExecutionState state = this.getState(testRunId);
        return !state.isFinal() && state != TaskExecutionState.UNREGISTERED;
    }

    public TaskExecutionState getState(TestRunId testRunId) {
        TestRun testRun;
        String taskId = this.runIdToTaskId.get(testRunId.getTopLevel());
        if (taskId != null) {
            try {
                Task task = this.taskExecutionEngine.retrieve(taskId);
                return task.getState();
            }
            catch (TaskNotFoundException e) {
                LOG.debug("Task not found for " + testRunId);
            }
        }
        if ((testRun = this.testRuns.getTestRun(testRunId)) == null) {
            LOG.debug("Task engine state defaults to UNREGISTERED (testRun == null)");
            return TaskExecutionState.UNREGISTERED;
        }
        if (testRun.isFinished()) {
            LOG.debug("Task engine state defaults to DONE (testRun is finished)");
            return TaskExecutionState.DONE;
        }
        LOG.debug("Task engine state defaults to CANCELLED (not running, not finished)");
        return TaskExecutionState.CANCELLED;
    }

    public void abort(TestRunId testRunId) {
        String taskId = this.runIdToTaskId.get(testRunId.getTopLevel());
        if (taskId != null) {
            this.taskExecutionEngine.abort(taskId);
        }
    }

    private Date finishedTime() {
        return new Date();
    }

    private class ExecutionStateMonitor
    implements ExecutionStateListener {
        private TestRun testRun;

        public ExecutionStateMonitor(TestRun testRun) {
            this.testRun = testRun;
        }

        public void stepStateChanged(StepExecutionStateEvent stepExecutionStateEvent) {
        }

        public void taskStateChanged(TaskExecutionStateEvent taskExecutionStateEvent) {
            TaskWithSteps task = taskExecutionStateEvent.task();
            if (this.canBeArchived(taskExecutionStateEvent.currentState())) {
                this.finishTestRun();
                TestRunner.this.taskExecutionEngine.archive(task.getId());
            } else if (this.isAborted(taskExecutionStateEvent.currentState())) {
                this.finishTestRun();
                TestRunner.this.taskExecutionEngine.cancel(task.getId());
            } else if (this.notRunningAndNeedsToBeResumed(taskExecutionStateEvent.currentState())) {
                LOG.info("Task might have to be resumed (depends on time out or not)");
                this.markFailedStepsAsSkipped(task);
                LOG.info("Task has not timed out, so we start executing it again");
                TestRunner.this.taskExecutionEngine.execute(task.getId());
            }
        }

        private boolean isAborted(TaskExecutionState taskExecutionState) {
            return taskExecutionState == TaskExecutionState.ABORTED;
        }

        private void finishTestRun() {
            TestRunner.this.runIdToTaskId.remove(this.testRun.getId());
            this.testRun.setFinishedTime(TestRunner.this.finishedTime());
            LOG.info("Update test run after execution: with stores " + this.testRun.getUsedStores());
            TestRunner.this.testRuns.updateTestRun(this.testRun);
        }

        private boolean canBeArchived(TaskExecutionState taskExecutionState) {
            return taskExecutionState == TaskExecutionState.EXECUTED;
        }

        private boolean notRunningAndNeedsToBeResumed(TaskExecutionState taskExecutionState) {
            return taskExecutionState == TaskExecutionState.FAILED;
        }

        private void markFailedStepsAsSkipped(TaskWithSteps task) {
            for (StepState stepState : task.getSteps()) {
                LOG.debug("Found step state {} -> {}", (Object)stepState, (Object)stepState.getState());
            }
            for (Integer stepNr : task.getCurrentStepNrs()) {
                StepState stepState = task.getStep(stepNr.intValue());
                LOG.debug("Found current step state {} in state {}", (Object)stepState, (Object)stepState.getState());
                if (stepState.getState() != StepExecutionState.FAILED) continue;
                TestRunner.this.taskExecutionEngine.skipSteps(task.getId(), (List)Lists.newArrayList((Object[])new Integer[]{stepNr}));
            }
        }
    }
}

