/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.TestSetDefinition;
import com.xebialabs.xltest.repository.NotFoundException;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TestSets {
    private final RepositoryService repository;

    @Autowired
    public TestSets(RepositoryService repository) {
        this.repository = repository;
    }

    public void addTestSetDefinition(TestSetDefinition testSetDefinition) {
        this.repository.create((ConfigurationItem[])new TestSetDefinition[]{testSetDefinition});
    }

    public void updateTestSetDefinition(TestSetDefinition testSetDefinition) {
        this.repository.update((ConfigurationItem[])new TestSetDefinition[]{testSetDefinition});
    }

    public <T extends TestSetDefinition> T getTestSetById(String testSetId) {
        TestSetDefinition def = (TestSetDefinition)this.repository.read(testSetId);
        if (def == null) {
            throw new NotFoundException(testSetId);
        }
        return (T)def;
    }

    public Collection<TestSetDefinition> findTestSets() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(TestSetDefinition.class));
        return this.repository.listEntities(query);
    }
}

