/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.net.UrlEscapers;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.Store;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.utils.JsonOverHttpHelper;
import com.xebialabs.xltest.utils.JsonResponseParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="ElasticSearch store base type", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class ElasticSearchStore
extends Store {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchStore.class);
    @Property(description="Base url for elasticSearch, including its index (but without its type) like http://localhost:9200/movies")
    private String url;

    public ElasticSearchStore() {
    }

    public ElasticSearchStore(String url) {
        this.url = url;
    }

    @Override
    public void store(Event event) throws Exception {
        JsonOverHttpHelper jsonOverHttpHelper = new JsonOverHttpHelper();
        JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        String requestContent = jsonProvider.toJson(event.getProperties());
        jsonOverHttpHelper.httpPostRequest(this.url + "/" + event.getType() + "/", requestContent);
        if (jsonOverHttpHelper.statusCode() != 201) {
            LOG.error("Could not store message in ElasticSearchStore. Status code: {}, request: '{}', reponse: '{}'", new Object[]{jsonOverHttpHelper.statusCode(), requestContent, jsonOverHttpHelper.content()});
        }
    }

    @Override
    public List<Event> getEventsOfRun(TestRunId runId) {
        String fullUrl = this.url + "/" + "_search?sort=_ts:asc&q=run_id:" + runId + "&size=1000000";
        LOG.info("Querying ES on url: {} for all events in a run", (Object)fullUrl);
        List<Event> results = this.parseElasticSearchJson(this.retrieveEvents(fullUrl));
        LOG.info("Queried ES on url: {} for all events in a run yielded {} events", (Object)fullUrl, (Object)results.size());
        return results;
    }

    @Override
    public List<Event> getEventsOfRun(TestRunId runId, Map queryParameters) {
        String fullUrl = this.constructUrl(runId, queryParameters);
        LOG.info("Querying ES on url: {} for events in a run filtered by query params", (Object)fullUrl);
        List<Event> results = this.parseElasticSearchJson(this.retrieveEvents(fullUrl));
        LOG.info("Queried ES on url: {} for events in a run filtered by query params yielded {} events", (Object)fullUrl, (Object)results.size());
        return results;
    }

    @Override
    public List<Event> getEventsBetween(long startTime, long endTime, Map queryParameters) {
        String fullUrl = this.constructUrl(startTime, endTime, queryParameters);
        LOG.info("Querying ES on url: {} for events in a timerange filtered by query params", (Object)fullUrl);
        List<Event> results = this.parseElasticSearchJson(this.retrieveEvents(fullUrl));
        LOG.info("Queried ES on url: {} for events in a timerange filtered by query params yielded {} events", (Object)fullUrl, (Object)results.size());
        return results;
    }

    private String retrieveEvents(String fullUrl) {
        JsonOverHttpHelper jsonOverHttpHelper = new JsonOverHttpHelper();
        try {
            jsonOverHttpHelper.httpGetRequest(fullUrl);
        }
        catch (Exception e) {
            LOG.error("Unable to contact elastic search", (Throwable)e);
            return null;
        }
        if (jsonOverHttpHelper.statusCode() != 200) {
            LOG.error("Not a successful elastic search query ({}): {}", (Object)jsonOverHttpHelper.statusCode(), (Object)jsonOverHttpHelper.content());
            return null;
        }
        return jsonOverHttpHelper.content();
    }

    private String constructUrl(TestRunId runId, Map queryParameters) {
        String baseUrl = this.getSearchQueryBase();
        String query = this.constructSearchQuery("run_id:" + runId, queryParameters);
        return baseUrl + query;
    }

    private String constructUrl(long startTime, long endTime, Map queryParameters) {
        String baseUrl = this.getSearchQueryBase();
        String query = this.constructSearchQuery("_ts:>=" + startTime + " AND _ts:<=" + endTime, queryParameters);
        return baseUrl + query;
    }

    private String getSearchQueryBase() {
        return this.url + "/_search?size=1000000&sort=_ts:asc&q=";
    }

    private String constructSearchQuery(String query, Map queryParameters) {
        for (Object key : queryParameters.keySet()) {
            String value = (String)queryParameters.get(key);
            query = query + " AND " + key + ":\"" + value + "\"";
        }
        query = UrlEscapers.urlPathSegmentEscaper().escape(query);
        return query;
    }

    List<Event> parseElasticSearchJson(String content) {
        if (content == null) {
            return Collections.emptyList();
        }
        JsonResponseParser parser = new JsonResponseParser();
        parser.parse(content);
        Integer count = (Integer)parser.getValue("hits.total");
        ArrayList<Event> retrievedEvents = new ArrayList<Event>();
        JsonProvider jsonProvider = parser.getJsonProvider();
        for (int i = 0; i < count; ++i) {
            Object item = parser.getValue("hits.hits[" + i + "]._source");
            if (!jsonProvider.isMap(item)) continue;
            retrievedEvents.add(new Event(jsonProvider.toMap(item)));
        }
        return retrievedEvents;
    }
}

