package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.*;
import java.util.*;

@SuppressWarnings("serial")
@Metadata(description = "Apache Derby store", root= Metadata.ConfigurationItemRoot.CONFIGURATION)
public class DerbySQLStore extends SQLStore {
    private static final Logger LOG = LoggerFactory.getLogger(DerbySQLStore.class);
    private static final String RUN_ID_FIELD = "run_id";

    static {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        } catch (ClassNotFoundException e) {
            // No such driver
        }
    }

	public DerbySQLStore() {
	}

	public DerbySQLStore(String url, String username, String password, String tablename) {
		super(url, username, password, tablename);
	}
	
	@Override
	public String createInsertIntoTableString(Event event) {
		String statementString = "insert into " + getTablename() + "(" + columnDefinitionsAsString() + ") values (" + makeQuestionMarks() + ")";
		LOG.debug("statementString: " + statementString);
		return statementString;
	}

	@Override
	public String columnDefinitionsAsString() {
		// like: testset, result, team
		StringBuilder sb = new StringBuilder();
		if (!getPropertyTypeMap().keySet().isEmpty()) {
			for (String columnname : getOrderedKeys()) {
				sb.append("\"");
				sb.append(columnname);
				sb.append("\", ");
			}
		}
		String columnDefs = sb.toString();
		if (columnDefs.length() > 2) {
			columnDefs = columnDefs.substring(0, columnDefs.length() - 2);
		}
		return columnDefs;
	}

	@Override
	public String createColumnDefinitionsAsString() {
		// like: ( testset varchar(255), result varchar(255), team varchar(255));
		StringBuilder sb = new StringBuilder();
		if (!getPropertyTypeMap().keySet().isEmpty()) {
			for (String columnname : getOrderedKeys()) {
				sb.append("\"");
				sb.append(columnname);
				sb.append("\" ");
				sb.append(getPropertyTypeMap().get(columnname));
				sb.append(", ");
			}
		}
		String columnDefs = sb.toString();
		if (columnDefs.length() > 2) {
			columnDefs = columnDefs.substring(0, columnDefs.length() - 2);
		}
		return "(" + columnDefs + ")";
	}

}
