/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.repository.EventNotifier;
import com.xebialabs.xltest.service.EventRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventDispatcher
implements EventRegistry,
EventNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(EventDispatcher.class);
    private final Multimap<TestRunId, EventHandler> runSpecificHandlers = Multimaps.synchronizedMultimap((Multimap)LinkedListMultimap.create());

    @Override
    public void notify(TestRunId testRunId, Event event) {
        List<EventHandler> runSpecificEventHandlers = this.getRunSpecificEventHandlers(testRunId);
        LOG.info("Invoking " + runSpecificEventHandlers.size() + " handlers for event of type {}", (Object)event.getType());
        for (EventHandler handler : runSpecificEventHandlers) {
            this.invokeEventHandler(testRunId, handler, event);
        }
    }

    public List<EventHandler> getRunSpecificEventHandlers(TestRunId testRunId) {
        ArrayList<EventHandler> eventHandlers = new ArrayList<EventHandler>(16);
        TestRunId id = testRunId;
        while (true) {
            Collection h;
            if ((h = this.runSpecificHandlers.get((Object)id)) != null) {
                eventHandlers.addAll(0, h);
            }
            if (id.isRoot()) break;
            id = id.getParent();
        }
        return eventHandlers;
    }

    protected abstract void invokeEventHandler(TestRunId var1, EventHandler var2, Event var3);

    public void registerHandler(EventHandler handler) {
        this.registerHandler(TestRunId.ROOT, handler);
    }

    @Override
    public void registerHandler(TestRunId runId, EventHandler handler) {
        this.runSpecificHandlers.put((Object)runId, (Object)handler);
    }

    @Override
    public void unregisterAll(TestRunId runId) {
        Iterator iter = this.runSpecificHandlers.keySet().iterator();
        while (iter.hasNext()) {
            if (!((TestRunId)iter.next()).isSameOrChildOf(runId)) continue;
            iter.remove();
        }
    }
}

