/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestRunId;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TestRuns {
    private static Logger LOG = LoggerFactory.getLogger(TestRuns.class);
    public static final String TEST_RUNS_ROOT = "Applications/TestRuns/";
    private final RepositoryService repository;
    private final AutowireCapableBeanFactory beanFactory;

    @Autowired
    public TestRuns(RepositoryService repository, AutowireCapableBeanFactory beanFactory) {
        this.repository = repository;
        this.beanFactory = beanFactory;
    }

    public TestRun addRunOfTestSet(TestRun testRun, URI absolutePath) {
        TestRunId newTestRunId = this.generateNewRunId();
        URI uri = this.getTestRunUrl(absolutePath, newTestRunId);
        testRun.setId(TEST_RUNS_ROOT + newTestRunId.toString());
        testRun.setStartTime(this.startTime());
        testRun.setUri(uri);
        this.beanFactory.autowireBean((Object)testRun);
        this.repository.create((ConfigurationItem[])new TestRun[]{testRun});
        return testRun;
    }

    public void updateTestRun(TestRun testRun) {
        this.repository.update((ConfigurationItem[])new TestRun[]{testRun});
    }

    public TestRun getTestRun(TestRunId testRunId) {
        TestRun testRun = (TestRun)this.repository.read(TEST_RUNS_ROOT + testRunId.toString());
        return testRun;
    }

    private Date startTime() {
        return new Date();
    }

    private TestRunId generateNewRunId() {
        return new TestRunId(UUID.randomUUID().toString());
    }

    private URI getTestRunUrl(URI absolutePath, TestRunId testRunId) {
        return UriBuilder.fromUri((URI)absolutePath).path(testRunId.toString()).build(new Object[0]);
    }

    public Collection<TestRun> getAllTestRuns() {
        return this.getTestRuns(new SearchParameters());
    }

    public Collection<TestRun> getTestRuns(SearchParameters query) {
        query.setType(Type.valueOf(TestRun.class));
        List testRuns = this.repository.listEntities(query);
        Collections.sort(testRuns, new Comparator<TestRun>(){

            @Override
            public int compare(TestRun o1, TestRun o2) {
                if (o1.getStartTime() == null) {
                    return 1;
                }
                if (o2.getStartTime() == null) {
                    return -1;
                }
                return o2.getStartTime().compareTo(o1.getStartTime());
            }
        });
        return testRuns;
    }

    public Map<String, Object> getQualification(TestRunId testRunId) {
        TestRun run = this.getTestRun(testRunId);
        Report qualification = run.getTestSetDefinition().getQualification();
        return this.generateReport(run, qualification, Collections.emptyMap());
    }

    public Map<String, Object> generateReport(TestRunId testRunId, Report report, Map<String, String> queryParameters) {
        TestRun run = this.getTestRun(testRunId);
        return this.generateReport(run, report, queryParameters);
    }

    private Map<String, Object> generateReport(TestRun run, Report report, Map<String, String> queryParameters) {
        if (report != null) {
            this.beanFactory.autowireBean((Object)report);
            report.addAttribute("queryParameters", queryParameters);
            TreeMap<String, Object> resultObject = new TreeMap<String, Object>();
            resultObject.put("type", report.getReportType().toLowerCase());
            resultObject.put("report", report.compute(run));
            return resultObject;
        }
        return Collections.emptyMap();
    }
}

