/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.gmaven.feature.ComponentException;
import org.codehaus.gmaven.feature.Configuration;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.support.ComponentSupport;
import org.codehaus.gmaven.runtime.util.Compiler;

public abstract class CompilerSupport
extends ComponentSupport
implements Compiler {
    protected final Set sources = new HashSet();
    protected File targetDir;
    private URL[] classPath;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected CompilerSupport(Feature feature, Configuration config) {
        super(feature, config);
    }

    protected CompilerSupport(Feature feature) {
        super(feature);
    }

    public void setTargetDirectory(File dir) {
        if (!$assertionsDisabled && dir == null) {
            throw new AssertionError();
        }
        this.targetDir = dir;
    }

    public File getTargetDirectory() {
        if (this.targetDir == null) {
            throw new IllegalStateException("Target directory not bound");
        }
        return this.targetDir;
    }

    public void add(URL source) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        this.sources.add(source);
        this.log.debug("Added: {}", (Object)source);
    }

    public void add(File source) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        try {
            this.add(source.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new ComponentException("Failed to coerce File to URL: " + source, (Throwable)e);
        }
    }

    public Collection sources() {
        return Collections.unmodifiableCollection(this.sources);
    }

    public void setClassPath(URL[] urls) {
        if (!($assertionsDisabled || urls != null && urls.length > 0)) {
            throw new AssertionError();
        }
        this.classPath = urls;
    }

    public URL[] getClassPath() {
        if (this.classPath == null) {
            return new URL[0];
        }
        return this.classPath;
    }

    static {
        $assertionsDisabled = !CompilerSupport.class.desiredAssertionStatus();
    }
}

