/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereFileDirectoryWalker;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OverthereFileCopier
extends OverthereFileDirectoryWalker {
    private static final String SOURCE = "Source";
    private static final String DESTINATION = "Destination";
    private Stack<OverthereFile> dstDirStack = new Stack();
    private OverthereFile srcDir;
    private static Logger logger = LoggerFactory.getLogger(OverthereFileCopier.class);

    private OverthereFileCopier(OverthereFile srcDir, OverthereFile dstDir) {
        this.dstDirStack.push(dstDir);
        this.srcDir = srcDir;
        OverthereFileCopier.checkDirectoryExists(srcDir, SOURCE);
    }

    @Override
    protected void handleDirectoryStart(OverthereFile scrDir, int depth) throws IOException {
        OverthereFile dstDir = this.getCurrentDestinationDir();
        if (depth != 0) {
            dstDir = this.createSubdirectoryAndMakeCurrent(dstDir, scrDir.getName());
        }
        if (dstDir.exists()) {
            OverthereFileCopier.checkReallyIsADirectory(dstDir, DESTINATION);
            logger.debug("About to copy files into existing directory {}", (Object)dstDir);
        } else {
            logger.debug("Creating destination directory {}", (Object)dstDir);
            dstDir.mkdir();
        }
    }

    private OverthereFile createSubdirectoryAndMakeCurrent(OverthereFile parentDir, String subdirName) {
        OverthereFile subdir = parentDir.getFile(subdirName);
        this.dstDirStack.push(subdir);
        return subdir;
    }

    private void startCopy() {
        this.walk(this.srcDir);
    }

    private OverthereFile getCurrentDestinationDir() {
        return this.dstDirStack.peek();
    }

    @Override
    protected void handleFile(OverthereFile srcFile, int depth) throws IOException {
        OverthereFile dstFile = this.getCurrentDestinationDir().getFile(srcFile.getName());
        OverthereFileCopier.copyFile(srcFile, dstFile);
    }

    @Override
    protected void handleDirectoryEnd(OverthereFile directory, int depth) throws IOException {
        if (depth != 0) {
            this.dstDirStack.pop();
        }
    }

    public static void copy(OverthereFile src, OverthereFile dst) {
        if (src.isDirectory()) {
            OverthereFileCopier.copyDirectory(src, dst);
        } else {
            OverthereFileCopier.copyFile(src, dst);
        }
    }

    private static void copyDirectory(OverthereFile srcDir, OverthereFile dstDir) throws RuntimeIOException {
        OverthereFileCopier dirCopier = new OverthereFileCopier(srcDir, dstDir);
        dirCopier.startCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(OverthereFile srcFile, OverthereFile dstFile) throws RuntimeIOException {
        OverthereFileCopier.checkFileExists(srcFile, SOURCE);
        OverthereFileCopier.checkReallyIsAFile(dstFile, DESTINATION);
        if (dstFile.exists()) {
            logger.debug("About to overwrite existing file {}", (Object)dstFile);
        }
        ConnectionOptions options = srcFile.getConnection().getOptions();
        int bufferSize = options.getInteger("remoteCopyBufferSize", 65536);
        logger.debug("Copying file {} to {} with buffer size {}", new Object[]{srcFile, dstFile, bufferSize});
        try {
            InputStream is = srcFile.getInputStream();
            try {
                OutputStream os = dstFile.getOutputStream();
                try {
                    OverthereFileCopier.copy(is, os, bufferSize);
                }
                finally {
                    OverthereUtils.closeQuietly(os);
                }
            }
            finally {
                OverthereUtils.closeQuietly(is);
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot copy " + srcFile + " to " + dstFile, exc);
        }
    }

    private static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    private static void checkFileExists(OverthereFile file, String sourceDescription) {
        if (!file.exists()) {
            throw new RuntimeIOException(sourceDescription + " file " + file + " does not exist");
        }
        OverthereFileCopier.checkReallyIsAFile(file, sourceDescription);
    }

    private static void checkReallyIsAFile(OverthereFile file, String fileDescription) {
        if (file.exists() && file.isDirectory()) {
            throw new RuntimeIOException(fileDescription + " file " + file + " exists but is a directory");
        }
    }

    private static void checkDirectoryExists(OverthereFile dir, String dirDescription) {
        if (!dir.exists()) {
            throw new RuntimeIOException(dirDescription + " directory " + dir + " does not exist");
        }
        OverthereFileCopier.checkReallyIsADirectory(dir, dirDescription);
    }

    private static void checkReallyIsADirectory(OverthereFile dir, String dirDescription) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new RuntimeIOException(dirDescription + " directory " + dir + " exists but is not a directory");
        }
    }
}

