/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.AssertionFailedError;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.Validate;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.AbstractUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.DefaultUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;
import ro.isdc.wro.util.Function;
import ro.isdc.wro.util.Transformer;
import ro.isdc.wro.util.Transformers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WroTestUtils.class);

    public static BaseWroManagerFactory simpleManagerFactory() {
        return new BaseWroManagerFactory().setModelFactory(WroTestUtils.simpleModelFactory(new WroModel()));
    }

    public static void compareProcessedResourceContents(String inputResourceUri, String expectedContentResourceUri, ResourcePostProcessor processor) throws IOException {
        Reader resultReader = WroTestUtils.getReaderFromUri(inputResourceUri);
        Reader expectedReader = WroTestUtils.getReaderFromUri(expectedContentResourceUri);
        WroTestUtils.compare(resultReader, expectedReader, processor);
    }

    private static Reader getReaderFromUri(String uri) throws IOException {
        return new BufferedReader(new InputStreamReader(WroTestUtils.createDefaultUriLocatorFactory().locate(uri)));
    }

    private static UriLocatorFactory createDefaultUriLocatorFactory() {
        return new DefaultUriLocatorFactory();
    }

    public static InputStream getInputStream(String uri) throws IOException {
        return WroTestUtils.createDefaultUriLocatorFactory().locate(uri);
    }

    public static void init(WroModelFactory factory) {
        BaseWroManagerFactory managerFactroy = new BaseWroManagerFactory().setModelFactory(factory);
        InjectorBuilder.create(managerFactroy).build().inject(factory);
    }

    public static void initProcessor(ResourcePreProcessor processor) {
        BaseWroManagerFactory factory = new BaseWroManagerFactory();
        factory.setProcessorsFactory(new SimpleProcessorsFactory().addPreProcessor(processor));
        Injector injector = InjectorBuilder.create(factory).build();
        injector.inject(processor);
    }

    public static void initProcessor(ResourcePostProcessor processor) {
        WroTestUtils.initProcessor(new ProcessorDecorator(processor));
    }

    public static void compare(Reader resultReader, Reader expectedReader, ResourcePostProcessor processor) throws IOException {
        StringWriter resultWriter = new StringWriter();
        processor.process(resultReader, resultWriter);
        StringWriter expectedWriter = new StringWriter();
        IOUtils.copy((Reader)expectedReader, (Writer)expectedWriter);
        WroTestUtils.compare(((Object)expectedWriter).toString(), ((Object)resultWriter).toString());
        expectedReader.close();
        ((Writer)expectedWriter).close();
    }

    public static void compare(InputStream input, InputStream expected, ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compare(new InputStreamReader(input), new InputStreamReader(expected), processor);
    }

    public static void compare(InputStream expected, InputStream actual) throws IOException {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        String encoding = Context.get().getConfig().getEncoding();
        WroTestUtils.compare(IOUtils.toString((InputStream)expected, (String)encoding), IOUtils.toString((InputStream)actual, (String)encoding));
        expected.close();
        actual.close();
    }

    public static void compare(String expected, String actual) {
        try {
            String in = WroTestUtils.replaceTabsWithSpaces(expected.trim());
            String out = WroTestUtils.replaceTabsWithSpaces(actual.trim());
            Assert.assertEquals((Object)in, (Object)out);
            LOG.debug("Compare.... [OK]");
        }
        catch (ComparisonFailure e) {
            LOG.error("Compare.... [FAIL]", (Object)e.getMessage());
            throw e;
        }
    }

    private static String replaceTabsWithSpaces(String input) {
        return input.replaceAll("\\t", "  ").replaceAll("\\r", "");
    }

    public static void compareFromSameFolder(File sourceFolder, IOFileFilter sourceFileFilter, Transformer<String> toTargetFileName, final ResourcePreProcessor processor) {
        Collection files = FileUtils.listFiles((File)sourceFolder, (IOFileFilter)sourceFileFilter, (IOFileFilter)FalseFileFilter.INSTANCE);
        int processedNumber = 0;
        for (final File file : files) {
            LOG.debug("processing: {}", (Object)file.getName());
            File targetFile = null;
            try {
                targetFile = new File(sourceFolder, toTargetFileName.transform(file.getName()));
                FileInputStream targetFileStream = new FileInputStream(targetFile);
                LOG.debug("comparing with: {}", (Object)targetFile.getName());
                try {
                    WroTestUtils.compare(new FileInputStream(file), targetFileStream, new ResourcePostProcessor(){

                        public void process(Reader reader, Writer writer) throws IOException {
                            processor.process(Resource.create("file:" + file.getPath(), ResourceType.CSS), reader, writer);
                        }
                    });
                }
                catch (ComparisonFailure e) {
                    LOG.error("Failed comparing: {}", (Object)file.getName());
                    throw e;
                }
                ++processedNumber;
            }
            catch (IOException e) {
                LOG.debug("Skip comparison because couldn't find the TARGET file {}. Original cause: {}", targetFile, (Object)e.getCause());
            }
            catch (Exception e) {
                throw WroRuntimeException.wrap(e);
            }
        }
        WroTestUtils.logSuccess(processedNumber);
    }

    private static void logSuccess(int size) {
        if (size == 0) {
            throw new IllegalStateException("No files compared. Check if there is at least one resource to compare");
        }
        LOG.debug("===============");
        LOG.debug("Successfully processed: {} files.", (Object)size);
        LOG.debug("===============");
    }

    public static void compareFromDifferentFolders(File sourceFolder, File targetFolder, ResourcePreProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, TrueFileFilter.TRUE, Transformers.noOpTransformer(), processor);
    }

    public static void compareFromDifferentFoldersByExtension(File sourceFolder, File targetFolder, String extension, ResourcePreProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, (IOFileFilter)new WildcardFileFilter("*." + extension), Transformers.noOpTransformer(), processor);
    }

    public static void compareFromDifferentFoldersByExtension(File sourceFolder, File targetFolder, String extension, ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, (IOFileFilter)new WildcardFileFilter("*." + extension), Transformers.noOpTransformer(), processor);
    }

    public static void compareFromDifferentFoldersByName(File sourceFolder, File targetFolder, String srcExtension, String targetExtension, ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, (IOFileFilter)new WildcardFileFilter("*." + srcExtension), Transformers.extensionTransformer("css"), processor);
    }

    private static void compareFromDifferentFolders(File sourceFolder, File targetFolder, IOFileFilter fileFilter, Transformer<String> toTargetFileName, final ResourcePostProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, fileFilter, toTargetFileName, new ResourcePreProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                processor.process(reader, writer);
            }
        });
    }

    public static void forEachFileInFolder(File folder, Function<File, Void> function) {
        Validate.notNull(function);
        Collection files = FileUtils.listFiles((File)folder, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)FalseFileFilter.INSTANCE);
        int processedNumber = 0;
        for (File file : files) {
            try {
                function.apply(file);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem while applying function on file: " + file, e);
            }
            ++processedNumber;
        }
        WroTestUtils.logSuccess(processedNumber);
    }

    private static void compareFromDifferentFolders(File sourceFolder, File targetFolder, IOFileFilter fileFilter, Transformer<String> toTargetFileName, final ResourcePreProcessor preProcessor) throws IOException {
        LOG.debug("sourceFolder: {}", (Object)sourceFolder);
        LOG.debug("targetFolder: {}", (Object)targetFolder);
        Collection files = FileUtils.listFiles((File)sourceFolder, (IOFileFilter)fileFilter, (IOFileFilter)FalseFileFilter.INSTANCE);
        int processedNumber = 0;
        for (final File file : files) {
            File targetFile = null;
            try {
                targetFile = new File(targetFolder, toTargetFileName.transform(file.getName()));
                FileInputStream targetFileStream = new FileInputStream(targetFile);
                LOG.debug("=========== processing: {} ===========", (Object)file.getName());
                try {
                    WroTestUtils.compare(new FileInputStream(file), targetFileStream, new ResourcePostProcessor(){

                        public void process(Reader reader, Writer writer) throws IOException {
                            ResourceType resourceType = ResourceType.CSS;
                            try {
                                resourceType = ResourceType.get(FilenameUtils.getExtension((String)file.getPath()));
                            }
                            catch (IllegalArgumentException e) {
                                LOG.warn("unkown resource type for file: {}, assuming resource type is: {}", (Object)file.getPath(), (Object)resourceType);
                            }
                            try {
                                preProcessor.process(Resource.create("file:" + file.getPath(), resourceType), reader, writer);
                            }
                            catch (Exception e) {
                                LOG.error("processing failed...", (Throwable)e);
                                throw WroRuntimeException.wrap(e, "Processing failed...");
                            }
                        }
                    });
                }
                catch (ComparisonFailure e) {
                    LOG.error("failed comparing: {}", (Object)file.getName());
                    throw e;
                }
                ++processedNumber;
            }
            catch (IOException e) {
                LOG.debug("Skip comparison because couldn't find the TARGET file {}\n. Original exception: {}", targetFile, (Object)e.getCause());
            }
            catch (Exception e) {
                throw WroRuntimeException.wrap(e, "A problem during transformation occured");
            }
        }
        WroTestUtils.logSuccess(processedNumber);
    }

    public static void runConcurrently(Callable<Void> task, int times) throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(5);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int i = 0; i < times; ++i) {
            futures.add(service.submit(task));
        }
        for (Future future : futures) {
            future.get();
        }
    }

    public static void runConcurrently(Callable<Void> task) throws Exception {
        WroTestUtils.runConcurrently(task, 50);
    }

    public static Injector createInjector() {
        return InjectorBuilder.create(new BaseWroManagerFactory()).build();
    }

    public static WroModelFactory simpleModelFactory(final WroModel model) {
        Validate.notNull((Object)model);
        return new WroModelFactory(){

            public WroModel create() {
                return model;
            }

            public void destroy() {
            }
        };
    }

    public static void assertProcessorSupportResourceTypes(ResourcePreProcessor processor, ResourceType ... expectedResourceTypes) {
        ResourceType[] actualResourceTypes = new ProcessorDecorator(processor).getSupportedResourceTypes();
        try {
            Assert.assertTrue((boolean)Arrays.equals((Object[])expectedResourceTypes, (Object[])actualResourceTypes));
        }
        catch (AssertionFailedError e) {
            String message = "actual resourceTypes: " + Arrays.toString((Object[])actualResourceTypes) + ", expected are: " + Arrays.toString((Object[])expectedResourceTypes);
            LOG.error(message);
            Assert.fail((String)message);
        }
    }

    public static UriLocatorFactory createResourceMockingLocatorFactory() {
        return new AbstractUriLocatorFactory(){

            public UriLocator getInstance(String uri) {
                return WroTestUtils.createResourceMockingLocator();
            }
        };
    }

    public static UriLocator createResourceMockingLocator() {
        return new UriLocator(){

            public InputStream locate(String uri) throws IOException {
                return new ByteArrayInputStream(uri.getBytes());
            }

            public boolean accept(String uri) {
                return true;
            }
        };
    }
}

