/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.util.LazyInitializer;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerHelper.class);
    private final LazyInitializer<ScheduledThreadPoolExecutor> poolInitializer = new LazyInitializer<ScheduledThreadPoolExecutor>(){

        @Override
        protected ScheduledThreadPoolExecutor initialize() {
            return new ScheduledThreadPoolExecutor(1, WroUtil.createDaemonThreadFactory(SchedulerHelper.this.name)){

                public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
                    return false;
                }
            };
        }
    };
    private final LazyInitializer<Runnable> lazyRunnable;
    private volatile long period = 0L;
    private final String name;
    private ScheduledFuture<?> future;

    private SchedulerHelper(LazyInitializer<Runnable> lazyRunnable) {
        this(lazyRunnable, null);
    }

    private SchedulerHelper(LazyInitializer<Runnable> lazyRunnable, String name) {
        Validate.notNull(lazyRunnable);
        this.name = name;
        this.lazyRunnable = lazyRunnable;
    }

    public static SchedulerHelper create(LazyInitializer<Runnable> runnableFactory, String name) {
        return new SchedulerHelper(runnableFactory, name);
    }

    public static SchedulerHelper create(LazyInitializer<Runnable> runnableFactory) {
        return new SchedulerHelper(runnableFactory);
    }

    public SchedulerHelper scheduleWithPeriod(long period, TimeUnit timeUnit) {
        Validate.notNull((Object)((Object)timeUnit));
        LOG.debug("period: {} [{}]", (Object)period, (Object)timeUnit);
        if (this.period != period) {
            this.period = period;
            if (!this.poolInitializer.get().isShutdown()) {
                this.startScheduler(period, timeUnit);
            } else {
                LOG.warn("Cannot schedule because destroy was already called!");
            }
        }
        return this;
    }

    private synchronized void startScheduler(long period, TimeUnit timeUnit) {
        this.cancelRunningTask();
        if (period > 0L) {
            Runnable runnable = this.lazyRunnable.get();
            Validate.notNull((Object)runnable);
            if (!this.poolInitializer.get().isShutdown()) {
                LOG.debug("[START] Scheduling thread with period of {} {}. ThreadId:  {}", new Object[]{period, timeUnit, Thread.currentThread().getId()});
                long initialDelay = period;
                this.future = this.poolInitializer.get().scheduleWithFixedDelay(runnable, initialDelay, period, timeUnit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void destroyScheduler() {
        if (!this.poolInitializer.get().isShutdown()) {
            this.poolInitializer.get().shutdown();
            if (this.future != null) {
                this.future.cancel(true);
            }
            try {
                while (!this.poolInitializer.get().awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOG.debug("Termination awaited: {}", (Object)this.name);
                    this.poolInitializer.get().shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted Exception occured during scheduler destroy", (Throwable)e);
                this.poolInitializer.get().shutdownNow();
                Thread.currentThread().interrupt();
            }
            finally {
                LOG.debug("[STOP] Scheduler terminated successfully! {}", (Object)this.name);
            }
        }
    }

    private void cancelRunningTask() {
        if (this.future != null) {
            this.future.cancel(false);
            LOG.debug("[STOP] Scheduler terminated successfully! {}", (Object)this.name);
        }
    }

    public SchedulerHelper scheduleWithPeriod(long period) {
        this.scheduleWithPeriod(period, TimeUnit.SECONDS);
        return this;
    }

    public void destroy() {
        this.destroyScheduler();
    }

    long getPeriod() {
        return this.period;
    }
}

